/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.auth;

import com.gradle.maven.extension.internal.dep.org.apache.http.auth.Credentials;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.NTUserPrincipal;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.LangUtils;
import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;

public class NTCredentials
implements Serializable,
Credentials {
    private final NTUserPrincipal principal;
    private final String password;
    private final String workstation;

    public NTCredentials(String string, String string2, String string3, String string4) {
        Args.notNull(string, "User name");
        this.principal = new NTUserPrincipal(string4, string);
        this.password = string2;
        this.workstation = string3 != null ? string3.toUpperCase(Locale.ROOT) : null;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getUsername();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.principal.getDomain();
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.principal);
        n2 = LangUtils.hashCode(n2, this.workstation);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NTCredentials) {
            NTCredentials nTCredentials = (NTCredentials)object;
            if (LangUtils.equals(this.principal, nTCredentials.principal) && LangUtils.equals(this.workstation, nTCredentials.workstation)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[principal: ");
        stringBuilder.append(this.principal);
        stringBuilder.append("][workstation: ");
        stringBuilder.append(this.workstation);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

