/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AbstractFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AndFileFilter
extends AbstractFileFilter
implements Serializable {
    private final List<IOFileFilter> fileFilters;

    public AndFileFilter() {
        this(0);
    }

    private AndFileFilter(ArrayList<IOFileFilter> arrayList) {
        this.fileFilters = Objects.requireNonNull(arrayList, "initialList");
    }

    private AndFileFilter(int n2) {
        this(new ArrayList<IOFileFilter>(n2));
    }

    public AndFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        this(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    @Override
    public boolean accept(File file) {
        return !this.isEmpty() && this.fileFilters.stream().allMatch(iOFileFilter -> iOFileFilter.accept(file));
    }

    @Override
    public boolean accept(File file, String string) {
        return !this.isEmpty() && this.fileFilters.stream().allMatch(iOFileFilter -> iOFileFilter.accept(file, string));
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return this.isEmpty() ? FileVisitResult.TERMINATE : AndFileFilter.toDefaultFileVisitResult(this.fileFilters.stream().allMatch(iOFileFilter -> iOFileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE));
    }

    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(Objects.requireNonNull(iOFileFilter, "fileFilter"));
    }

    private boolean isEmpty() {
        return this.fileFilters.isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        this.append(this.fileFilters, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

