/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        super(Unpooled.buffer(0));
    }

    public CloseWebSocketFrame(WebSocketCloseStatus webSocketCloseStatus) {
        this(CloseWebSocketFrame.requireValidStatusCode(webSocketCloseStatus.code()), webSocketCloseStatus.reasonText());
    }

    public CloseWebSocketFrame(WebSocketCloseStatus webSocketCloseStatus, String string) {
        this(CloseWebSocketFrame.requireValidStatusCode(webSocketCloseStatus.code()), string);
    }

    public CloseWebSocketFrame(int n2, String string) {
        this(true, 0, CloseWebSocketFrame.requireValidStatusCode(n2), string);
    }

    public CloseWebSocketFrame(boolean bl2, int n2, int n3, String string) {
        super(bl2, n2, CloseWebSocketFrame.newBinaryData(CloseWebSocketFrame.requireValidStatusCode(n3), string));
    }

    private static ByteBuf newBinaryData(int n2, String string) {
        if (string == null) {
            string = "";
        }
        ByteBuf byteBuf = Unpooled.buffer(2 + string.length());
        byteBuf.writeShort(n2);
        if (!string.isEmpty()) {
            byteBuf.writeCharSequence(string, CharsetUtil.UTF_8);
        }
        return byteBuf;
    }

    public CloseWebSocketFrame(boolean bl2, int n2, ByteBuf byteBuf) {
        super(bl2, n2, byteBuf);
    }

    public int statusCode() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.readableBytes() < 2) {
            return -1;
        }
        return byteBuf.getUnsignedShort(byteBuf.readerIndex());
    }

    public String reasonText() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.readableBytes() <= 2) {
            return "";
        }
        return byteBuf.toString(byteBuf.readerIndex() + 2, byteBuf.readableBytes() - 2, CharsetUtil.UTF_8);
    }

    @Override
    public CloseWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public CloseWebSocketFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    static int requireValidStatusCode(int n2) {
        if (WebSocketCloseStatus.isValidStatusCode(n2)) {
            return n2;
        }
        throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC-6455: " + n2);
    }
}

