/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.socket;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelException;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOption;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.MessageSizeEstimator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ServerChannelRecvByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.WriteBufferWaterMark;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.ServerSocketChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.ServerSocketChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.util.NetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.net.ServerSocket;
import java.net.SocketException;

public class DefaultServerSocketChannelConfig
extends DefaultChannelConfig
implements ServerSocketChannelConfig {
    protected final ServerSocket javaSocket;
    private volatile int backlog = NetUtil.SOMAXCONN;

    public DefaultServerSocketChannelConfig(ServerSocketChannel serverSocketChannel, ServerSocket serverSocket) {
        super(serverSocketChannel, new ServerChannelRecvByteBufAllocator());
        this.javaSocket = ObjectUtil.checkNotNull(serverSocket, "javaSocket");
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == ChannelOption.SO_BACKLOG) {
            return (T)Integer.valueOf(this.getBacklog());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t2);
        } else if (channelOption == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t2);
        } else if (channelOption == ChannelOption.SO_BACKLOG) {
            this.setBacklog((Integer)t2);
        } else {
            return super.setOption(channelOption, t2);
        }
        return true;
    }

    public boolean isReuseAddress() {
        try {
            return this.javaSocket.getReuseAddress();
        }
        catch (SocketException socketException) {
            throw new ChannelException(socketException);
        }
    }

    public ServerSocketChannelConfig setReuseAddress(boolean bl2) {
        try {
            this.javaSocket.setReuseAddress(bl2);
        }
        catch (SocketException socketException) {
            throw new ChannelException(socketException);
        }
        return this;
    }

    public int getReceiveBufferSize() {
        try {
            return this.javaSocket.getReceiveBufferSize();
        }
        catch (SocketException socketException) {
            throw new ChannelException(socketException);
        }
    }

    public ServerSocketChannelConfig setReceiveBufferSize(int n2) {
        try {
            this.javaSocket.setReceiveBufferSize(n2);
        }
        catch (SocketException socketException) {
            throw new ChannelException(socketException);
        }
        return this;
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    public ServerSocketChannelConfig setBacklog(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "backlog");
        this.backlog = n2;
        return this;
    }

    @Override
    public ServerSocketChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    @Deprecated
    public ServerSocketChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setAutoRead(boolean bl2) {
        super.setAutoRead(bl2);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }
}

