/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.WeakHashMap;

final class ChannelHandlerMask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerMask.class);
    private static final FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>> MASKS = new FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>>(){

        @Override
        protected Map<Class<? extends ChannelHandler>, Integer> initialValue() {
            return new WeakHashMap<Class<? extends ChannelHandler>, Integer>(32);
        }
    };

    static int mask(Class<? extends ChannelHandler> clazz) {
        Map<Class<? extends ChannelHandler>, Integer> map = MASKS.get();
        Integer n2 = map.get(clazz);
        if (n2 == null) {
            n2 = ChannelHandlerMask.mask0(clazz);
            map.put(clazz, n2);
        }
        return n2;
    }

    private static int mask0(Class<? extends ChannelHandler> clazz) {
        int n2 = 1;
        try {
            if (ChannelInboundHandler.class.isAssignableFrom(clazz)) {
                n2 |= 0x1FF;
                if (ChannelHandlerMask.isSkippable(clazz, "channelRegistered", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFFFFD;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelUnregistered", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFFFFB;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelActive", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFFFF7;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelInactive", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFFFEF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelRead", ChannelHandlerContext.class, Object.class)) {
                    n2 &= 0xFFFFFFDF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelReadComplete", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFFFBF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelWritabilityChanged", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFFEFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "userEventTriggered", ChannelHandlerContext.class, Object.class)) {
                    n2 &= 0xFFFFFF7F;
                }
            }
            if (ChannelOutboundHandler.class.isAssignableFrom(clazz)) {
                n2 |= 0x1FE01;
                if (ChannelHandlerMask.isSkippable(clazz, "bind", ChannelHandlerContext.class, SocketAddress.class, ChannelPromise.class)) {
                    n2 &= 0xFFFFFDFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "connect", ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class, ChannelPromise.class)) {
                    n2 &= 0xFFFFFBFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "disconnect", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n2 &= 0xFFFFF7FF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "close", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n2 &= 0xFFFFEFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "deregister", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n2 &= 0xFFFFDFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "read", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFFBFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "write", ChannelHandlerContext.class, Object.class, ChannelPromise.class)) {
                    n2 &= 0xFFFF7FFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "flush", ChannelHandlerContext.class)) {
                    n2 &= 0xFFFEFFFF;
                }
            }
            if (ChannelHandlerMask.isSkippable(clazz, "exceptionCaught", ChannelHandlerContext.class, Throwable.class)) {
                n2 &= 0xFFFFFFFE;
            }
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return n2;
    }

    private static boolean isSkippable(final Class<?> clazz, final String string, final Class<?> ... classArray) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                Method method;
                try {
                    method = clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Class {} missing method {}, assume we can not skip execution", clazz, string, noSuchMethodException);
                    }
                    return false;
                }
                return method.isAnnotationPresent(Skip.class);
            }
        });
    }

    private ChannelHandlerMask() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Skip {
    }
}

