/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;

public final class Longs {
    public static int hashCode(long l2) {
        return (int)(l2 ^ l2 >>> 32);
    }

    private static int indexOf(long[] lArray, long l2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (lArray[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(long[] lArray, long l2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (lArray[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    public static long fromBytes(byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9) {
        return ((long)by2 & 0xFFL) << 56 | ((long)by3 & 0xFFL) << 48 | ((long)by4 & 0xFFL) << 40 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 24 | ((long)by7 & 0xFFL) << 16 | ((long)by8 & 0xFFL) << 8 | (long)by9 & 0xFFL;
    }

    public static Long tryParse(String string, int n2) {
        int n3;
        int n4;
        if (Preconditions.checkNotNull(string).isEmpty()) {
            return null;
        }
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + n2);
        }
        boolean bl2 = string.charAt(0) == '-';
        int n5 = n4 = bl2 ? 1 : 0;
        if (n4 == string.length()) {
            return null;
        }
        if ((n3 = AsciiDigits.digit(string.charAt(n4++))) < 0 || n3 >= n2) {
            return null;
        }
        long l2 = -n3;
        long l3 = Long.MIN_VALUE / (long)n2;
        while (n4 < string.length()) {
            if ((n3 = AsciiDigits.digit(string.charAt(n4++))) < 0 || n3 >= n2 || l2 < l3) {
                return null;
            }
            if ((l2 *= (long)n2) < Long.MIN_VALUE + (long)n3) {
                return null;
            }
            l2 -= (long)n3;
        }
        if (bl2) {
            return l2;
        }
        if (l2 == Long.MIN_VALUE) {
            return null;
        }
        return -l2;
    }

    public static List<Long> asList(long ... lArray) {
        if (lArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(lArray);
    }

    private static class LongArrayAsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        final long[] array;
        final int start;
        final int end;

        LongArrayAsList(long[] lArray) {
            this(lArray, 0, lArray.length);
        }

        LongArrayAsList(long[] lArray, int n2, int n3) {
            this.array = lArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Long && Longs.indexOf(this.array, (Long)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Long && (n2 = Longs.indexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Long && (n2 = Longs.lastIndexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int n2, Long l2) {
            Preconditions.checkElementIndex(n2, this.size());
            long l3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(l2);
            return l3;
        }

        @Override
        public List<Long> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList longArrayAsList = (LongArrayAsList)object;
                int n2 = this.size();
                if (longArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == longArrayAsList.array[longArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Longs.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 10);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        static int digit(char c2) {
            return c2 < '\u0080' ? asciiDigits[c2] : -1;
        }

        static {
            int n2;
            byte[] byArray = new byte[128];
            Arrays.fill(byArray, (byte)-1);
            for (n2 = 0; n2 < 10; ++n2) {
                byArray[48 + n2] = (byte)n2;
            }
            for (n2 = 0; n2 < 26; ++n2) {
                byArray[65 + n2] = (byte)(10 + n2);
                byArray[97 + n2] = (byte)(10 + n2);
            }
            asciiDigits = byArray;
        }
    }
}

