/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Member;
import java.util.HashMap;

public class CreatorCollector {
    protected static final String[] TYPE_DESCS = new String[]{"default", "from-String", "from-int", "from-long", "from-big-integer", "from-double", "from-big-decimal", "from-boolean", "delegate", "property-based", "array-delegate"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[11];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;

    public CreatorCollector(BeanDescription beanDescription, MapperConfig<?> mapperConfig) {
        this._beanDesc = beanDescription;
        this._canFixAccess = mapperConfig.canOverrideAccessModifiers();
        this._forceAccess = mapperConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    public ValueInstantiator constructValueInstantiator(DeserializationContext deserializationContext) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = this._computeDelegateType(deserializationContext, this._creators[8], this._delegateArgs);
        JavaType javaType2 = this._computeDelegateType(deserializationContext, this._creators[10], this._arrayDelegateArgs);
        JavaType javaType3 = this._beanDesc.getType();
        StdValueInstantiator stdValueInstantiator = new StdValueInstantiator(deserializationConfig, javaType3);
        stdValueInstantiator.configureFromObjectSettings(this._creators[0], this._creators[8], javaType, this._delegateArgs, this._creators[9], this._propertyBasedArgs);
        stdValueInstantiator.configureFromArraySettings(this._creators[10], javaType2, this._arrayDelegateArgs);
        stdValueInstantiator.configureFromStringCreator(this._creators[1]);
        stdValueInstantiator.configureFromIntCreator(this._creators[2]);
        stdValueInstantiator.configureFromLongCreator(this._creators[3]);
        stdValueInstantiator.configureFromBigIntegerCreator(this._creators[4]);
        stdValueInstantiator.configureFromDoubleCreator(this._creators[5]);
        stdValueInstantiator.configureFromBigDecimalCreator(this._creators[6]);
        stdValueInstantiator.configureFromBooleanCreator(this._creators[7]);
        return stdValueInstantiator;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._creators[0] = this._fixAccess(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 1, bl2);
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 2, bl2);
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 3, bl2);
    }

    public void addBigIntegerCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 4, bl2);
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 5, bl2);
    }

    public void addBigDecimalCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 6, bl2);
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 7, bl2);
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, boolean bl2, SettableBeanProperty[] settableBeanPropertyArray, int n2) {
        if (annotatedWithParams.getParameterType(n2).isCollectionLikeType()) {
            if (this.verifyNonDup(annotatedWithParams, 10, bl2)) {
                this._arrayDelegateArgs = settableBeanPropertyArray;
            }
        } else if (this.verifyNonDup(annotatedWithParams, 8, bl2)) {
            this._delegateArgs = settableBeanPropertyArray;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams annotatedWithParams, boolean bl2, SettableBeanProperty[] settableBeanPropertyArray) {
        if (this.verifyNonDup(annotatedWithParams, 9, bl2)) {
            if (settableBeanPropertyArray.length > 1) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                int n2 = settableBeanPropertyArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Integer n3;
                    String string = settableBeanPropertyArray[i2].getName();
                    if (string.isEmpty() && settableBeanPropertyArray[i2].getInjectableValueId() != null || (n3 = hashMap.put(string, i2)) == null) continue;
                    throw new IllegalArgumentException(String.format("Duplicate creator property \"%s\" (index %s vs %d) for type %s ", string, n3, i2, ClassUtil.nameOf(this._beanDesc.getBeanClass())));
                }
            }
            this._propertyBasedArgs = settableBeanPropertyArray;
        }
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[8] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[9] != null;
    }

    private JavaType _computeDelegateType(DeserializationContext deserializationContext, AnnotatedWithParams annotatedWithParams, SettableBeanProperty[] settableBeanPropertyArray) throws JsonMappingException {
        if (!this._hasNonDefaultCreator || annotatedWithParams == null) {
            return null;
        }
        int n2 = 0;
        if (settableBeanPropertyArray != null) {
            int n3 = settableBeanPropertyArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (settableBeanPropertyArray[i2] != null) continue;
                n2 = i2;
                break;
            }
        }
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = annotatedWithParams.getParameterType(n2);
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(n2);
            Object object = annotationIntrospector.findDeserializer(annotatedParameter);
            if (object != null) {
                JsonDeserializer<Object> jsonDeserializer = deserializationContext.deserializerInstance(annotatedParameter, object);
                javaType = javaType.withValueHandler(jsonDeserializer);
            } else {
                javaType = annotationIntrospector.refineDeserializationType(deserializationConfig, annotatedParameter, javaType);
            }
        }
        return javaType;
    }

    private <T extends AnnotatedMember> T _fixAccess(T t2) {
        if (t2 != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t2.getAnnotated()), this._forceAccess);
        }
        return t2;
    }

    protected boolean verifyNonDup(AnnotatedWithParams annotatedWithParams, int n2, boolean bl2) {
        int n3 = 1 << n2;
        this._hasNonDefaultCreator = true;
        AnnotatedWithParams annotatedWithParams2 = this._creators[n2];
        if (annotatedWithParams2 != null) {
            boolean bl3;
            if ((this._explicitCreators & n3) != 0) {
                if (!bl2) {
                    return false;
                }
                bl3 = true;
            } else {
                boolean bl4 = bl3 = !bl2;
            }
            if (bl3 && annotatedWithParams2.getClass() == annotatedWithParams.getClass()) {
                Class<?> clazz;
                Class<?> clazz2 = annotatedWithParams2.getRawParameterType(0);
                if (clazz2 == (clazz = annotatedWithParams.getRawParameterType(0))) {
                    if (this._isEnumValueOf(annotatedWithParams)) {
                        return false;
                    }
                    if (!this._isEnumValueOf(annotatedWithParams2)) {
                        this._reportDuplicateCreator(n2, bl2, annotatedWithParams2, annotatedWithParams);
                    }
                } else {
                    if (clazz.isAssignableFrom(clazz2)) {
                        return false;
                    }
                    if (!clazz2.isAssignableFrom(clazz)) {
                        if (clazz2.isPrimitive() != clazz.isPrimitive()) {
                            if (clazz2.isPrimitive()) {
                                return false;
                            }
                        } else {
                            this._reportDuplicateCreator(n2, bl2, annotatedWithParams2, annotatedWithParams);
                        }
                    }
                }
            }
        }
        if (bl2) {
            this._explicitCreators |= n3;
        }
        this._creators[n2] = this._fixAccess(annotatedWithParams);
        return true;
    }

    protected void _reportDuplicateCreator(int n2, boolean bl2, AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2) {
        throw new IllegalArgumentException(String.format("Conflicting %s creators: already had %s creator %s, encountered another: %s", TYPE_DESCS[n2], bl2 ? "explicitly marked" : "implicitly discovered", annotatedWithParams, annotatedWithParams2));
    }

    protected boolean _isEnumValueOf(AnnotatedWithParams annotatedWithParams) {
        return ClassUtil.isEnumType(annotatedWithParams.getDeclaringClass()) && "valueOf".equals(annotatedWithParams.getName());
    }
}

