/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.BijectiveNsMap;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;

public abstract class OutputElementBase
implements NamespaceContext {
    public static final int PREFIX_UNBOUND = 0;
    public static final int PREFIX_OK = 1;
    public static final int PREFIX_MISBOUND = 2;
    protected static final String sXmlNsPrefix = "xml";
    protected static final String sXmlNsURI = "http://www.w3.org/XML/1998/namespace";
    protected static final BijectiveNsMap DEFAULT_XML_BINDINGS = BijectiveNsMap.createEmpty();
    protected NamespaceContext mRootNsContext;
    protected String mDefaultNsURI;
    protected BijectiveNsMap mNsMapping;
    protected boolean mNsMapShared;

    protected OutputElementBase() {
        this.mNsMapping = null;
        this.mNsMapShared = false;
        this.mDefaultNsURI = "";
        this.mRootNsContext = null;
    }

    protected OutputElementBase(OutputElementBase outputElementBase, BijectiveNsMap bijectiveNsMap) {
        this.mNsMapping = bijectiveNsMap;
        this.mNsMapShared = bijectiveNsMap != null;
        this.mDefaultNsURI = outputElementBase.mDefaultNsURI;
        this.mRootNsContext = outputElementBase.mRootNsContext;
    }

    protected void relink(OutputElementBase outputElementBase) {
        this.mNsMapping = outputElementBase.mNsMapping;
        this.mNsMapShared = this.mNsMapping != null;
        this.mDefaultNsURI = outputElementBase.mDefaultNsURI;
        this.mRootNsContext = outputElementBase.mRootNsContext;
    }

    protected abstract void setRootNsContext(NamespaceContext var1);

    public abstract boolean isRoot();

    public abstract String getNameDesc();

    public final String getDefaultNsUri() {
        return this.mDefaultNsURI;
    }

    public final String getExplicitPrefix(String string) {
        String string2;
        BijectiveNsMap bijectiveNsMap = this.mNsMapping;
        if (bijectiveNsMap == null) {
            bijectiveNsMap = DEFAULT_XML_BINDINGS;
        }
        if ((string2 = bijectiveNsMap.findPrefixByUri(string)) != null) {
            return string2;
        }
        if (this.mRootNsContext != null && (string2 = this.mRootNsContext.getPrefix(string)) != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public final int isPrefixValid(String string, String string2, boolean bl2) throws XMLStreamException {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null || string.length() == 0) {
            if (bl2 ? string2 == this.mDefaultNsURI || string2.equals(this.mDefaultNsURI) : string2.length() == 0) {
                return 1;
            }
            return 2;
        }
        if (string.equals(sXmlNsPrefix)) {
            if (!string2.equals(sXmlNsURI)) {
                this.throwOutputError("Namespace prefix 'xml' can not be bound to non-default namespace ('" + string2 + "'); has to be the default '" + sXmlNsURI + "'");
            }
            return 1;
        }
        String string3 = this.mNsMapping != null ? this.mNsMapping.findUriByPrefix(string) : null;
        if (string3 == null && this.mRootNsContext != null) {
            string3 = this.mRootNsContext.getNamespaceURI(string);
        }
        if (string3 == null) {
            return 0;
        }
        return string3 == string2 || string3.equals(string2) ? 1 : 2;
    }

    public abstract void setDefaultNsUri(String var1);

    public final String generateMapping(String string, String string2, int[] nArray) {
        if (this.mNsMapping == null) {
            this.mNsMapping = BijectiveNsMap.createEmpty();
        } else if (this.mNsMapShared) {
            this.mNsMapping = this.mNsMapping.createChild();
            this.mNsMapShared = false;
        }
        return this.mNsMapping.addGeneratedMapping(string, this.mRootNsContext, string2, nArray);
    }

    public final void addPrefix(String string, String string2) {
        if (this.mNsMapping == null) {
            this.mNsMapping = BijectiveNsMap.createEmpty();
        } else if (this.mNsMapShared) {
            this.mNsMapping = this.mNsMapping.createChild();
            this.mNsMapShared = false;
        }
        this.mNsMapping.addMapping(string, string2);
    }

    @Override
    public final String getNamespaceURI(String string) {
        String string2;
        if (string.length() == 0) {
            return this.mDefaultNsURI;
        }
        BijectiveNsMap bijectiveNsMap = this.mNsMapping;
        if (bijectiveNsMap == null) {
            bijectiveNsMap = DEFAULT_XML_BINDINGS;
        }
        if ((string2 = bijectiveNsMap.findUriByPrefix(string)) != null) {
            return string2;
        }
        return this.mRootNsContext != null ? this.mRootNsContext.getNamespaceURI(string) : null;
    }

    @Override
    public final String getPrefix(String string) {
        String string2;
        if (this.mDefaultNsURI.equals(string)) {
            return "";
        }
        BijectiveNsMap bijectiveNsMap = this.mNsMapping;
        if (bijectiveNsMap == null) {
            bijectiveNsMap = DEFAULT_XML_BINDINGS;
        }
        if ((string2 = bijectiveNsMap.findPrefixByUri(string)) != null) {
            return string2;
        }
        return this.mRootNsContext != null ? this.mRootNsContext.getPrefix(string) : null;
    }

    @Override
    public final Iterator<String> getPrefixes(String string) {
        List<String> list = null;
        if (this.mDefaultNsURI.equals(string)) {
            list = new ArrayList<String>();
            list.add("");
        }
        if (this.mNsMapping != null) {
            list = this.mNsMapping.getPrefixesBoundToUri(string, list);
        }
        if (this.mRootNsContext != null) {
            Iterator<String> iterator = this.mRootNsContext.getPrefixes(string);
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (string2.length() == 0) continue;
                if (list == null) {
                    list = new ArrayList();
                } else if (list.contains(string2)) continue;
                list.add(string2);
            }
        }
        if (list == null) {
            return DataUtil.emptyIterator();
        }
        return list.iterator();
    }

    protected final void throwOutputError(String string) throws XMLStreamException {
        throw new XMLStreamException(string);
    }
}

