/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.comp;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.ExpressionWalker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.RefExpRemover;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.comp.CompatibilityChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.comp.RELAXNGCompReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringPair;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.ResidualCalculator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.StringToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.Token;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Locator;

class DefAttCompatibilityChecker
extends CompatibilityChecker {
    private final Map defaultedAttributes;
    private final RefExpRemover refRemover;
    private ExpressionWalker contextDependentTypeChecker;
    public static final String CERR_DEFVALUE_NAME_IS_NOT_SIMPLE = "RELAXNGReader.Compatibility.DefaultValue.NameIsNotSimple";
    public static final String CERR_DEFVALUE_INVALID = "RELAXNGReader.Compatibility.DefaultValue.Invalid";
    public static final String CERR_DEFVALUE_NOT_OPTIONAL = "RELAXNGReader.Compatibility.DefaultValue.NotOptional";
    public static final String CERR_DEFVALUE_REPEATABLE = "RELAXNGReader.Compatibility.DefaultValue.Repeatable";
    public static final String CERR_DEFVALUE_COMPLEX_ELEMENTNAME = "RELAXNGReader.Compatibility.DefaultValue.ComplexElementName";
    public static final String CERR_DEFVALUE_DIFFERENT_VALUES = "RELAXNGReader.Compatibility.DefaultValue.DifferentValues";
    public static final String CERR_DEFVALUE_CONTEXT_DEPENDENT_TYPE = "RELAXNGReader.Compatibility.DefaultValue.ContextDependentType";
    public static final String CERR_DEFVALUE_COMPETING_ELEMENTS = "RELAXNGReader.Compatibility.DefaultValue.CompetingElements";

    DefAttCompatibilityChecker(RELAXNGCompReader rELAXNGCompReader, Map<AttributeExp, String> map) {
        super(rELAXNGCompReader);
        this.refRemover = new RefExpRemover(this.reader.pool, false);
        this.contextDependentTypeChecker = new ExpressionWalker(){

            @Override
            public void onData(DataExp dataExp) {
                this.check(dataExp.dt, dataExp.name);
            }

            @Override
            public void onValue(ValueExp valueExp) {
                this.check(valueExp.dt, valueExp.name);
            }

            private void check(Datatype datatype, StringPair stringPair) {
                if (datatype.isContextDependent()) {
                    DefAttCompatibilityChecker.this.reportCompError(null, DefAttCompatibilityChecker.CERR_DEFVALUE_CONTEXT_DEPENDENT_TYPE, new Object[]{stringPair.localName});
                    throw new Abort();
                }
            }
        };
        this.defaultedAttributes = map;
    }

    @Override
    protected void setCompatibility(boolean bl2) {
        this.grammar.isDefaultAttributeValueCompatible = bl2;
    }

    private boolean isEpsilon(Expression expression) {
        if (expression == Expression.epsilon) {
            return true;
        }
        return expression.visit(this.refRemover) == Expression.epsilon;
    }

    public void test() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        this.grammar.isDefaultAttributeValueCompatible = true;
        if (this.defaultedAttributes.size() == 0) {
            return;
        }
        Iterator iterator = this.defaultedAttributes.entrySet().iterator();
        ResidualCalculator residualCalculator = new ResidualCalculator(this.reader.pool);
        while (iterator.hasNext()) {
            object3 = iterator.next();
            serializable = (AttributeExp)object3.getKey();
            object2 = (String)object3.getValue();
            if (!(((AttributeExp)serializable).nameClass instanceof SimpleNameClass)) {
                this.reportCompError(new Locator[]{this.reader.getDeclaredLocationOf(serializable)}, CERR_DEFVALUE_NAME_IS_NOT_SIMPLE);
            }
            try {
                ((AttributeExp)serializable).exp.visit(this.contextDependentTypeChecker);
            }
            catch (Abort abort) {
                continue;
            }
            object = new StringToken(residualCalculator, (String)object2, null, null);
            if (residualCalculator.calcResidual(((AttributeExp)serializable).exp, (Token)object).isEpsilonReducible()) continue;
            this.reportCompError(new Locator[]{this.reader.getDeclaredLocationOf(serializable)}, CERR_DEFVALUE_INVALID, new Object[]{object2});
        }
        if (!this.grammar.isDefaultAttributeValueCompatible) {
            return;
        }
        object3 = new HashMap();
        serializable = new HashSet();
        this.grammar.visit(new ExpressionWalker((Set)((Object)serializable), (Map)object3){
            private boolean inOneOrMore = false;
            private boolean inChoice = false;
            private boolean inOptionalChoice = false;
            private boolean inSimpleElement = false;
            private Map<StringPair, String> currentAttributes = null;
            private SimpleNameClass currentElementName = null;
            final /* synthetic */ Set val$elements;
            final /* synthetic */ Map val$name2value;
            {
                this.val$elements = set;
                this.val$name2value = map;
            }

            @Override
            public void onElement(ElementExp elementExp) {
                if (!this.val$elements.add(elementExp)) {
                    return;
                }
                boolean bl2 = this.inSimpleElement;
                boolean bl3 = this.inOptionalChoice;
                boolean bl4 = this.inChoice;
                boolean bl5 = this.inOneOrMore;
                SimpleNameClass simpleNameClass = this.currentElementName;
                Map<StringPair, String> map = this.currentAttributes;
                this.inSimpleElement = elementExp.getNameClass() instanceof SimpleNameClass;
                this.inOptionalChoice = true;
                this.inChoice = false;
                this.inOneOrMore = false;
                StringPair stringPair = null;
                if (this.inSimpleElement) {
                    this.currentElementName = (SimpleNameClass)elementExp.getNameClass();
                    stringPair = new StringPair(this.currentElementName);
                    this.currentAttributes = new HashMap<StringPair, String>();
                } else {
                    this.currentElementName = null;
                }
                elementExp.contentModel.visit(this);
                if (stringPair != null) {
                    DefAttMap defAttMap = (DefAttMap)this.val$name2value.get(stringPair);
                    if (defAttMap == null) {
                        this.val$name2value.put(stringPair, new DefAttMap(elementExp, this.currentAttributes));
                    } else if (!defAttMap.defaultAttributes.equals(this.currentAttributes)) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(defAttMap.sampleDecl), DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(elementExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_COMPETING_ELEMENTS, new Object[]{((SimpleNameClass)defAttMap.sampleDecl.getNameClass()).localName});
                        this.val$name2value.remove(stringPair);
                    }
                }
                this.inSimpleElement = bl2;
                this.inOptionalChoice = bl3;
                this.inChoice = bl4;
                this.inOneOrMore = bl5;
                this.currentElementName = simpleNameClass;
                this.currentAttributes = map;
            }

            @Override
            public void onOneOrMore(OneOrMoreExp oneOrMoreExp) {
                boolean bl2 = this.inOneOrMore;
                this.inOneOrMore = true;
                oneOrMoreExp.exp.visit(this);
                this.inOneOrMore = bl2;
            }

            @Override
            public void onChoice(ChoiceExp choiceExp) {
                boolean bl2 = this.inOptionalChoice;
                boolean bl3 = this.inChoice;
                this.inChoice = true;
                if (!DefAttCompatibilityChecker.this.isEpsilon(choiceExp.exp1) && !DefAttCompatibilityChecker.this.isEpsilon(choiceExp.exp2)) {
                    this.inOptionalChoice = false;
                }
                super.onChoice(choiceExp);
                this.inOptionalChoice = bl2;
                this.inChoice = bl3;
            }

            @Override
            public void onAttribute(AttributeExp attributeExp) {
                if (DefAttCompatibilityChecker.this.defaultedAttributes.containsKey(attributeExp)) {
                    if (!this.inOptionalChoice || !this.inChoice) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_NOT_OPTIONAL);
                        return;
                    }
                    if (this.inOneOrMore) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_REPEATABLE);
                        return;
                    }
                    if (!this.inSimpleElement) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_COMPLEX_ELEMENTNAME);
                        return;
                    }
                    String string = (String)DefAttCompatibilityChecker.this.defaultedAttributes.get(attributeExp);
                    String string2 = this.currentAttributes.put(new StringPair((SimpleNameClass)attributeExp.nameClass), string);
                    if (string2 != null && !string2.equals(string)) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_DIFFERENT_VALUES, new Object[]{string2, string, this.currentElementName.localName, ((SimpleNameClass)attributeExp.nameClass).localName});
                    }
                }
            }

            @Override
            public void onList(ListExp listExp) {
            }
        });
        object2 = serializable.iterator();
        while (object2.hasNext()) {
            object = (ElementExp)object2.next();
            NameClass nameClass = ((ElementExp)object).getNameClass();
            if (nameClass instanceof SimpleNameClass) continue;
            for (Map.Entry entry : object3.entrySet()) {
                if (!nameClass.accepts((StringPair)entry.getKey())) continue;
                DefAttMap defAttMap = (DefAttMap)entry.getValue();
                if (defAttMap.defaultAttributes.size() <= 0) continue;
                this.reportCompError(new Locator[]{this.reader.getDeclaredLocationOf(defAttMap.sampleDecl), this.reader.getDeclaredLocationOf(object)}, CERR_DEFVALUE_COMPETING_ELEMENTS, new Object[]{((SimpleNameClass)defAttMap.sampleDecl.getNameClass()).localName});
                return;
            }
        }
    }

    private static final class Abort
    extends RuntimeException {
        private Abort() {
        }
    }

    private static final class DefAttMap {
        final Map<StringPair, String> defaultAttributes;
        final ElementExp sampleDecl;

        DefAttMap(ElementExp elementExp, Map<StringPair, String> map) {
            this.sampleDecl = elementExp;
            this.defaultAttributes = map;
        }
    }
}

