/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Discrete;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnicodeUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.WhiteSpaceProcessor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;

public class StringType
extends BuiltinAtomicType
implements Discrete {
    public static final StringType theInstance = new StringType("string", WhiteSpaceProcessor.thePreserve, true);
    private final boolean isAlwaysValid;
    private static final long serialVersionUID = 1L;

    protected StringType(String string, WhiteSpaceProcessor whiteSpaceProcessor) {
        this(string, whiteSpaceProcessor, false);
    }

    protected StringType(String string, WhiteSpaceProcessor whiteSpaceProcessor, boolean bl2) {
        super(string, whiteSpaceProcessor);
        this.isAlwaysValid = bl2;
    }

    @Override
    public XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    protected final boolean checkFormat(String string, ValidationContext validationContext) {
        return this._createValue(string, validationContext) != null;
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        return string;
    }

    @Override
    public Class getJavaObjectType() {
        return String.class;
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final int countLength(Object object) {
        return UnicodeUtil.countLength((String)object);
    }

    @Override
    public final int isFacetApplicable(String string) {
        if (string.equals("pattern") || string.equals("enumeration") || string.equals("whiteSpace") || string.equals("length") || string.equals("maxLength") || string.equals("minLength")) {
            return 0;
        }
        return -2;
    }

    @Override
    public boolean isAlwaysValid() {
        return this.isAlwaysValid;
    }
}

