/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.BaseStartElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.MergedNsContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.TextEscaper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.BaseNsContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;

public class SimpleStartElement
extends BaseStartElement {
    final Map<QName, Attribute> mAttrs;

    protected SimpleStartElement(Location location, QName qName, BaseNsContext baseNsContext, Map<QName, Attribute> map) {
        super(location, qName, baseNsContext);
        this.mAttrs = map;
    }

    public static SimpleStartElement construct(Location location, QName qName, Map<QName, Attribute> map, List<Namespace> list, NamespaceContext namespaceContext) {
        BaseNsContext baseNsContext = MergedNsContext.construct(namespaceContext, list);
        return new SimpleStartElement(location, qName, baseNsContext, map);
    }

    public static SimpleStartElement construct(Location location, QName qName, Iterator<Attribute> iterator, Iterator<Namespace> iterator2, NamespaceContext namespaceContext) {
        Object object;
        LinkedHashMap<QName, Attribute> linkedHashMap;
        if (iterator == null || !iterator.hasNext()) {
            linkedHashMap = null;
        } else {
            linkedHashMap = new LinkedHashMap<QName, Attribute>();
            do {
                object = iterator.next();
                linkedHashMap.put(object.getName(), (Attribute)object);
            } while (iterator.hasNext());
        }
        if (iterator2 != null && iterator2.hasNext()) {
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            do {
                arrayList.add(iterator2.next());
            } while (iterator2.hasNext());
            object = MergedNsContext.construct(namespaceContext, arrayList);
        } else {
            object = namespaceContext == null ? null : (namespaceContext instanceof BaseNsContext ? (BaseNsContext)namespaceContext : MergedNsContext.construct(namespaceContext, null));
        }
        return new SimpleStartElement(location, qName, (BaseNsContext)object, linkedHashMap);
    }

    @Override
    public Attribute getAttributeByName(QName qName) {
        if (this.mAttrs == null) {
            return null;
        }
        return this.mAttrs.get(qName);
    }

    @Override
    public Iterator<Attribute> getAttributes() {
        if (this.mAttrs == null) {
            return DataUtil.emptyIterator();
        }
        return this.mAttrs.values().iterator();
    }

    @Override
    protected void outputNsAndAttr(Writer writer) throws IOException {
        if (this.mNsCtxt != null) {
            this.mNsCtxt.outputNamespaceDeclarations(writer);
        }
        if (this.mAttrs != null && this.mAttrs.size() > 0) {
            for (Attribute attribute : this.mAttrs.values()) {
                if (!attribute.isSpecified()) continue;
                writer.write(32);
                QName qName = attribute.getName();
                String string = qName.getPrefix();
                if (string != null && string.length() > 0) {
                    writer.write(string);
                    writer.write(58);
                }
                writer.write(qName.getLocalPart());
                writer.write("=\"");
                String string2 = attribute.getValue();
                if (string2 != null && string2.length() > 0) {
                    TextEscaper.writeEscapedAttrValue(writer, string2);
                }
                writer.write(34);
            }
        }
    }

    @Override
    protected void outputNsAndAttr(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (this.mNsCtxt != null) {
            this.mNsCtxt.outputNamespaceDeclarations(xMLStreamWriter);
        }
        if (this.mAttrs != null && this.mAttrs.size() > 0) {
            for (Attribute attribute : this.mAttrs.values()) {
                if (!attribute.isSpecified()) continue;
                QName qName = attribute.getName();
                String string = qName.getPrefix();
                String string2 = qName.getLocalPart();
                String string3 = qName.getNamespaceURI();
                xMLStreamWriter.writeAttribute(string, string3, string2, attribute.getValue());
            }
        }
    }
}

