/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDSubset;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.EntityDecl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.BaseStartElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.CompactStartElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.SimpleStartElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.WDTD;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.WEntityReference;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.ElemAttrs;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.ElemCallback;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.StreamReaderImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.BaseNsContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.DTDInfo;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamReader2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.AttributeEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.CharactersEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.CommentEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.EndDocumentEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.EndElementEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.NamespaceEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.ProcInstrEventImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.StartDocumentEventImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class DefaultEventAllocator
extends ElemCallback
implements XMLStreamConstants,
XMLEventAllocator {
    static final DefaultEventAllocator sStdInstance = new DefaultEventAllocator(true);
    protected final boolean mAccurateLocation;
    protected Location mLastLocation = null;

    protected DefaultEventAllocator(boolean bl2) {
        this.mAccurateLocation = bl2;
    }

    public static DefaultEventAllocator getDefaultInstance() {
        return sStdInstance;
    }

    public static DefaultEventAllocator getFastInstance() {
        return new DefaultEventAllocator(false);
    }

    @Override
    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Location location;
        if (this.mAccurateLocation) {
            location = xMLStreamReader.getLocation();
        } else {
            location = this.mLastLocation;
            if (location == null) {
                location = this.mLastLocation = xMLStreamReader.getLocation();
            }
        }
        switch (xMLStreamReader.getEventType()) {
            case 12: {
                return new CharactersEventImpl(location, xMLStreamReader.getText(), true);
            }
            case 4: {
                return new CharactersEventImpl(location, xMLStreamReader.getText(), false);
            }
            case 5: {
                return new CommentEventImpl(location, xMLStreamReader.getText());
            }
            case 11: {
                if (xMLStreamReader instanceof XMLStreamReader2) {
                    XMLStreamReader2 xMLStreamReader2 = (XMLStreamReader2)xMLStreamReader;
                    DTDInfo dTDInfo = xMLStreamReader2.getDTDInfo();
                    return new WDTD(location, dTDInfo.getDTDRootName(), dTDInfo.getDTDSystemId(), dTDInfo.getDTDPublicId(), dTDInfo.getDTDInternalSubset(), (DTDSubset)dTDInfo.getProcessedDTD());
                }
                return new WDTD(location, null, xMLStreamReader.getText());
            }
            case 8: {
                return new EndDocumentEventImpl(location);
            }
            case 2: {
                return new EndElementEventImpl(location, xMLStreamReader);
            }
            case 3: {
                return new ProcInstrEventImpl(location, xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
            }
            case 6: {
                CharactersEventImpl charactersEventImpl = new CharactersEventImpl(location, xMLStreamReader.getText(), false);
                charactersEventImpl.setWhitespaceStatus(true);
                return charactersEventImpl;
            }
            case 7: {
                return new StartDocumentEventImpl(location, xMLStreamReader);
            }
            case 1: {
                ArrayList<Namespace> arrayList;
                int n2;
                LinkedHashMap<QName, Attribute> linkedHashMap;
                int n3;
                if (xMLStreamReader instanceof StreamReaderImpl) {
                    StreamReaderImpl streamReaderImpl = (StreamReaderImpl)xMLStreamReader;
                    BaseStartElement baseStartElement = (BaseStartElement)streamReaderImpl.withStartElement(this, location);
                    if (baseStartElement == null) {
                        throw new WstxException("Trying to create START_ELEMENT when current event is " + ErrorConsts.tokenTypeDesc(streamReaderImpl.getEventType()), location);
                    }
                    return baseStartElement;
                }
                NamespaceContext namespaceContext = null;
                if (xMLStreamReader instanceof XMLStreamReader2) {
                    namespaceContext = ((XMLStreamReader2)xMLStreamReader).getNonTransientNamespaceContext();
                }
                if ((n3 = xMLStreamReader.getAttributeCount()) < 1) {
                    linkedHashMap = null;
                } else {
                    linkedHashMap = new LinkedHashMap<QName, Attribute>();
                    for (n2 = 0; n2 < n3; ++n2) {
                        QName qName = xMLStreamReader.getAttributeName(n2);
                        linkedHashMap.put(qName, new AttributeEventImpl(location, qName, xMLStreamReader.getAttributeValue(n2), xMLStreamReader.isAttributeSpecified(n2)));
                    }
                }
                n2 = xMLStreamReader.getNamespaceCount();
                if (n2 < 1) {
                    arrayList = null;
                } else {
                    arrayList = new ArrayList<Namespace>(n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        arrayList.add(NamespaceEventImpl.constructNamespace(location, xMLStreamReader.getNamespacePrefix(i2), xMLStreamReader.getNamespaceURI(i2)));
                    }
                }
                return SimpleStartElement.construct(location, xMLStreamReader.getName(), linkedHashMap, arrayList, namespaceContext);
            }
            case 9: {
                if (xMLStreamReader instanceof StreamReaderImpl) {
                    EntityDecl entityDecl = ((StreamReaderImpl)xMLStreamReader).getCurrentEntityDecl();
                    if (entityDecl == null) {
                        return new WEntityReference(location, xMLStreamReader.getLocalName());
                    }
                    return new WEntityReference(location, entityDecl);
                }
                return new WEntityReference(location, xMLStreamReader.getLocalName());
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                throw new WstxException("Internal error: should not get " + ErrorConsts.tokenTypeDesc(xMLStreamReader.getEventType()));
            }
        }
        throw new IllegalStateException("Unrecognized event type " + xMLStreamReader.getEventType() + ".");
    }

    @Override
    public void allocate(XMLStreamReader xMLStreamReader, XMLEventConsumer xMLEventConsumer) throws XMLStreamException {
        xMLEventConsumer.add(this.allocate(xMLStreamReader));
    }

    @Override
    public XMLEventAllocator newInstance() {
        return new DefaultEventAllocator(this.mAccurateLocation);
    }

    @Override
    public Object withStartElement(Location location, QName qName, BaseNsContext baseNsContext, ElemAttrs elemAttrs, boolean bl2) {
        return new CompactStartElement(location, qName, baseNsContext, elemAttrs);
    }
}

