/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteConverter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteFilter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.GroupsConverter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslCertificateCompressionAlgorithm;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslContextOption;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.PemEncoded;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.PemPrivateKey;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.PemX509Certificate;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ResumptionController;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContextOption;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.AsyncSSLPrivateKeyMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.CertificateCompressionAlgo;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.CertificateVerifier;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLContext;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLPrivateKeyMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.util.AbstractReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetectorFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ImmediateExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = Math.max(1, SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.bioNonApplicationBufferSize", 2048));
    static final boolean USE_TASKS = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.useTasks", true);
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    static final boolean CLIENT_ENABLE_SESSION_TICKET;
    static final boolean CLIENT_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_TICKET;
    static final boolean SERVER_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_CACHE;
    static final boolean CLIENT_ENABLE_SESSION_CACHE;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        @Override
        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                ReferenceCountedOpenSslContext.this.leak.record(object);
            }
            return ReferenceCountedOpenSslContext.this;
        }

        @Override
        protected void deallocate() {
            ReferenceCountedOpenSslContext.this.destroy();
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                boolean bl2 = ReferenceCountedOpenSslContext.this.leak.close(ReferenceCountedOpenSslContext.this);
                assert (bl2);
            }
        }
    };
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final String endpointIdentificationAlgorithm;
    final List<SNIServerName> serverNames;
    final boolean hasTLSv13Cipher;
    final boolean hasTmpDhKeys;
    final boolean enableOcsp;
    final ConcurrentMap<Long, ReferenceCountedOpenSslEngine> engines = new ConcurrentHashMap<Long, ReferenceCountedOpenSslEngine>();
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;
    final boolean tlsFalseStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, int n2, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl2, String string, boolean bl3, boolean bl4, List<SNIServerName> list, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(bl2, resumptionController);
        Serializable serializable;
        OpenSsl.ensureAvailability();
        if (bl3 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        boolean bl5 = false;
        boolean bl6 = USE_TASKS;
        OpenSslPrivateKeyMethod openSslPrivateKeyMethod = null;
        OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod = null;
        OpenSslCertificateCompressionConfig openSslCertificateCompressionConfig = null;
        Integer n3 = null;
        Integer n4 = null;
        Object[] objectArray = OpenSsl.NAMED_GROUPS;
        if (entryArray != null) {
            for (Map.Entry<SslContextOption<?>, Object> entry : entryArray) {
                SslContextOption<?> sslContextOption = entry.getKey();
                if (sslContextOption == OpenSslContextOption.TLS_FALSE_START) {
                    bl5 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.USE_TASKS) {
                    bl6 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.PRIVATE_KEY_METHOD) {
                    openSslPrivateKeyMethod = (OpenSslPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.ASYNC_PRIVATE_KEY_METHOD) {
                    openSslAsyncPrivateKeyMethod = (OpenSslAsyncPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) {
                    openSslCertificateCompressionConfig = (OpenSslCertificateCompressionConfig)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES) {
                    n3 = (Integer)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.TMP_DH_KEYLENGTH) {
                    n4 = (Integer)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.GROUPS) {
                    String[] stringArray2 = (String[])entry.getValue();
                    serializable = new LinkedHashSet<String>(stringArray2.length);
                    for (String string2 : stringArray2) {
                        serializable.add(GroupsConverter.toOpenSsl(string2));
                    }
                    objectArray = serializable.toArray(EmptyArrays.EMPTY_STRINGS);
                    continue;
                }
                logger.debug("Skipping unsupported " + SslContextOption.class.getSimpleName() + ": " + entry.getKey());
            }
        }
        if (openSslPrivateKeyMethod != null && openSslAsyncPrivateKeyMethod != null) {
            throw new IllegalArgumentException("You can either only use " + OpenSslAsyncPrivateKeyMethod.class.getSimpleName() + " or " + OpenSslPrivateKeyMethod.class.getSimpleName());
        }
        this.tlsFalseStart = bl5;
        this.leak = bl4 ? leakDetector.track(this) : null;
        this.mode = n2;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        this.protocols = stringArray == null ? OpenSsl.defaultProtocols(n2 == 0) : stringArray;
        this.endpointIdentificationAlgorithm = string;
        this.serverNames = list;
        this.enableOcsp = bl3;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        Object[] objectArray2 = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites());
        LinkedHashSet linkedHashSet = new LinkedHashSet(objectArray2.length);
        Collections.addAll(linkedHashSet, objectArray2);
        this.unmodifiableCiphers = new ArrayList<String>(linkedHashSet);
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        int n5 = 0;
        try {
            boolean bl7 = OpenSsl.isTlsv13Supported();
            boolean bl8 = false;
            try {
                int n6 = 30;
                if (bl7) {
                    n6 |= 0x20;
                }
                this.ctx = SSLContext.make((int)n6, (int)n2);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            StringBuilder stringBuilder = new StringBuilder();
            serializable = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)false);
                    if (bl7) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, stringBuilder, serializable, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite((long)this.ctx, (String)stringBuilder.toString(), (boolean)false);
                    if (bl7) {
                        String string3 = OpenSsl.checkTls13Ciphers(logger, ((StringBuilder)serializable).toString());
                        SSLContext.setCipherSuite((long)this.ctx, (String)string3, (boolean)true);
                        if (!string3.isEmpty()) {
                            bl8 = true;
                        }
                    }
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            int n7 = SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (stringBuilder.length() == 0) {
                n7 |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            if (!bl7) {
                n7 |= SSL.SSL_OP_NO_TLSv1_3;
            }
            this.hasTLSv13Cipher = bl8;
            SSLContext.setOptions((long)this.ctx, (int)n7);
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (n4 != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)n4);
                this.hasTmpDhKeys = true;
            } else if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
                this.hasTmpDhKeys = true;
            } else {
                this.hasTmpDhKeys = false;
            }
            List<String> list2 = openSslApplicationProtocolNegotiator.protocols();
            if (!list2.isEmpty()) {
                String[] stringArray3 = list2.toArray(EmptyArrays.EMPTY_STRINGS);
                int n8 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray3, (int)n8);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray3, (int)n8);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray3, (int)n8);
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray3, (int)n8);
                        break;
                    }
                    default: {
                        throw new Error("Unexpected apn protocol: " + (Object)((Object)openSslApplicationProtocolNegotiator.protocol()));
                    }
                }
            }
            if (bl3) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)this.isClient());
            }
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl6);
            if (openSslPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engines, openSslPrivateKeyMethod));
            }
            if (openSslAsyncPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (AsyncSSLPrivateKeyMethod)new AsyncPrivateKeyMethod(this.engines, openSslAsyncPrivateKeyMethod));
            }
            if (openSslCertificateCompressionConfig != null) {
                block20: for (OpenSslCertificateCompressionConfig.AlgorithmConfig algorithmConfig : openSslCertificateCompressionConfig) {
                    CompressionAlgorithm compressionAlgorithm = new CompressionAlgorithm(this.engines, algorithmConfig.algorithm());
                    switch (algorithmConfig.mode()) {
                        case Decompress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_DECOMPRESS, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block20;
                        }
                        case Compress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_COMPRESS, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block20;
                        }
                        case Both: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_BOTH, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block20;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (n3 != null) {
                SSLContext.setMaxCertList((long)this.ctx, (int)n3);
            }
            if (objectArray.length > 0 && !SSLContext.setCurvesList((long)this.ctx, (String[])objectArray)) {
                String string4 = "failed to set curves / groups suite: " + Arrays.toString(objectArray);
                int n9 = SSL.getLastErrorNumber();
                if (n9 != 0) {
                    string4 = string4 + ". " + SSL.getErrorString((long)n9);
                }
                throw new SSLException(string4);
            }
            n5 = 1;
        }
        finally {
            if (n5 == 0) {
                this.release();
            }
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior) {
        switch (selectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error("Unexpected behavior: " + (Object)((Object)selectorFailureBehavior));
    }

    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.newEngine0(byteBufAllocator, string, n2, true);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n2, false), bl2, ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n2, bl2, true, this.endpointIdentificationAlgorithm, this.serverNames);
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext openSslSessionContext = this.sessionContext();
                if (openSslSessionContext != null) {
                    openSslSessionContext.destroy();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray, ResumptionController resumptionController) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            if (resumptionController != null) {
                x509TrustManager = (X509TrustManager)resumptionController.wrapIfNeeded(x509TrustManager);
            }
            if (ReferenceCountedOpenSslContext.useExtendedTrustManager(x509TrustManager = OpenSslX509TrustManagerWrapper.wrapIfNeeded((X509TrustManager)trustManager))) {
                x509TrustManager = new EnhancingX509ExtendedTrustManager(x509TrustManager);
            }
            return x509TrustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error("Unexpected protocol: " + (Object)((Object)applicationProtocolConfig.protocol()));
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return x509TrustManager instanceof X509ExtendedTrustManager;
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    static void setKeyMaterial(long l2, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l5 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, privateKey);
            }
            SSLContext.setCertificateBio((long)l2, (long)l4, (long)l3, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l2, (long)l5, (boolean)true);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            ReferenceCountedOpenSslContext.freeBio(l3);
            ReferenceCountedOpenSslContext.freeBio(l4);
            ReferenceCountedOpenSslContext.freeBio(l5);
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    static void freeBio(long l2) {
        if (l2 != 0L) {
            SSL.freeBIO((long)l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PrivateKey privateKey) throws Exception {
        if (privateKey == null) {
            return 0L;
        }
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, X509Certificate ... x509CertificateArray) throws Exception {
        if (x509CertificateArray == null) {
            return 0L;
        }
        ObjectUtil.checkNonEmpty(x509CertificateArray, "certChain");
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) throws Exception {
        try {
            long l2;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l3 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l3;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) throws Exception {
        try {
            long l2 = SSL.newMemBIO();
            int n2 = byteBuf.readableBytes();
            if (SSL.bioWrite((long)l2, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n2) != n2) {
                SSL.freeBIO((long)l2);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l3 = l2;
            return l3;
        }
        finally {
            byteBuf.release();
        }
    }

    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory keyManagerFactory, String string) {
        if (keyManagerFactory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)keyManagerFactory).newProvider();
        }
        if (keyManagerFactory instanceof OpenSslCachingX509KeyManagerFactory) {
            return ((OpenSslCachingX509KeyManagerFactory)keyManagerFactory).newProvider(string);
        }
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()), string);
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        CLIENT_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean("jdk.tls.client.enableSessionTicketExtension", false);
        CLIENT_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean("jdk.tls.client.enableSessionTicketExtension", true);
        SERVER_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean("jdk.tls.server.enableSessionTicketExtension", false);
        SERVER_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean("jdk.tls.server.enableSessionTicketExtension", true);
        SERVER_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.sessionCacheServer", true);
        CLIENT_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.sessionCacheClient", true);
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        Integer n2 = null;
        try {
            String string = SystemPropertyUtil.get("jdk.tls.ephemeralDHKeySize");
            if (string != null) {
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n2;
    }

    private static final class CompressionAlgorithm {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;
        private final OpenSslCertificateCompressionAlgorithm compressionAlgorithm;

        CompressionAlgorithm(Map<Long, ReferenceCountedOpenSslEngine> map, OpenSslCertificateCompressionAlgorithm openSslCertificateCompressionAlgorithm) {
            this.engines = map;
            this.compressionAlgorithm = openSslCertificateCompressionAlgorithm;
        }
    }

    private static final class AsyncPrivateKeyMethod
    implements AsyncSSLPrivateKeyMethod {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;
        private final OpenSslAsyncPrivateKeyMethod keyMethod;

        AsyncPrivateKeyMethod(Map<Long, ReferenceCountedOpenSslEngine> map, OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod) {
            this.engines = map;
            this.keyMethod = openSslAsyncPrivateKeyMethod;
        }
    }

    private static final class PrivateKeyMethod
    implements SSLPrivateKeyMethod {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;
        private final OpenSslPrivateKeyMethod keyMethod;

        PrivateKeyMethod(Map<Long, ReferenceCountedOpenSslEngine> map, OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
            this.engines = map;
            this.keyMethod = openSslPrivateKeyMethod;
        }
    }

    static abstract class AbstractCertificateVerifier
    extends CertificateVerifier {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;

        AbstractCertificateVerifier(Map<Long, ReferenceCountedOpenSslEngine> map) {
            this.engines = map;
        }
    }
}

