/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.List;

public class PotentialCreator {
    private static final PropertyName[] NO_NAMES = new PropertyName[0];
    private final AnnotatedWithParams _creator;
    private final boolean _isAnnotated;
    private JsonCreator.Mode _creatorMode;
    private PropertyName[] _implicitParamNames;
    private PropertyName[] _explicitParamNames;
    private List<BeanPropertyDefinition> _propertyDefs;

    public PotentialCreator(AnnotatedWithParams annotatedWithParams, JsonCreator.Mode mode) {
        this._creator = annotatedWithParams;
        this._isAnnotated = mode != null;
        this._creatorMode = mode == null ? JsonCreator.Mode.DEFAULT : mode;
    }

    public void assignPropertyDefs(List<? extends BeanPropertyDefinition> list) {
        this._propertyDefs = list;
    }

    public PotentialCreator introspectParamNames(MapperConfig<?> mapperConfig) {
        if (this._implicitParamNames != null) {
            return this;
        }
        int n2 = this._creator.getParameterCount();
        if (n2 == 0) {
            this._explicitParamNames = NO_NAMES;
            this._implicitParamNames = NO_NAMES;
            return this;
        }
        this._explicitParamNames = new PropertyName[n2];
        this._implicitParamNames = new PropertyName[n2];
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        for (int i2 = 0; i2 < n2; ++i2) {
            PropertyName propertyName;
            AnnotatedParameter annotatedParameter = this._creator.getParameter(i2);
            String string = annotationIntrospector.findImplicitPropertyName(annotatedParameter);
            if (string != null && !string.isEmpty()) {
                this._implicitParamNames[i2] = PropertyName.construct(string);
            }
            if ((propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter)) == null || propertyName.isEmpty()) continue;
            this._explicitParamNames[i2] = propertyName;
        }
        return this;
    }

    public PotentialCreator introspectParamNames(MapperConfig<?> mapperConfig, PropertyName[] propertyNameArray) {
        if (this._implicitParamNames != null) {
            return this;
        }
        int n2 = this._creator.getParameterCount();
        if (n2 == 0) {
            this._explicitParamNames = NO_NAMES;
            this._implicitParamNames = NO_NAMES;
            return this;
        }
        this._explicitParamNames = new PropertyName[n2];
        this._implicitParamNames = propertyNameArray;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        for (int i2 = 0; i2 < n2; ++i2) {
            AnnotatedParameter annotatedParameter = this._creator.getParameter(i2);
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName == null || propertyName.isEmpty()) continue;
            this._explicitParamNames[i2] = propertyName;
        }
        return this;
    }

    public boolean isAnnotated() {
        return this._isAnnotated;
    }

    public AnnotatedWithParams creator() {
        return this._creator;
    }

    public JsonCreator.Mode creatorMode() {
        return this._creatorMode;
    }

    public JsonCreator.Mode creatorModeOrDefault() {
        if (this._creatorMode == null) {
            return JsonCreator.Mode.DEFAULT;
        }
        return this._creatorMode;
    }

    public int paramCount() {
        return this._creator.getParameterCount();
    }

    public AnnotatedParameter param(int n2) {
        return this._creator.getParameter(n2);
    }

    public boolean hasExplicitNames() {
        int n2 = this._explicitParamNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._explicitParamNames[i2] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameFor(int n2) {
        return this._explicitParamNames[n2] != null || this._implicitParamNames[n2] != null;
    }

    public boolean hasNameOrInjectForAllParams(MapperConfig<?> mapperConfig) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        int n2 = this._implicitParamNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.hasNameFor(i2) || annotationIntrospector != null && annotationIntrospector.findInjectableValue(this._creator.getParameter(i2)) != null) continue;
            return false;
        }
        return true;
    }

    public PropertyName explicitName(int n2) {
        return this._explicitParamNames[n2];
    }

    public PropertyName implicitName(int n2) {
        return this._implicitParamNames[n2];
    }

    public String implicitNameSimple(int n2) {
        PropertyName propertyName = this._implicitParamNames[n2];
        return propertyName == null ? null : propertyName.getSimpleName();
    }

    public BeanPropertyDefinition[] propertyDefs() {
        if (this._propertyDefs == null || this._propertyDefs.isEmpty()) {
            return new BeanPropertyDefinition[0];
        }
        return this._propertyDefs.toArray(new BeanPropertyDefinition[this._propertyDefs.size()]);
    }

    public String toString() {
        return "(mode=" + (Object)((Object)this._creatorMode) + ")" + this._creator;
    }
}

