package com.gradle.develocity.agent.gradle.integration;

import com.gradle.obfuscation.Keep;

/**
 * The DSL extension for integrations between Gradle and other tools and build systems.
 *
 * @since 4.0
 */
@Keep
public interface DevelocityIntegrationConfiguration {

    /**
     * Access the external agent configuration specific to the Develocity npm build agent.
     * <p>
     * Note that the configuration files for individual agents (e.g. ${@code develocity.config.js})
     * will always take precedence over configuration passed by Gradle.
     *
     * @since 4.0
     */
    NpmAgentConfiguration getNpm();

    /**
     * Access the external agent configuration specific to the Develocity Python build agent.
     * <p>
     * Note that the configuration files for individual agents (e.g. ${@code .develocity.py})
     * will always take precedence over configuration passed by Gradle.
     *
     * @since 4.0
     */
    PythonAgentConfiguration getPython();
}
