/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    ByteBuffer buffer;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;

    public UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(n3);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        ObjectUtil.checkPositiveOrZero(n2, "initialCapacity");
        ObjectUtil.checkPositiveOrZero(n3, "maxCapacity");
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n2, n3));
        }
        this.alloc = byteBufAllocator;
        this.setByteBuffer(this.allocateDirect(n2), false);
    }

    protected UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2) {
        this(byteBufAllocator, byteBuffer, n2, false, true);
    }

    UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2, boolean bl2, boolean bl3) {
        super(n2);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        ObjectUtil.checkNotNull(byteBuffer, "initialBuffer");
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int n3 = byteBuffer.remaining();
        if (n3 > n2) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n3, n2));
        }
        this.alloc = byteBufAllocator;
        this.doNotFree = !bl2;
        this.setByteBuffer((bl3 ? byteBuffer.slice() : byteBuffer).order(ByteOrder.BIG_ENDIAN), false);
        this.writerIndex(n3);
    }

    protected ByteBuffer allocateDirect(int n2) {
        return ByteBuffer.allocateDirect(n2);
    }

    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectBuffer(byteBuffer);
    }

    void setByteBuffer(ByteBuffer byteBuffer, boolean bl2) {
        ByteBuffer byteBuffer2;
        if (bl2 && (byteBuffer2 = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                this.freeDirect(byteBuffer2);
            }
        }
        this.buffer = byteBuffer;
        this.tmpNioBuf = null;
        this.capacity = byteBuffer.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int n2) {
        int n3;
        this.checkNewCapacity(n2);
        int n4 = this.capacity;
        if (n2 == n4) {
            return this;
        }
        if (n2 > n4) {
            n3 = n4;
        } else {
            this.trimIndicesToCapacity(n2);
            n3 = n2;
        }
        ByteBuffer byteBuffer = this.buffer;
        ByteBuffer byteBuffer2 = this.allocateDirect(n2);
        byteBuffer.position(0).limit(n3);
        byteBuffer2.position(0).limit(n3);
        byteBuffer2.put(byteBuffer).clear();
        this.setByteBuffer(byteBuffer2, true);
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return this.buffer.get(n2);
    }

    @Override
    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    @Override
    protected short _getShort(int n2) {
        return this.buffer.getShort(n2);
    }

    @Override
    protected short _getShortLE(int n2) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n2));
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return (this.getByte(n2) & 0xFF) << 16 | (this.getByte(n2 + 1) & 0xFF) << 8 | this.getByte(n2 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return this.getByte(n2) & 0xFF | (this.getByte(n2 + 1) & 0xFF) << 8 | (this.getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    @Override
    protected int _getInt(int n2) {
        return this.buffer.getInt(n2);
    }

    @Override
    protected int _getIntLE(int n2) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n2));
    }

    @Override
    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    @Override
    protected long _getLong(int n2) {
        return this.buffer.getLong(n2);
    }

    @Override
    protected long _getLongLE(int n2) {
        return ByteBufUtil.swapLong(this.buffer.getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.getBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.getBytes(n2, byArray, n3, n4, false);
        return this;
    }

    void getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.get(byArray, n3, n4);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byArray, n2, n3, true);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.getBytes(n2, byteBuffer, false);
        return this;
    }

    void getBytes(int n2, ByteBuffer byteBuffer, boolean bl2) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = bl2 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer, true);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.ensureAccessible();
        this._setByte(n2, n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        this.buffer.put(n2, (byte)n3);
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.ensureAccessible();
        this._setShort(n2, n3);
        return this;
    }

    @Override
    protected void _setShort(int n2, int n3) {
        this.buffer.putShort(n2, (short)n3);
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.ensureAccessible();
        this._setMedium(n2, n3);
        return this;
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        this.setByte(n2, (byte)(n3 >>> 16));
        this.setByte(n2 + 1, (byte)(n3 >>> 8));
        this.setByte(n2 + 2, (byte)n3);
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.ensureAccessible();
        this._setInt(n2, n3);
        return this;
    }

    @Override
    protected void _setInt(int n2, int n3) {
        this.buffer.putInt(n2, n3);
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.ensureAccessible();
        this._setLong(n2, l2);
        return this;
    }

    @Override
    protected void _setLong(int n2, long l2) {
        this.buffer.putLong(n2, l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.setBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.getBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.put(byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl2) throws IOException {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
        this.ensureAccessible();
        if (this.buffer.hasArray()) {
            return inputStream.read(this.buffer.array(), this.buffer.arrayOffset() + n2, n3);
        }
        byte[] byArray = ByteBufUtil.threadLocalTempArray(n3);
        int n4 = inputStream.read(byArray, 0, n3);
        if (n4 <= 0) {
            return n4;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2);
        byteBuffer.put(byArray, 0, n4);
        return n4;
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ((ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    protected void deallocate() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            this.freeDirect(byteBuffer);
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

