/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.hash;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.CheckForNull;

public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int bits();

    public abstract int asInt();

    public abstract long asLong();

    public abstract byte[] asBytes();

    byte[] getBytesInternal() {
        return this.asBytes();
    }

    abstract boolean equalsSameBits(HashCode var1);

    public static HashCode fromLong(long l2) {
        return new LongHashCode(l2);
    }

    static HashCode fromBytesNoCopy(byte[] byArray) {
        return new BytesHashCode(byArray);
    }

    public final boolean equals(@CheckForNull Object object) {
        if (object instanceof HashCode) {
            HashCode hashCode = (HashCode)object;
            return this.bits() == hashCode.bits() && this.equalsSameBits(hashCode);
        }
        return false;
    }

    public final int hashCode() {
        if (this.bits() >= 32) {
            return this.asInt();
        }
        byte[] byArray = this.getBytesInternal();
        int n2 = byArray[0] & 0xFF;
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 |= (byArray[i2] & 0xFF) << i2 * 8;
        }
        return n2;
    }

    public final String toString() {
        byte[] byArray = this.getBytesInternal();
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by2 : byArray) {
            stringBuilder.append(hexDigits[by2 >> 4 & 0xF]).append(hexDigits[by2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    private static final class LongHashCode
    extends HashCode
    implements Serializable {
        final long hash;

        LongHashCode(long l2) {
            this.hash = l2;
        }

        @Override
        public int bits() {
            return 64;
        }

        @Override
        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24), (byte)(this.hash >> 32), (byte)(this.hash >> 40), (byte)(this.hash >> 48), (byte)(this.hash >> 56)};
        }

        @Override
        public int asInt() {
            return (int)this.hash;
        }

        @Override
        public long asLong() {
            return this.hash;
        }

        @Override
        boolean equalsSameBits(HashCode hashCode) {
            return this.hash == hashCode.asLong();
        }
    }

    private static final class BytesHashCode
    extends HashCode
    implements Serializable {
        final byte[] bytes;

        BytesHashCode(byte[] byArray) {
            this.bytes = Preconditions.checkNotNull(byArray);
        }

        @Override
        public int bits() {
            return this.bytes.length * 8;
        }

        @Override
        public byte[] asBytes() {
            return (byte[])this.bytes.clone();
        }

        @Override
        public int asInt() {
            Preconditions.checkState(this.bytes.length >= 4, "HashCode#asInt() requires >= 4 bytes (it only has %s bytes).", this.bytes.length);
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }

        @Override
        public long asLong() {
            Preconditions.checkState(this.bytes.length >= 8, "HashCode#asLong() requires >= 8 bytes (it only has %s bytes).", this.bytes.length);
            return this.padToLong();
        }

        public long padToLong() {
            long l2 = this.bytes[0] & 0xFF;
            for (int i2 = 1; i2 < Math.min(this.bytes.length, 8); ++i2) {
                l2 |= ((long)this.bytes[i2] & 0xFFL) << i2 * 8;
            }
            return l2;
        }

        @Override
        byte[] getBytesInternal() {
            return this.bytes;
        }

        @Override
        boolean equalsSameBits(HashCode hashCode) {
            if (this.bytes.length != hashCode.getBytesInternal().length) {
                return false;
            }
            boolean bl2 = true;
            for (int i2 = 0; i2 < this.bytes.length; ++i2) {
                bl2 &= this.bytes[i2] == hashCode.getBytesInternal()[i2];
            }
            return bl2;
        }
    }
}

