/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ObjectArrays;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Platform;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.RegularImmutableAsList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        Preconditions.checkNotNull(TArray);
        int n2 = this.size();
        if (TArray.length < n2) {
            Object[] objectArray = this.internalArray();
            if (objectArray != null) {
                return Platform.copy(objectArray, this.internalArrayStart(), this.internalArrayEnd(), TArray);
            }
            TArray = ObjectArrays.newArray(TArray, n2);
        } else if (TArray.length > n2) {
            TArray[n2] = null;
        }
        this.copyIntoArray(TArray, 0);
        return TArray;
    }

    @CheckForNull
    Object[] internalArray() {
        return null;
    }

    int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean contains(@CheckForNull Object var1);

    @Override
    @Deprecated
    public final boolean add(E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(@CheckForNull Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeIf(Predicate<? super E> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.iterator().next());
            }
        }
        return new RegularImmutableAsList(this, this.toArray());
    }

    int copyIntoArray(Object[] objectArray, int n2) {
        for (Object e2 : this) {
            objectArray[n2++] = e2;
        }
        return n2;
    }

    public static abstract class Builder<E> {
        static int expandedCapacity(int n2, int n3) {
            if (n3 < 0) {
                throw new IllegalArgumentException("cannot store more than Integer.MAX_VALUE elements");
            }
            if (n3 <= n2) {
                return n2;
            }
            int n4 = n2 + (n2 >> 1) + 1;
            if (n4 < n3) {
                n4 = Integer.highestOneBit(n3 - 1) << 1;
            }
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            return n4;
        }
    }
}

