package com.gradle.develocity.agent.gradle.scan;

import com.gradle.obfuscation.Keep;
import org.gradle.api.provider.Property;

/**
 * Allows configuring what data will be captured as part of the build scan.
 *
 * @see BuildScanConfiguration#getCapture()
 * @since 3.17
 */
@Keep
public interface BuildScanCaptureConfiguration {

    /**
     * Specifies whether to capture information about each file used as an input to a unit of work.
     * <p>
     * Defaults to {@code true}.
     * <p>
     * Capturing file fingerprints may increase the size of the build scan data.
     * This requires more time to transmit to the server, and more storage space at the server.
     * Most builds will not incur a noticeable difference when this feature is enabled.
     * Large builds may increase the build scan data by a handful of megabytes.
     * For most builds, the increase will be negligible.
     * <p>
     * If using Develocity with a good connection to the server this capture should stay enabled,
     * as it allows comparing inputs at a file level when comparing builds.
     * <p>
     * This property may also be set by the {@code "scan.capture-file-fingerprints"} system property.
     * If this is set to any value other than {@code "false"}, the capture will be enabled.
     * If this is set to {@code "false"}, the capture will be disabled.
     * If the capture is enabled or disabled via system property, calling this method has no effect.
     * That is, the system property takes precedence over the value set via this method.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     */
    Property<Boolean> getFileFingerprints();

    /**
     * Specifies whether to capture build logging output.
     * <p>
     * Defaults to {@code true}.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     */
    Property<Boolean> getBuildLogging();

    /**
     * Specifies whether to capture test logging output.
     * <p>
     * Defaults to {@code true}.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     */
    Property<Boolean> getTestLogging();

    /**
     * Specifies whether to capture information about the resources used by the build.
     * <p>
     * Defaults to {@code true}.
     * <p>
     * This property may also be set by the {@code "scan.capture-resource-usage"} system property.
     * If this is set to any value other than {@code "false"}, the capture will be enabled.
     * If this is set to {@code "false"}, the capture will be disabled.
     * If the capture is enabled or disabled via system property, calling this method has no effect.
     * That is, the system property takes precedence over the value set via this method.
     * <p>
     * This method cannot be called after the root project has finished configuring.
     * Doing so will produce a build time error.
     *
     * @since 3.18
     */
    Property<Boolean> getResourceUsage();

}
