package com.gradle.develocity.agent.gradle.integration;

import com.gradle.obfuscation.Keep;
import org.gradle.api.provider.Provider;

import java.util.Map;

/**
 * The DSL extension for configuring the npm Develocity build agent, when npm is called from within a Gradle build.
 * <p>
 * Usage example:
 * <pre>{@code
 * tasks.register("npmInstallWithAgent", Exec) {
 *   environment.putAll(develocity.integration.npm.environment.get())
 *   commandLine("npm", "install")
 * }
 * }</pre>
 *
 * @since 4.0
 */
@Keep
public interface NpmAgentConfiguration {

    /**
     * Access the environment variables used to pass information from the Gradle plugin to the Develocity npm build agent.
     * <p>
     * These variables should be injected into tasks that run npm from the command line.
     * <p>
     * Usage example:
     * <pre>{@code
     * tasks.register("npmInstallWithAgent", Exec) {
     *   environment.putAll(develocity.integration.npm.environment.get())
     *   commandLine("npm", "install")
     * }
     * }</pre>
     *
     * @since 4.0
     */
    Provider<Map<String, String>> getEnvironment();
}
