/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.utils.BaseChecker;
import com.goterl.lazycode.lazysodium.utils.Key;
import com.goterl.lazycode.lazysodium.utils.KeyPair;

public interface Sign {
    public static final int ED25519_PUBLICKEYBYTES = 32;
    public static final int ED25519_BYTES = 64;
    public static final int ED25519_SECRETKEYBYTES = 64;
    public static final int ED25519_SEEDBYTES = 32;
    public static final int CURVE25519_PUBLICKEYBYTES = 32;
    public static final int CURVE25519_SECRETKEYBYTES = 32;
    public static final long ED25519_MESSAGEBYTES_MAX = 0x7FFFFFFFFFFFFFBFL;
    public static final int BYTES = 64;
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 64;
    public static final int SEEDBYTES = 32;
    public static final long MESSAGEBYTES_MAX = 0x7FFFFFFFFFFFFFBFL;

    public static interface Lazy {
        public KeyPair cryptoSignKeypair() throws SodiumException;

        public KeyPair cryptoSignSeedKeypair(byte[] var1) throws SodiumException;

        public KeyPair cryptoSignSecretKeyPair(Key var1) throws SodiumException;

        public String cryptoSign(String var1, String var2) throws SodiumException;

        public String cryptoSign(String var1, Key var2) throws SodiumException;

        public String cryptoSignOpen(String var1, Key var2);

        public String cryptoSignDetached(String var1, Key var2) throws SodiumException;

        public boolean cryptoSignVerifyDetached(String var1, String var2, Key var3);

        public KeyPair convertKeyPairEd25519ToCurve25519(KeyPair var1) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoSignKeypair(byte[] var1, byte[] var2);

        public boolean cryptoSignSeedKeypair(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoSign(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoSignOpen(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoSignDetached(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoSignVerifyDetached(byte[] var1, byte[] var2, int var3, byte[] var4);

        public boolean convertPublicKeyEd25519ToCurve25519(byte[] var1, byte[] var2);

        public boolean convertSecretKeyEd25519ToCurve25519(byte[] var1, byte[] var2);

        public boolean cryptoSignEd25519SkToSeed(byte[] var1, byte[] var2);

        public boolean cryptoSignEd25519SkToPk(byte[] var1, byte[] var2);
    }

    public static class Checker
    extends BaseChecker {
    }
}

