/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.utils;

import com.goterl.lazycode.lazysodium.Sodium;
import com.goterl.lazycode.lazysodium.SodiumJava;
import com.sun.jna.Native;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public final class LibraryLoader {
    private static LibraryLoader INSTANCE = new LibraryLoader(Native::register);
    private final JnaLoader loader;
    private final Object lock = new Object();
    private boolean loaded;
    private File temporaryDir;

    LibraryLoader(JnaLoader loader) {
        this.loader = loader;
        this.loaded = false;
        this.temporaryDir = null;
    }

    public static LibraryLoader getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLibraryFromJar(String pathInJar) throws IOException {
        Objects.requireNonNull(pathInJar, "pathInJar");
        Object object = this.lock;
        synchronized (object) {
            if (this.loaded) {
                return;
            }
            File sodiumLib = this.copyFromJarToTemp(pathInJar);
            this.loadLibrary(sodiumLib.getAbsolutePath());
            this.requestLibDeletion(sodiumLib);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLibrary(String libLocator) {
        Objects.requireNonNull(libLocator, "libLocator");
        Object object = this.lock;
        synchronized (object) {
            if (this.loaded) {
                return;
            }
            this.loader.register(Sodium.class, libLocator);
            this.loader.register(SodiumJava.class, libLocator);
            this.loaded = true;
        }
    }

    private File copyFromJarToTemp(String pathInJar) throws IOException {
        if (this.temporaryDir == null) {
            this.temporaryDir = LibraryLoader.createTempDirectory();
        }
        String fileName = new File(pathInJar).getName();
        File temp = new File(this.temporaryDir, fileName);
        InputStream is = LibraryLoader.class.getResourceAsStream(pathInJar);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(temp, false));
        try {
            byte[] dest = new byte[4096];
            int amt = is.read(dest);
            while (amt != -1) {
                ((OutputStream)out).write(dest, 0, amt);
                amt = is.read(dest);
            }
        }
        catch (IOException e) {
            temp.delete();
            throw e;
        }
        catch (Exception e) {
            temp.delete();
            String message = String.format("Failed to copy the lib from JAR (%s) into %s", pathInJar, temp);
            throw new IOException(message, e);
        }
        finally {
            is.close();
            ((OutputStream)out).close();
        }
        return temp;
    }

    private void requestLibDeletion(File sodiumLib) {
        if (LibraryLoader.isPosixCompliant()) {
            sodiumLib.delete();
        } else {
            sodiumLib.deleteOnExit();
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    static File createTempDirectory() throws IOException {
        String tempDirPrefix = "lazysodium";
        File generatedDir = Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]).toFile();
        generatedDir.deleteOnExit();
        return generatedDir;
    }

    static interface JnaLoader {
        public void register(Class<?> var1, String var2);
    }
}

