/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.utils.BaseChecker;
import com.goterl.lazycode.lazysodium.utils.DetachedDecrypt;
import com.goterl.lazycode.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazycode.lazysodium.utils.KeyPair;

public interface Box {
    public static final int CURVE25519XSALSA20POLY1305_PUBLICKEYBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_SECRETKEYBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_MACBYTES = 16;
    public static final int CURVE25519XSALSA20POLY1305_SEEDBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_BEFORENMBYTES = 32;
    public static final int CURVE25519XSALSA20POLY1305_NONCEBYTES = 24;
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 32;
    public static final int MACBYTES = 16;
    public static final int SEEDBYTES = 32;
    public static final int BEFORENMBYTES = 32;
    public static final int NONCEBYTES = 24;
    public static final int SEALBYTES = 48;

    public static interface Lazy {
        public KeyPair cryptoBoxKeypair() throws SodiumException;

        public KeyPair cryptoBoxSeedKeypair(byte[] var1) throws SodiumException;

        public String cryptoBoxEasy(String var1, byte[] var2, KeyPair var3) throws SodiumException;

        public String cryptoBoxOpenEasy(String var1, byte[] var2, KeyPair var3) throws SodiumException;

        public String cryptoBoxBeforeNm(byte[] var1, byte[] var2) throws SodiumException;

        public String cryptoBoxBeforeNm(KeyPair var1) throws SodiumException;

        public String cryptoBoxEasyAfterNm(String var1, byte[] var2, String var3) throws SodiumException;

        public String cryptoBoxOpenEasyAfterNm(String var1, byte[] var2, String var3) throws SodiumException;

        public DetachedEncrypt cryptoBoxDetachedAfterNm(String var1, byte[] var2, String var3) throws SodiumException;

        public DetachedDecrypt cryptoBoxOpenDetachedAfterNm(DetachedEncrypt var1, byte[] var2, String var3) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoBoxKeypair(byte[] var1, byte[] var2);

        public boolean cryptoBoxSeedKeypair(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoBoxEasy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6, byte[] var7);

        public boolean cryptoBoxOpenEasy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6, byte[] var7);

        public boolean cryptoBoxDetached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7, byte[] var8);

        public boolean cryptoBoxOpenDetached(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

        public boolean cryptoBoxBeforeNm(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoBoxEasyAfterNm(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public boolean cryptoBoxOpenEasyAfterNm(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public boolean cryptoBoxDetachedAfterNm(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

        public boolean cryptoBoxOpenDetachedAfterNm(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

        public boolean cryptoBoxSeal(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoBoxSealOpen(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);
    }

    public static class Checker
    extends BaseChecker {
        public static boolean checkPublicKey(int len) {
            return 32 == len;
        }

        public static boolean checkMac(int len) {
            return 16 == len;
        }

        public static boolean checkSecretKey(int len) {
            return 32 == len;
        }

        public static boolean checkSeed(int len) {
            return 32 == len;
        }

        public static boolean checkBeforeNmBytes(int len) {
            return 32 == len;
        }

        public static boolean checkNonce(int len) {
            return 24 == len;
        }
    }
}

