/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.utils.BaseChecker;

public interface GenericHash {
    public static final int BLAKE2B_BYTES = 32;
    public static final int BLAKE2B_BYTES_MIN = 16;
    public static final int BLAKE2B_BYTES_MAX = 64;
    public static final int BLAKE2B_KEYBYTES = 32;
    public static final int BLAKE2B_KEYBYTES_MIN = 16;
    public static final int BLAKE2B_KEYBYTES_MAX = 64;
    public static final int BLAKE2B_SALTBYTES = 16;
    public static final int BYTES = 32;
    public static final int KEYBYTES = 32;
    public static final int BYTES_MAX = 64;
    public static final int BYTES_MIN = 16;
    public static final int KEYBYTES_MIN = 16;
    public static final int KEYBYTES_MAX = 64;

    public static interface Lazy {
        public String cryptoGenericHashKeygen();

        public String cryptoGenericHashKeygen(int var1) throws SodiumException;

        public String cryptoGenericHash(String var1) throws SodiumException;

        public String cryptoGenericHash(String var1, String var2) throws SodiumException;

        public boolean cryptoGenericHashInit(byte[] var1, String var2, int var3);

        public boolean cryptoGenericHashUpdate(byte[] var1, String var2) throws SodiumException;

        public String cryptoGenericHashFinal(byte[] var1, int var2) throws SodiumException;
    }

    public static interface Native {
        public void cryptoGenericHashKeygen(byte[] var1);

        public boolean cryptoGenericHash(byte[] var1, int var2, byte[] var3, long var4, byte[] var6, int var7);

        public boolean cryptoGenericHash(byte[] var1, int var2, byte[] var3, long var4);

        public boolean cryptoGenericHashInit(byte[] var1, byte[] var2, int var3, int var4);

        public boolean cryptoGenericHashInit(byte[] var1, int var2);

        public boolean cryptoGenericHashUpdate(byte[] var1, byte[] var2, long var3);

        public boolean cryptoGenericHashFinal(byte[] var1, byte[] var2, int var3);

        public int cryptoGenericHashStateBytes();
    }

    public static class Checker
    extends BaseChecker {
    }
}

