/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.utils.BaseChecker;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface GenericHash {
    public static final int BLAKE2B_BYTES = 32;
    public static final int BLAKE2B_BYTES_MAX = 64;
    public static final int BLAKE2B_BYTES_MIN = 16;
    public static final int BLAKE2B_KEYBYTES = 32;
    public static final int BLAKE2B_KEYBYTES_MIN = 16;
    public static final int BLAKE2B_KEYBYTES_MAX = 64;
    public static final int BLAKE2B_SALTBYTES = 16;
    public static final int BYTES = 32;
    public static final int KEYBYTES = 32;
    public static final int BYTES_MAX = 64;
    public static final int BYTES_MIN = 16;
    public static final int KEYBYTES_MIN = 16;
    public static final int KEYBYTES_MAX = 64;

    public static class State
    extends Structure {
        public long[] h = new long[8];
        public long[] t = new long[2];
        public long[] f = new long[2];
        public byte[] buf = new byte[256];
        public int buflen = 256;
        public int last_node;

        protected List<String> getFieldOrder() {
            return Arrays.asList("h", "t", "f", "buf", "buflen", "last_node");
        }

        public static class ByReference
        extends State
        implements Structure.ByReference {
        }
    }

    public static interface Lazy {
        public String cryptoGenericHashKeygen();

        public String cryptoGenericHash(String var1) throws SodiumException;

        public String cryptoGenericHash(String var1, String var2) throws SodiumException;

        public boolean cryptoGenericHashInit(State var1, String var2, int var3);

        public String cryptoGenericHashUpdate(State var1, String var2) throws SodiumException;

        public String cryptoGenericHashFinal(State var1, int var2) throws SodiumException;
    }

    public static interface Native {
        public void cryptoGenericHashKeygen(byte[] var1);

        public boolean cryptoGenericHash(byte[] var1, int var2, byte[] var3, long var4, byte[] var6, int var7);

        public boolean cryptoGenericHashInit(State var1, byte[] var2, int var3, int var4);

        public boolean cryptoGenericHashUpdate(State var1, byte[] var2, long var3);

        public boolean cryptoGenericHashFinal(State var1, byte[] var2, int var3);
    }

    public static class Checker
    extends BaseChecker {
    }
}

