/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium;

import com.goterl.lazycode.lazysodium.Sodium;
import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.interfaces.AEAD;
import com.goterl.lazycode.lazysodium.interfaces.Auth;
import com.goterl.lazycode.lazysodium.interfaces.Base;
import com.goterl.lazycode.lazysodium.interfaces.Box;
import com.goterl.lazycode.lazysodium.interfaces.GenericHash;
import com.goterl.lazycode.lazysodium.interfaces.Hash;
import com.goterl.lazycode.lazysodium.interfaces.Helpers;
import com.goterl.lazycode.lazysodium.interfaces.KeyDerivation;
import com.goterl.lazycode.lazysodium.interfaces.KeyExchange;
import com.goterl.lazycode.lazysodium.interfaces.Padding;
import com.goterl.lazycode.lazysodium.interfaces.PwHash;
import com.goterl.lazycode.lazysodium.interfaces.Random;
import com.goterl.lazycode.lazysodium.interfaces.SecretBox;
import com.goterl.lazycode.lazysodium.interfaces.SecretStream;
import com.goterl.lazycode.lazysodium.interfaces.ShortHash;
import com.goterl.lazycode.lazysodium.interfaces.Sign;
import com.goterl.lazycode.lazysodium.utils.DetachedDecrypt;
import com.goterl.lazycode.lazysodium.utils.DetachedEncrypt;
import com.goterl.lazycode.lazysodium.utils.KeyPair;
import com.goterl.lazycode.lazysodium.utils.SessionPair;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class LazySodium
implements Base,
Random,
AEAD.Native,
AEAD.Lazy,
GenericHash.Native,
GenericHash.Lazy,
ShortHash.Native,
ShortHash.Lazy,
Auth.Native,
Auth.Lazy,
SecretStream.Native,
SecretStream.Lazy,
Padding.Native,
Padding.Lazy,
Helpers.Native,
Helpers.Lazy,
PwHash.Native,
PwHash.Lazy,
Hash.Native,
Hash.Lazy,
Sign.Native,
Sign.Lazy,
Box.Native,
Box.Lazy,
SecretBox.Native,
SecretBox.Lazy,
KeyExchange.Native,
KeyExchange.Lazy,
KeyDerivation.Native,
KeyDerivation.Lazy {
    private final Sodium nacl;
    private Charset charset = StandardCharsets.UTF_8;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public LazySodium(Sodium sodium) {
        this.nacl = sodium;
        this.init();
    }

    public LazySodium(Sodium sodium, Charset charset) {
        this.nacl = sodium;
        this.charset = charset;
        this.init();
    }

    private void init() {
    }

    @Override
    public String sodiumBin2Hex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    @Override
    public byte[] sodiumHex2Bin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    public static String toHex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    public static byte[] toBin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] hexToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public byte randomBytesRandom() {
        return this.nacl.randombytes_random();
    }

    @Override
    public byte[] randomBytesBuf(int size) {
        byte[] bs = new byte[size];
        this.nacl.randombytes_buf(bs, size);
        return bs;
    }

    @Override
    public byte[] nonce(int size) {
        return this.randomBytesBuf(size);
    }

    @Override
    public byte randomBytesUniform(int upperBound) {
        return this.nacl.randombytes_uniform(upperBound);
    }

    @Override
    public byte[] randomBytesDeterministic(int size, byte[] seed) {
        byte[] bs = new byte[size];
        this.nacl.randombytes_buf_deterministic(bs, size, seed);
        return bs;
    }

    @Override
    public boolean sodiumPad(int paddedBuffLen, char[] buf, int unpaddedBufLen, int blockSize, int maxBufLen) {
        return this.boolify(this.nacl.sodium_pad(paddedBuffLen, buf, unpaddedBufLen, blockSize, maxBufLen));
    }

    @Override
    public boolean sodiumUnpad(int unPaddedBuffLen, char[] buf, int paddedBufLen, int blockSize) {
        return this.boolify(this.nacl.sodium_unpad(unPaddedBuffLen, buf, paddedBufLen, blockSize));
    }

    @Override
    public void cryptoKdfKeygen(byte[] masterKey) {
        this.nacl.crypto_kdf_keygen(masterKey);
    }

    @Override
    public String cryptoKdfKeygen(Charset charset) {
        byte[] masterKeyInBytes = new byte[32];
        this.nacl.crypto_kdf_keygen(masterKeyInBytes);
        return this.sodiumBin2Hex(masterKeyInBytes);
    }

    @Override
    public String cryptoKdfKeygen() {
        byte[] masterKey = new byte[32];
        this.nacl.crypto_kdf_keygen(masterKey);
        return this.sodiumBin2Hex(masterKey);
    }

    @Override
    public String cryptoKdfDeriveFromKey(int lengthOfSubkey, long subKeyId, String context, byte[] masterKey) throws SodiumException {
        return this.cryptoKdfDeriveFromKey(lengthOfSubkey, subKeyId, context, this.sodiumBin2Hex(masterKey));
    }

    @Override
    public String cryptoKdfDeriveFromKey(int lengthOfSubkey, long subKeyId, String context, String masterKey) throws SodiumException {
        if (!KeyDerivation.Checker.subKeyIsCorrect(lengthOfSubkey)) {
            throw new SodiumException("Subkey is not between the correct lengths.");
        }
        if (!KeyDerivation.Checker.masterKeyIsCorrect(this.sodiumHex2Bin(masterKey).length)) {
            throw new SodiumException("Master key is not the correct length.");
        }
        if (!KeyDerivation.Checker.contextIsCorrect(this.bytes(context).length)) {
            throw new SodiumException("Context is not the correct length.");
        }
        byte[] subKey = new byte[lengthOfSubkey];
        byte[] contextAsBytes = this.bytes(context);
        byte[] masterKeyAsBytes = this.sodiumHex2Bin(masterKey);
        int res = this.nacl.crypto_kdf_derive_from_key(subKey, lengthOfSubkey, subKeyId, contextAsBytes, masterKeyAsBytes);
        return this.res(res, this.sodiumBin2Hex(subKey));
    }

    @Override
    public int cryptoKdfDeriveFromKey(byte[] subKey, int subKeyLen, long subKeyId, byte[] context, byte[] masterKey) {
        return this.nacl.crypto_kdf_derive_from_key(subKey, subKeyLen, subKeyId, context, masterKey);
    }

    @Override
    public boolean cryptoKxKeypair(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_kx_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoKxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.boolify(this.nacl.crypto_kx_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoKxClientSessionKeys(byte[] rx, byte[] tx, byte[] clientPk, byte[] clientSk, byte[] serverPk) {
        return this.boolify(this.nacl.crypto_kx_client_session_keys(rx, tx, clientPk, clientSk, serverPk));
    }

    @Override
    public boolean cryptoKxServerSessionKeys(byte[] rx, byte[] tx, byte[] serverPk, byte[] serverSk, byte[] clientPk) {
        return this.boolify(this.nacl.crypto_kx_server_session_keys(rx, tx, serverPk, serverSk, clientPk));
    }

    @Override
    public KeyPair cryptoKxKeypair() {
        byte[] secretKey = this.randomBytesBuf(32);
        byte[] publicKey = this.randomBytesBuf(32);
        this.nacl.crypto_kx_keypair(publicKey, secretKey);
        return new KeyPair(LazySodium.toHex(publicKey), LazySodium.toHex(secretKey));
    }

    @Override
    public KeyPair cryptoKxKeypair(byte[] seed) {
        byte[] secretKey = this.randomBytesBuf(32);
        byte[] publicKey = this.randomBytesBuf(32);
        this.nacl.crypto_kx_seed_keypair(publicKey, secretKey, seed);
        return new KeyPair(LazySodium.toHex(publicKey), LazySodium.toHex(secretKey));
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(byte[] clientPk, byte[] clientSk, byte[] serverPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxClientSessionKeys(rx, tx, clientPk, clientSk, serverPk)) {
            throw new SodiumException("Failure in creating client session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(KeyPair clientKeyPair, KeyPair serverKeyPair) throws SodiumException {
        return this.cryptoKxClientSessionKeys(clientKeyPair.getPublicKey(), clientKeyPair.getSecretKey(), serverKeyPair.getPublicKey());
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(byte[] serverPk, byte[] serverSk, byte[] clientPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxServerSessionKeys(rx, tx, serverPk, serverSk, clientPk)) {
            throw new SodiumException("Failure in creating server session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(KeyPair serverKeyPair, KeyPair clientKeyPair) throws SodiumException {
        return this.cryptoKxServerSessionKeys(serverKeyPair.getPublicKey(), serverKeyPair.getSecretKey(), clientKeyPair.getPublicKey());
    }

    @Override
    public boolean cryptoPwHash(byte[] outputHash, long outputHashLen, byte[] password, long passwordLen, byte[] salt, long opsLimit, long memLimit, PwHash.Alg alg) {
        int res = this.nacl.crypto_pwhash(outputHash, outputHashLen, password, passwordLen, salt, opsLimit, memLimit, alg.getValue());
        return this.boolify(res);
    }

    @Override
    public boolean cryptoPwHashStr(byte[] outputStr, byte[] password, long passwordLen, long opsLimit, long memLimit) {
        int res = this.nacl.crypto_pwhash_str(outputStr, password, passwordLen, opsLimit, memLimit);
        return this.boolify(res);
    }

    @Override
    public boolean cryptoPwHashStrVerify(byte[] hash, byte[] password, long passwordLen) {
        return this.boolify(this.nacl.crypto_pwhash_str_verify(hash, password, passwordLen));
    }

    @Override
    public boolean cryptoPwHashStrNeedsRehash(byte[] hash, long opsLimit, long memLimit) {
        return this.boolify(this.nacl.crypto_pwhash_str_needs_rehash(hash, opsLimit, memLimit));
    }

    @Override
    public String cryptoPwHash(String password, long lengthOfHash, byte[] salt, long opsLimit, long memLimit, PwHash.Alg alg) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        PwHash.Checker.checkAll(passwordBytes.length, salt.length, opsLimit, memLimit);
        byte[] hash = new byte[LazySodium.longToInt(lengthOfHash).intValue()];
        this.cryptoPwHash(hash, hash.length, passwordBytes, passwordBytes.length, salt, opsLimit, memLimit, alg);
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoPwHashStr(String password, long opsLimit, long memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoPwHashStrRemoveNulls(String password, long opsLimit, long memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        byte[] hashNoNulls = this.removeNulls(hash);
        return LazySodium.toHex(hashNoNulls);
    }

    @Override
    public boolean cryptoPwHashStrVerify(String hash, String password) {
        byte[] hashBytes = LazySodium.toBin(hash);
        byte[] passwordBytes = this.bytes(password);
        byte endOfHash = hashBytes[hashBytes.length - 1];
        if (endOfHash != 0) {
            byte[] hashWithNullByte = new byte[hashBytes.length + 1];
            System.arraycopy(hashBytes, 0, hashWithNullByte, 0, hashBytes.length);
            hashBytes = hashWithNullByte;
        }
        return this.cryptoPwHashStrVerify(hashBytes, passwordBytes, passwordBytes.length);
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256(byte[] out, long outLen, byte[] password, long passwordLen, byte[] salt, long opsLimit, long memLimit) {
        return this.boolify(this.nacl.crypto_pwhash_scryptsalsa208sha256(out, outLen, password, passwordLen, salt, opsLimit, memLimit));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256Str(byte[] out, byte[] password, long passwordLen, long opsLimit, long memLimit) {
        return this.boolify(this.nacl.crypto_pwhash_scryptsalsa208sha256_str(out, password, passwordLen, opsLimit, memLimit));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256StrVerify(byte[] str, byte[] password, long passwordLen) {
        return this.boolify(this.nacl.crypto_pwhash_scryptsalsa208sha256_str_verify(str, password, passwordLen));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256Ll(byte[] password, int passwordLen, byte[] salt, int saltLen, long N, long r, long p, byte[] buf, int bufLen) {
        return this.boolify(this.nacl.crypto_pwhash_scryptsalsa208sha256_ll(password, passwordLen, salt, saltLen, N, r, p, buf, bufLen));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256StrNeedsRehash(byte[] hash, long opsLimit, long memLimit) {
        return this.boolify(this.nacl.crypto_pwhash_scryptsalsa208sha256_str_needs_rehash(hash, opsLimit, memLimit));
    }

    @Override
    public String cryptoPwHashScryptSalsa208Sha256(String password, byte[] salt, long opsLimit, long memLimit) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        PwHash.Checker.checkAllScrypt(passwordBytes.length, salt.length, opsLimit, memLimit);
        byte[] hash = new byte[LazySodium.longToInt(16L).intValue()];
        boolean res = this.cryptoPwHashScryptSalsa208Sha256(hash, hash.length, passwordBytes, passwordBytes.length, salt, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Could not Scrypt hash your password.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoPwHashScryptSalsa208Sha256Str(String password, long opsLimit, long memLimit) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        if (!PwHash.Checker.checkOpsLimitScrypt(opsLimit)) {
            throw new SodiumException("The ops limit provided is not between the correct values.");
        }
        if (!PwHash.Checker.checkMemLimitScrypt(memLimit)) {
            throw new SodiumException("The mem limit provided is not between the correct values.");
        }
        byte[] hash = new byte[LazySodium.longToInt(102L).intValue()];
        boolean res = this.cryptoPwHashScryptSalsa208Sha256Str(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Could not string Scrypt hash your password.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256StrVerify(String hash, String password) {
        byte[] hashBytes = LazySodium.toBin(hash);
        byte[] passwordBytes = this.bytes(password);
        byte endOfHash = hashBytes[hashBytes.length - 1];
        if (endOfHash != 0) {
            byte[] hashWithNullByte = new byte[hashBytes.length + 1];
            System.arraycopy(hashBytes, 0, hashWithNullByte, 0, hashBytes.length);
            hashBytes = hashWithNullByte;
        }
        return this.cryptoPwHashScryptSalsa208Sha256StrVerify(hashBytes, passwordBytes, passwordBytes.length);
    }

    @Override
    public boolean cryptoHashSha256(byte[] out, byte[] in, long inLen) {
        return this.boolify(this.nacl.crypto_hash_sha256(out, in, inLen));
    }

    @Override
    public boolean cryptoHashSha256Init(Hash.State256 state) {
        return this.boolify(this.nacl.crypto_hash_sha256_init(state));
    }

    @Override
    public boolean cryptoHashSha256Update(Hash.State256 state, byte[] in, long inLen) {
        return this.boolify(this.nacl.crypto_hash_sha256_update(state, in, inLen));
    }

    @Override
    public boolean cryptoHashSha256Final(Hash.State256 state, byte[] out) {
        return this.boolify(this.nacl.crypto_hash_sha256_final(state, out));
    }

    @Override
    public boolean cryptoHashSha512(byte[] out, byte[] in, long inLen) {
        return this.boolify(this.nacl.crypto_hash_sha512(out, in, inLen));
    }

    @Override
    public boolean cryptoHashSha512Init(Hash.State512 state) {
        return this.boolify(this.nacl.crypto_hash_sha512_init(state));
    }

    @Override
    public boolean cryptoHashSha512Update(Hash.State512 state, byte[] in, long inLen) {
        return this.boolify(this.nacl.crypto_hash_sha512_update(state, in, inLen));
    }

    @Override
    public boolean cryptoHashSha512Final(Hash.State512 state, byte[] out) {
        return this.boolify(this.nacl.crypto_hash_sha512_final(state, out));
    }

    @Override
    public String cryptoHashSha256(String message) throws SodiumException {
        byte[] hashedBytes = new byte[32];
        byte[] msgBytes = this.bytes(message);
        if (!this.cryptoHashSha256(hashedBytes, msgBytes, msgBytes.length)) {
            throw new SodiumException("Unsuccessful sha-256 hash.");
        }
        return LazySodium.toHex(hashedBytes);
    }

    @Override
    public String cryptoHashSha512(String message) throws SodiumException {
        byte[] hashedBytes = new byte[64];
        byte[] msgBytes = this.bytes(message);
        if (!this.cryptoHashSha512(hashedBytes, msgBytes, msgBytes.length)) {
            throw new SodiumException("Unsuccessful sha-512 hash.");
        }
        return LazySodium.toHex(hashedBytes);
    }

    @Override
    public boolean cryptoHashSha256Update(Hash.State256 state, String messagePart) {
        byte[] msgBytes = this.bytes(messagePart);
        return this.cryptoHashSha256Update(state, msgBytes, msgBytes.length);
    }

    @Override
    public String cryptoHashSha256Final(Hash.State256 state) throws SodiumException {
        byte[] finalHash = new byte[32];
        if (!this.cryptoHashSha256Final(state, finalHash)) {
            throw new SodiumException("Could not finalise sha-256.");
        }
        return LazySodium.toHex(finalHash);
    }

    @Override
    public boolean cryptoHashSha512Update(Hash.State512 state, String messagePart) {
        byte[] msgBytes = this.bytes(messagePart);
        return this.cryptoHashSha512Update(state, msgBytes, msgBytes.length);
    }

    @Override
    public String cryptoHashSha512Final(Hash.State512 state) throws SodiumException {
        byte[] finalHash = new byte[64];
        if (!this.cryptoHashSha512Final(state, finalHash)) {
            throw new SodiumException("Could not finalise sha-512.");
        }
        return LazySodium.toHex(finalHash);
    }

    @Override
    public void cryptoSecretBoxKeygen(byte[] key) {
        this.nacl.crypto_secretbox_keygen(key);
    }

    @Override
    public boolean cryptoSecretBoxEasy(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_easy(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenEasy(byte[] message, byte[] cipherText, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_open_easy(message, cipherText, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxDetached(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_detached(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_open_detached(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public String cryptoSecretBoxKeygen() {
        byte[] key = new byte[32];
        this.cryptoSecretBoxKeygen(key);
        return LazySodium.toHex(key);
    }

    @Override
    public String cryptoSecretBoxEasy(String message, byte[] nonce, String key) throws SodiumException {
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[16 + messageBytes.length];
        if (!this.cryptoSecretBoxEasy(cipherTextBytes, messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt message.");
        }
        return LazySodium.toHex(cipherTextBytes);
    }

    @Override
    public String cryptoSecretBoxOpenEasy(String cipher, byte[] nonce, String key) throws SodiumException {
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] messageBytes = new byte[cipherBytes.length - 16];
        if (!this.cryptoSecretBoxOpenEasy(messageBytes, cipherBytes, cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt message.");
        }
        return this.str(messageBytes);
    }

    @Override
    public DetachedEncrypt cryptoSecretBoxDetached(String message, byte[] nonce, String key) throws SodiumException {
        byte[] macBytes;
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[messageBytes.length];
        if (!this.cryptoSecretBoxDetached(cipherTextBytes, macBytes = new byte[16], messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt detached message.");
        }
        return new DetachedEncrypt(cipherTextBytes, macBytes);
    }

    @Override
    public String cryptoSecretBoxOpenDetached(DetachedEncrypt cipherAndMac, byte[] nonce, String key) throws SodiumException {
        byte[] macBytes;
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] cipherBytes = cipherAndMac.getCipher();
        byte[] messageBytes = new byte[cipherBytes.length];
        if (!this.cryptoSecretBoxOpenDetached(messageBytes, cipherBytes, macBytes = cipherAndMac.getMac(), cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt detached message.");
        }
        return this.str(messageBytes);
    }

    @Override
    public boolean cryptoBoxKeypair(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.boolify(this.nacl.crypto_box_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoScalarMultBase(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_scalarmult_base(publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxEasy(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_easy(cipherText, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenEasy(byte[] message, byte[] cipherText, long cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_open_easy(message, cipherText, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxDetached(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_detached(cipherText, mac, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, byte[] cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_open_detached(message, cipherText, mac, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxBeforeNm(byte[] k, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_beforenm(k, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxEasyAfterNm(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_easy_afternm(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenEasyAfterNm(byte[] message, byte[] cipher, long cLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_open_easy_afternm(message, cipher, cLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxDetachedAfterNm(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_detached_afternm(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenDetachedAfterNm(byte[] message, byte[] cipherText, byte[] mac, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_open_detached_afternm(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxSeal(byte[] cipher, byte[] message, long messageLen, byte[] publicKey) {
        return this.boolify(this.nacl.crypto_box_seal(cipher, message, messageLen, publicKey));
    }

    @Override
    public boolean cryptoBoxSealOpen(byte[] m, byte[] cipher, long cipherLen, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_seal_open(m, cipher, cipherLen, publicKey, secretKey));
    }

    @Override
    public KeyPair cryptoBoxKeypair() throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoBoxKeypair(publicKey, secretKey = this.randomBytesBuf(32))) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoBoxSeedKeypair(byte[] seed) throws SodiumException {
        byte[] publicKey = this.randomBytesBuf(32);
        byte[] secretKey = this.randomBytesBuf(32);
        if (!Box.Checker.checkSeed(seed.length)) {
            throw new SodiumException("Seed is incorrect size.");
        }
        if (!this.cryptoBoxSeedKeypair(publicKey, secretKey, seed)) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoScalarMultBase(byte[] secretKey) throws SodiumException {
        if (!Box.Checker.checkSecretKey(secretKey.length)) {
            throw new SodiumException("Secret key is incorrect size.");
        }
        byte[] publicKey = this.randomBytesBuf(32);
        this.cryptoScalarMultBase(publicKey, secretKey);
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoScalarMultBase(String secretKey) throws SodiumException {
        byte[] secretKeyBytes = LazySodium.toBin(secretKey);
        return this.cryptoScalarMultBase(secretKeyBytes);
    }

    @Override
    public String cryptoBoxEasy(String message, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipherBytes = new byte[16 + messageBytes.length];
        boolean res = this.cryptoBoxEasy(cipherBytes, messageBytes, messageBytes.length, nonce, keyPair.getPublicKey(), keyPair.getSecretKey());
        if (!res) {
            throw new SodiumException("Could not encrypt your message.");
        }
        return LazySodium.toHex(cipherBytes);
    }

    @Override
    public String cryptoBoxOpenEasy(String cipherText, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] cipher = LazySodium.toBin(cipherText);
        byte[] message = new byte[cipher.length - 16];
        boolean res = this.cryptoBoxOpenEasy(message, cipher, cipher.length, nonce, keyPair.getPublicKey(), keyPair.getSecretKey());
        if (!res) {
            throw new SodiumException("Could not decrypt your message.");
        }
        return this.str(message);
    }

    @Override
    public String cryptoBoxBeforeNm(byte[] publicKey, byte[] secretKey) throws SodiumException {
        byte[] sharedKey = new byte[32];
        if (!Box.Checker.checkPublicKey(publicKey.length)) {
            throw new SodiumException("Public key length is incorrect.");
        }
        if (!Box.Checker.checkSecretKey(secretKey.length)) {
            throw new SodiumException("Secret key length is incorrect.");
        }
        boolean res = this.cryptoBoxBeforeNm(sharedKey, publicKey, secretKey);
        if (!res) {
            throw new SodiumException("Unable to encrypt using shared secret key.");
        }
        return LazySodium.toHex(sharedKey);
    }

    @Override
    public String cryptoBoxBeforeNm(KeyPair keyPair) throws SodiumException {
        return this.cryptoBoxBeforeNm(keyPair.getPublicKey(), keyPair.getSecretKey());
    }

    @Override
    public String cryptoBoxEasyAfterNm(String message, byte[] nonce, String sharedSecretKey) throws SodiumException {
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[messageBytes.length + 16];
        boolean res = this.cryptoBoxEasyAfterNm(cipher, messageBytes, messageBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key encryption.");
        }
        return LazySodium.toHex(cipher);
    }

    @Override
    public String cryptoBoxOpenEasyAfterNm(String cipher, byte[] nonce, String sharedSecretKey) throws SodiumException {
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] message = new byte[cipherBytes.length - 16];
        boolean res = this.cryptoBoxOpenEasyAfterNm(message, cipherBytes, cipherBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key decryption.");
        }
        return this.str(message);
    }

    @Override
    public DetachedEncrypt cryptoBoxDetachedAfterNm(String message, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] mac;
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[messageBytes.length];
        boolean res = this.cryptoBoxDetachedAfterNm(cipher, mac = new byte[16], messageBytes, messageBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key detached encryption.");
        }
        return new DetachedEncrypt(cipher, mac);
    }

    @Override
    public DetachedDecrypt cryptoBoxOpenDetachedAfterNm(DetachedEncrypt detachedEncrypt, byte[] nonce, String sharedSecretKey) throws SodiumException {
        byte[] mac;
        if (!Box.Checker.checkNonce(nonce.length)) {
            throw new SodiumException("Incorrect nonce length.");
        }
        byte[] sharedKey = LazySodium.toBin(sharedSecretKey);
        if (!Box.Checker.checkBeforeNmBytes(sharedKey.length)) {
            throw new SodiumException("Incorrect shared secret key length.");
        }
        byte[] cipherBytes = detachedEncrypt.getCipher();
        byte[] message = new byte[cipherBytes.length];
        boolean res = this.cryptoBoxOpenDetachedAfterNm(message, cipherBytes, mac = detachedEncrypt.getMac(), cipherBytes.length, nonce, sharedKey);
        if (!res) {
            throw new SodiumException("Could not fully complete shared secret key detached decryption.");
        }
        return new DetachedDecrypt(message, mac);
    }

    @Override
    public boolean cryptoSignKeypair(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_sign_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoSignSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.boolify(this.nacl.crypto_sign_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoSign(byte[] signedMessage, Long signedMessageLen, byte[] message, long messageLen, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_sign(signedMessage, signedMessageLen, message, messageLen, secretKey));
    }

    @Override
    public boolean cryptoSignOpen(byte[] message, Long messageLen, byte[] signedMessage, long signedMessageLen, byte[] publicKey) {
        return this.boolify(this.nacl.crypto_sign_open(message, messageLen, signedMessage, signedMessageLen, publicKey));
    }

    @Override
    public boolean cryptoSignDetached(byte[] signature, Long sigLength, byte[] message, long messageLen, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_sign_detached(signature, sigLength, message, messageLen, secretKey));
    }

    @Override
    public boolean cryptoSignVerifyDetached(byte[] signature, byte[] message, long messageLen, byte[] publicKey) {
        return this.boolify(this.nacl.crypto_sign_verify_detached(signature, message, messageLen, publicKey));
    }

    @Override
    public KeyPair cryptoSignKeypair() throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoSignKeypair(publicKey, secretKey = this.randomBytesBuf(64))) {
            throw new SodiumException("Could not generate a signing keypair.");
        }
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoSignSeedKeypair(byte[] seed) throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoSignSeedKeypair(publicKey, secretKey = this.randomBytesBuf(64), seed)) {
            throw new SodiumException("Could not generate a signing keypair with a seed.");
        }
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public String cryptoSign(String message, String secretKey) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] secretKeyBytes = this.sodiumHex2Bin(secretKey);
        byte[] signedMessage = this.randomBytesBuf(64 + messageBytes.length);
        boolean res = this.cryptoSign(signedMessage, null, messageBytes, messageBytes.length, secretKeyBytes);
        if (!res) {
            throw new SodiumException("Could not sign your message.");
        }
        return this.sodiumBin2Hex(signedMessage);
    }

    @Override
    public String cryptoSignOpen(String signedMessage, String publicKey) {
        byte[] signedMessageBytes = LazySodium.toBin(signedMessage);
        byte[] publicKeyBytes = this.sodiumHex2Bin(publicKey);
        byte[] messageBytes = this.randomBytesBuf(signedMessageBytes.length - 64);
        boolean res = this.cryptoSignOpen(messageBytes, null, signedMessageBytes, signedMessageBytes.length, publicKeyBytes);
        if (!res) {
            return null;
        }
        return this.str(messageBytes);
    }

    @Override
    public String cryptoSignDetached(String message, String secretKey) throws SodiumException {
        byte[] skBytes;
        byte[] signatureBytes = new byte[64];
        byte[] messageBytes = this.bytes(message);
        if (!this.cryptoSignDetached(signatureBytes, null, messageBytes, messageBytes.length, skBytes = LazySodium.toBin(secretKey))) {
            throw new SodiumException("Could not create a signature for your message in detached mode.");
        }
        return LazySodium.toHex(signatureBytes);
    }

    @Override
    public boolean cryptoSignVerifyDetached(String signature, String message, String publicKey) {
        byte[] messageBytes = this.bytes(message);
        byte[] pkBytes = LazySodium.toBin(publicKey);
        byte[] signatureBytes = LazySodium.toBin(signature);
        return this.cryptoSignVerifyDetached(signatureBytes, messageBytes, messageBytes.length, pkBytes);
    }

    @Override
    public void cryptoSecretStreamKeygen(byte[] key) {
        this.nacl.crypto_secretstream_xchacha20poly1305_keygen(key);
    }

    @Override
    public boolean cryptoSecretStreamInitPush(SecretStream.State state, byte[] header, byte[] key) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_init_push(state, header, key));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, Long cipherAddr, byte[] message, long messageLen, byte tag) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherAddr, message, messageLen, new byte[0], 0L, tag));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, byte[] message, long messageLen, byte tag) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, null, message, messageLen, new byte[0], 0L, tag));
    }

    @Override
    public boolean cryptoSecretStreamPush(SecretStream.State state, byte[] cipher, Long cipherAddr, byte[] message, long messageLen, byte[] additionalData, long additionalDataLen, byte tag) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherAddr, message, messageLen, additionalData, additionalDataLen, tag));
    }

    @Override
    public boolean cryptoSecretStreamInitPull(SecretStream.State state, byte[] header, byte[] key) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_init_pull(state, header, key));
    }

    @Override
    public boolean cryptoSecretStreamPull(SecretStream.State state, byte[] message, Long messageAddress, byte[] tag, byte[] cipher, long cipherLen, byte[] additionalData, long additionalDataLen) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_pull(state, message, messageAddress, tag, cipher, cipherLen, additionalData, additionalDataLen));
    }

    @Override
    public boolean cryptoSecretStreamPull(SecretStream.State state, byte[] message, byte[] tag, byte[] cipher, long cipherLen) {
        return this.boolify(this.nacl.crypto_secretstream_xchacha20poly1305_pull(state, message, 0L, tag, cipher, cipherLen, new byte[0], 0L));
    }

    @Override
    public String cryptoSecretStreamKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.nacl.crypto_secretstream_xchacha20poly1305_keygen(key);
        return LazySodium.toHex(key);
    }

    @Override
    public SecretStream.State cryptoSecretStreamInitPush(byte[] header, String key) throws SodiumException {
        SecretStream.State.ByReference state = new SecretStream.State.ByReference();
        if (!SecretStream.Checker.headerCheck(header.length)) {
            throw new SodiumException("Header of secret stream incorrect length.");
        }
        this.nacl.crypto_secretstream_xchacha20poly1305_init_push(state, header, LazySodium.toBin(key));
        return state;
    }

    @Override
    public String cryptoSecretStreamPush(SecretStream.State state, String message, byte tag) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipher = new byte[17 + messageBytes.length];
        int res = this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, null, messageBytes, messageBytes.length, new byte[0], 0L, tag);
        if (res != 0) {
            throw new SodiumException("Error when encrypting a message using secret stream.");
        }
        return LazySodium.toHex(cipher);
    }

    @Override
    public SecretStream.State cryptoSecretStreamInitPull(byte[] header, String key) throws SodiumException {
        SecretStream.State.ByReference state = new SecretStream.State.ByReference();
        if (!SecretStream.Checker.headerCheck(header.length)) {
            throw new SodiumException("Header of secret stream incorrect length.");
        }
        int res = this.nacl.crypto_secretstream_xchacha20poly1305_init_pull(state, header, LazySodium.toBin(key));
        if (res != 0) {
            throw new SodiumException("Could not initialise a decryption state.");
        }
        return state;
    }

    @Override
    public String cryptoSecretStreamPull(SecretStream.State state, String cipher, byte[] tag) throws SodiumException {
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] message = new byte[cipherBytes.length - 17];
        int res = this.nacl.crypto_secretstream_xchacha20poly1305_pull(state, message, null, tag, cipherBytes, cipherBytes.length, new byte[0], 0L);
        if (res != 0) {
            throw new SodiumException("Error when decrypting a message using secret stream.");
        }
        return this.str(message);
    }

    @Override
    public void cryptoSecretStreamRekey(SecretStream.State state) {
        this.nacl.crypto_secretstream_xchacha20poly1305_rekey(state);
    }

    @Override
    public boolean cryptoAuth(byte[] tag, byte[] in, long inLen, byte[] key) {
        return this.boolify(this.nacl.crypto_auth(tag, in, inLen, key));
    }

    @Override
    public boolean cryptoAuthVerify(byte[] tag, byte[] in, long inLen, byte[] key) {
        return this.boolify(this.nacl.crypto_auth_verify(tag, in, inLen, key));
    }

    @Override
    public void cryptoAuthKeygen(byte[] k) {
        this.nacl.crypto_auth_keygen(k);
    }

    @Override
    public String cryptoAuthKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.cryptoAuthKeygen(key);
        return LazySodium.toHex(key);
    }

    @Override
    public String cryptoAuth(String message, String key) throws SodiumException {
        byte[] keyBytes;
        byte[] messageBytes;
        byte[] tag = this.randomBytesBuf(32);
        boolean res = this.cryptoAuth(tag, messageBytes = this.bytes(message), messageBytes.length, keyBytes = LazySodium.toBin(key));
        if (!res) {
            throw new SodiumException("Could not apply auth tag to your message.");
        }
        return LazySodium.toHex(tag);
    }

    @Override
    public boolean cryptoAuthVerify(String tag, String message, String key) {
        byte[] tagToBytes = LazySodium.toBin(tag);
        byte[] messageBytes = this.bytes(message);
        byte[] keyBytes = LazySodium.toBin(key);
        return this.cryptoAuthVerify(tagToBytes, messageBytes, messageBytes.length, keyBytes);
    }

    @Override
    public boolean cryptoShortHash(byte[] out, byte[] in, long inLen, byte[] key) {
        return this.boolify(this.nacl.crypto_shorthash(out, in, inLen, key));
    }

    @Override
    public void cryptoShortHashKeygen(byte[] k) {
        this.nacl.crypto_shorthash_keygen(k);
    }

    @Override
    public String cryptoShortHash(String in, String key) throws SodiumException {
        byte[] inBytes = LazySodium.hexToBytes(in);
        byte[] keyBytes = LazySodium.hexToBytes(key);
        byte[] out = this.randomBytesBuf(8);
        if (this.nacl.crypto_shorthash(out, inBytes, inBytes.length, keyBytes) != 0) {
            throw new SodiumException("Failed short-input hashing.");
        }
        return this.sodiumBin2Hex(out);
    }

    @Override
    public String cryptoShortHashKeygen() {
        byte[] key = this.randomBytesBuf(16);
        this.nacl.crypto_shorthash_keygen(key);
        return this.sodiumBin2Hex(key);
    }

    @Override
    public boolean cryptoGenericHash(byte[] out, int outLen, byte[] in, long inLen, byte[] key, int keyLen) {
        return this.boolify(this.nacl.crypto_generichash(out, outLen, in, inLen, key, keyLen));
    }

    @Override
    public boolean cryptoGenericHashInit(GenericHash.State state, byte[] key, int keyLength, int outLen) {
        return this.boolify(this.nacl.crypto_generichash_init(state, key, keyLength, outLen));
    }

    @Override
    public boolean cryptoGenericHashUpdate(GenericHash.State state, byte[] in, long inLen) {
        return this.boolify(this.nacl.crypto_generichash_update(state, in, inLen));
    }

    @Override
    public boolean cryptoGenericHashFinal(GenericHash.State state, byte[] out, int outLen) {
        return this.boolify(this.nacl.crypto_generichash_final(state, out, outLen));
    }

    @Override
    public void cryptoGenericHashKeygen(byte[] k) {
        this.nacl.crypto_generichash_keygen(k);
    }

    @Override
    public String cryptoGenericHashKeygen() {
        byte[] key = this.randomBytesBuf(32);
        this.cryptoGenericHashKeygen(key);
        return LazySodium.toHex(key);
    }

    @Override
    public String cryptoGenericHash(String in) throws SodiumException {
        byte[] message = this.bytes(in);
        byte[] hash = this.randomBytesBuf(32);
        boolean res = this.cryptoGenericHash(hash, hash.length, message, message.length, null, 0);
        if (!res) {
            throw new SodiumException("Error could not hash the message.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public String cryptoGenericHash(String in, String key) throws SodiumException {
        byte[] message = this.bytes(in);
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] hash = this.randomBytesBuf(32);
        boolean res = this.cryptoGenericHash(hash, hash.length, message, message.length, keyBytes, keyBytes.length);
        if (!res) {
            throw new SodiumException("Could not hash the message.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public boolean cryptoGenericHashInit(GenericHash.State state, String key, int outLen) {
        byte[] keyBytes = LazySodium.toBin(key);
        return this.cryptoGenericHashInit(state, keyBytes, keyBytes.length, outLen);
    }

    @Override
    public String cryptoGenericHashUpdate(GenericHash.State state, String in) throws SodiumException {
        byte[] inBytes = this.bytes(in);
        boolean res = this.cryptoGenericHashUpdate(state, inBytes, inBytes.length);
        if (!res) {
            throw new SodiumException("Could not hash part of the message.");
        }
        return LazySodium.toHex(inBytes);
    }

    @Override
    public String cryptoGenericHashFinal(GenericHash.State state, int outLen) throws SodiumException {
        byte[] hash = this.randomBytesBuf(outLen);
        boolean res = this.cryptoGenericHashFinal(state, hash, hash.length);
        if (!res) {
            throw new SodiumException("Could not hash the final part of the message.");
        }
        return LazySodium.toHex(hash);
    }

    @Override
    public void cryptoAeadChaCha20Poly1305Keygen(byte[] key) {
        this.nacl.crypto_aead_chacha20poly1305_keygen(key);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305Encrypt(byte[] c, long cLen, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_encrypt(c, cLen, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305Decrypt(byte[] m, long mLen, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_decrypt(m, mLen, nSec, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305EncryptDetached(byte[] c, byte[] mac, Long macLenAddress, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305DecryptDetached(byte[] m, byte[] nSec, byte[] c, long cLen, byte[] mac, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_decrypt_detached(m, nSec, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    public void cryptoAeadChaCha20Poly1305IetfKeygen(byte[] key) {
        this.nacl.crypto_aead_chacha20poly1305_ietf_keygen(key);
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfEncrypt(byte[] c, long cLen, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_ietf_encrypt(c, cLen, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfDecrypt(byte[] m, long mLen, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_ietf_decrypt(m, mLen, nSec, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, Long macLenAddress, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_ietf_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] nSec, byte[] c, long cLen, byte[] mac, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_chacha20poly1305_decrypt_detached(m, nSec, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    public void cryptoAeadXChaCha20Poly1305IetfKeygen(byte[] k) {
        this.nacl.crypto_aead_xchacha20poly1305_ietf_keygen(k);
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfEncrypt(byte[] c, long cLen, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_xchacha20poly1305_ietf_encrypt(c, cLen, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfDecrypt(byte[] m, long mLen, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_xchacha20poly1305_ietf_decrypt(m, mLen, nSec, c, cLen, ad, adLen, nPub, k));
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfEncryptDetached(byte[] c, byte[] mac, Long macLenAddress, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_xchacha20poly1305_ietf_encrypt_detached(c, mac, macLenAddress, m, mLen, ad, adLen, nSec, nPub, k));
    }

    @Override
    public boolean cryptoAeadXChaCha20Poly1305IetfDecryptDetached(byte[] m, byte[] nSec, byte[] c, long cLen, byte[] mac, byte[] ad, long adLen, byte[] nPub, byte[] k) {
        return this.boolify(this.nacl.crypto_aead_xchacha20poly1305_ietf_decrypt_detached(m, nSec, c, cLen, mac, ad, adLen, nPub, k));
    }

    @Override
    public String keygen(AEAD.Method method) {
        switch (method) {
            case CHACHA20_POLY1305: {
                byte[] key = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305Keygen(key);
                return LazySodium.toHex(key);
            }
            case CHACHA20_POLY1305_IETF: {
                byte[] key2 = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305IetfKeygen(key2);
                return LazySodium.toHex(key2);
            }
            case XCHACHA20_POLY1305_IETF: {
                byte[] key3 = this.randomBytesBuf(32);
                this.cryptoAeadChaCha20Poly1305IetfKeygen(key3);
                return LazySodium.toHex(key3);
            }
        }
        return null;
    }

    @Override
    public String encrypt(String m, String additionalData, byte[] nSec, byte[] nPub, String k, AEAD.Method method) {
        byte[] messageBytes = this.bytes(m);
        byte[] additionalDataBytes = this.bytes(additionalData);
        byte[] keyBytes = LazySodium.toBin(k);
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            byte[] cipherBytes = new byte[messageBytes.length + 16];
            this.cryptoAeadChaCha20Poly1305Encrypt(cipherBytes, cipherBytes.length, messageBytes, messageBytes.length, additionalDataBytes, additionalDataBytes.length, nSec, nPub, keyBytes);
            return LazySodium.toHex(cipherBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            byte[] cipherBytes2 = new byte[messageBytes.length + 16];
            this.cryptoAeadChaCha20Poly1305IetfEncrypt(cipherBytes2, cipherBytes2.length, messageBytes, messageBytes.length, additionalDataBytes, additionalDataBytes.length, nSec, nPub, keyBytes);
            return LazySodium.toHex(cipherBytes2);
        }
        byte[] cipherBytes3 = new byte[messageBytes.length + 16];
        this.cryptoAeadXChaCha20Poly1305IetfEncrypt(cipherBytes3, cipherBytes3.length, messageBytes, messageBytes.length, additionalDataBytes, additionalDataBytes.length, nSec, nPub, keyBytes);
        return LazySodium.toHex(cipherBytes3);
    }

    @Override
    public String decrypt(String cipher, String ad, byte[] nSec, byte[] nPub, String k, AEAD.Method method) {
        byte[] cipherBytes = this.bytes(cipher);
        byte[] additionalDataBytes = this.bytes(ad);
        byte[] keyBytes = LazySodium.toBin(k);
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            byte[] messageBytes = new byte[cipherBytes.length - 16];
            this.cryptoAeadChaCha20Poly1305Decrypt(messageBytes, messageBytes.length, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalDataBytes.length, nPub, keyBytes);
            return this.str(messageBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            byte[] messageBytes = new byte[cipherBytes.length - 16];
            this.cryptoAeadChaCha20Poly1305Decrypt(messageBytes, messageBytes.length, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalDataBytes.length, nPub, keyBytes);
            return this.str(messageBytes);
        }
        byte[] messageBytes = new byte[cipherBytes.length - 16];
        this.cryptoAeadXChaCha20Poly1305IetfDecrypt(messageBytes, messageBytes.length, nSec, cipherBytes, cipherBytes.length, additionalDataBytes, additionalDataBytes.length, nPub, keyBytes);
        return this.str(messageBytes);
    }

    @Override
    public DetachedEncrypt encryptDetached(String m, String additionalData, byte[] nSec, byte[] nPub, String k, AEAD.Method method) {
        byte[] messageBytes = this.bytes(m);
        byte[] additionalDataBytes = this.bytes(additionalData);
        byte[] keyBytes = LazySodium.toBin(k);
        byte[] cipherBytes = new byte[messageBytes.length];
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            byte[] macBytes = new byte[16];
            this.cryptoAeadChaCha20Poly1305EncryptDetached(cipherBytes, macBytes, null, messageBytes, messageBytes.length, additionalDataBytes, additionalDataBytes.length, nSec, nPub, keyBytes);
            return new DetachedEncrypt(cipherBytes, macBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            byte[] macBytes = new byte[16];
            this.cryptoAeadChaCha20Poly1305IetfEncrypt(cipherBytes, cipherBytes.length, messageBytes, messageBytes.length, additionalDataBytes, additionalDataBytes.length, nSec, nPub, keyBytes);
            return new DetachedEncrypt(cipherBytes, macBytes);
        }
        byte[] macBytes = new byte[16];
        this.cryptoAeadXChaCha20Poly1305IetfEncrypt(cipherBytes, cipherBytes.length, messageBytes, messageBytes.length, additionalDataBytes, additionalDataBytes.length, nSec, nPub, keyBytes);
        return new DetachedEncrypt(cipherBytes, macBytes);
    }

    @Override
    public DetachedDecrypt decryptDetached(DetachedEncrypt detachedEncrypt, String additionalData, byte[] nSec, byte[] nPub, String k, AEAD.Method method) {
        byte[] cipherBytes = detachedEncrypt.getCipher();
        byte[] additionalDataBytes = this.bytes(additionalData);
        byte[] keyBytes = LazySodium.toBin(k);
        byte[] messageBytes = new byte[cipherBytes.length];
        byte[] macBytes = detachedEncrypt.getMac();
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305)) {
            this.cryptoAeadChaCha20Poly1305DecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalDataBytes.length, nPub, keyBytes);
            return new DetachedDecrypt(messageBytes, macBytes);
        }
        if (method.equals((Object)AEAD.Method.CHACHA20_POLY1305_IETF)) {
            this.cryptoAeadChaCha20Poly1305IetfDecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalDataBytes.length, nPub, keyBytes);
            return new DetachedDecrypt(messageBytes, macBytes);
        }
        this.cryptoAeadXChaCha20Poly1305IetfDecryptDetached(messageBytes, nSec, cipherBytes, cipherBytes.length, macBytes, additionalDataBytes, additionalDataBytes.length, nPub, keyBytes);
        return new DetachedDecrypt(messageBytes, macBytes);
    }

    @Override
    public <T> T res(int res, T object) {
        return res != 0 ? null : (T)object;
    }

    @Override
    public boolean boolify(int res) {
        return res == 0;
    }

    @Override
    public String str(byte[] bs) {
        return new String(bs, this.charset);
    }

    @Override
    public String str(byte[] bs, Charset charset) {
        if (charset == null) {
            return new String(bs, this.charset);
        }
        return new String(bs, charset);
    }

    @Override
    public byte[] bytes(String s) {
        return s.getBytes(this.charset);
    }

    @Override
    public boolean wrongLen(byte[] bs, int shouldBe) {
        return bs.length != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, int shouldBe) {
        return byteLength != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, long shouldBe) {
        return (long)byteLength != shouldBe;
    }

    @Override
    public byte[] removeNulls(byte[] bs) {
        int totalBytesToCut = 0;
        for (int i = bs.length - 1; i >= 0; --i) {
            byte b = bs[i];
            if (b != 0) continue;
            ++totalBytesToCut;
        }
        int newLengthOfBs = bs.length - totalBytesToCut;
        byte[] trimmed = new byte[newLengthOfBs];
        System.arraycopy(bs, 0, trimmed, 0, newLengthOfBs);
        return trimmed;
    }

    public static Integer longToInt(long lng) {
        if (lng > Integer.MAX_VALUE) {
            return 0x7FFFFF37;
        }
        if (lng < 0L) {
            return 0;
        }
        return (int)lng;
    }

    public static void main(String[] args) {
    }
}

