/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium;

import com.goterl.lazycode.lazysodium.Sodium;
import com.goterl.lazycode.lazysodium.utils.NativeUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;

public class SodiumJava
extends Sodium {
    public SodiumJava() {
        this.registerFromResources();
    }

    public SodiumJava(String path) {
        Native.register(SodiumJava.class, (String)path);
    }

    private void registerFromResources() {
        String path = this.getLibSodiumFromResources();
        try {
            NativeUtils.loadLibraryFromJar(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getLibSodiumFromResources() {
        String path = this.getPath("windows", "libsodium.dll");
        if (Platform.isLinux() || Platform.isAndroid()) {
            path = this.getPath("linux", "libsodium.so");
        } else if (Platform.isMac()) {
            path = this.getPath("mac", "libsodium.dylib");
        }
        return path;
    }

    private String getPath(String folder, String name) {
        String resourcePath = folder + File.separator + name;
        if (!resourcePath.startsWith(File.separator)) {
            resourcePath = File.separator + resourcePath;
        }
        return resourcePath;
    }
}

