/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.utils.BaseChecker;
import java.util.HashMap;
import java.util.Map;

public interface PwHash {
    public static final int ARGON2ID_SALTBYTES = 16;
    public static final int ARGON2ID_BYTES_MIN = 16;
    public static final int ARGON2ID_STR_BYTES = 128;
    public static final int SALTBYTES = 16;
    public static final int STR_BYTES = 128;
    public static final long ARGON2ID_PASSWD_MIN = 0L;
    public static final long ARGON2ID_PASSWD_MAX = 0xFFFFFFFFL;
    public static final long ARGON2ID_BYTES_MAX = 0xFFFFFFFFL;
    public static final long ARGON2ID_OPSLIMIT_MIN = 1L;
    public static final long ARGON2ID_OPSLIMIT_MAX = 0xFFFFFFFFL;
    public static final long ARGON2ID_OPSLIMIT_INTERACTIVE = 2L;
    public static final long ARGON2ID_OPSLIMIT_MODERATE = 3L;
    public static final long ARGON2ID_OPSLIMIT_SENSITIVE = 4L;
    public static final long ARGON2ID_MEMLIMIT_MIN = 8192L;
    public static final long ARGON2ID_MEMLIMIT_MAX = 4398046510080L;
    public static final long ARGON2ID_MEMLIMIT_INTERACTIVE = 0x4000000L;
    public static final long ARGON2ID_MEMLIMIT_MODERATE = 0x10000000L;
    public static final long ARGON2ID_MEMLIMIT_SENSITIVE = 0x40000000L;
    public static final long PASSWD_MIN = 0L;
    public static final long PASSWD_MAX = 0xFFFFFFFFL;
    public static final long BYTES_MIN = 16L;
    public static final long BYTES_MAX = 0xFFFFFFFFL;
    public static final long OPSLIMIT_MIN = 1L;
    public static final long OPSLIMIT_MAX = 0xFFFFFFFFL;
    public static final long OPSLIMIT_MODERATE = 3L;
    public static final long OPSLIMIT_INTERACTIVE = 2L;
    public static final long OPSLIMIT_SENSITIVE = 4L;
    public static final long MEMLIMIT_MIN = 8192L;
    public static final long MEMLIMIT_INTERACTIVE = 0x4000000L;
    public static final long MEMLIMIT_SENSITIVE = 0x40000000L;
    public static final long MEMLIMIT_MODERATE = 0x10000000L;
    public static final long MEMLIMIT_MAX = 4398046510080L;

    public static enum Alg {
        PWHASH_ALG_ARGON2I13(1),
        PWHASH_ALG_ARGON2ID13(2);

        private final int val;
        private static final Map<Integer, Alg> map;

        private Alg(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }

        public static Alg getDefault() {
            return PWHASH_ALG_ARGON2ID13;
        }

        public static Alg valueOf(int alg) {
            return map.get(alg);
        }

        private static Map<Integer, Alg> getMap() {
            HashMap<Integer, Alg> map = new HashMap<Integer, Alg>();
            for (Alg alg : Alg.values()) {
                map.put(alg.val, alg);
            }
            return map;
        }

        static {
            map = Alg.getMap();
        }
    }

    public static interface Lazy {
        public byte[] cryptoPwHash(int var1, byte[] var2, byte[] var3, long var4, long var6, Alg var8) throws SodiumException;

        public String cryptoPwHashStr(String var1, long var2, long var4) throws SodiumException;

        public String cryptoPwHashStrRemoveNulls(String var1, long var2, long var4) throws SodiumException;

        public boolean cryptoPwHashStrVerify(String var1, String var2);
    }

    public static interface Native {
        public boolean cryptoPwHash(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, long var10, Alg var12);

        public boolean cryptoPwHashStr(byte[] var1, byte[] var2, long var3, long var5, long var7);

        public boolean cryptoPwHashStrVerify(byte[] var1, byte[] var2, long var3);

        public boolean cryptoPwHashStrNeedsRehash(byte[] var1, long var2, long var4);
    }

    public static class Checker
    extends BaseChecker {
        public static boolean saltIsCorrect(long saltLen) {
            return Checker.correctLen(saltLen, 16L);
        }

        public static boolean passwordIsCorrect(long len) {
            return Checker.isBetween(len, 0L, 0xFFFFFFFFL);
        }

        public static boolean opsLimitIsCorrect(long ops) {
            return Checker.isBetween(ops, 1L, 0xFFFFFFFFL);
        }

        public static boolean memLimitIsCorrect(long len) {
            return Checker.isBetween(len, 8192L, 4398046510080L);
        }

        public static boolean checkAll(long passwordBytesLen, long saltBytesLen, long opsLimit, long memLimit) throws SodiumException {
            if (!Checker.saltIsCorrect(saltBytesLen)) {
                throw new SodiumException("The salt provided is not the correct length.");
            }
            if (!Checker.passwordIsCorrect(passwordBytesLen)) {
                throw new SodiumException("The password provided is not the correct length.");
            }
            if (!Checker.opsLimitIsCorrect(opsLimit)) {
                throw new SodiumException("The opsLimit provided is not the correct value.");
            }
            if (!Checker.memLimitIsCorrect(memLimit)) {
                throw new SodiumException("The memLimit provided is not the correct value.");
            }
            return true;
        }
    }
}

