/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium;

import com.goterl.lazycode.lazysodium.Sodium;
import com.goterl.lazycode.lazysodium.exceptions.SodiumException;
import com.goterl.lazycode.lazysodium.interfaces.Auth;
import com.goterl.lazycode.lazysodium.interfaces.Base;
import com.goterl.lazycode.lazysodium.interfaces.CryptoBox;
import com.goterl.lazycode.lazysodium.interfaces.GenericHash;
import com.goterl.lazycode.lazysodium.interfaces.Helpers;
import com.goterl.lazycode.lazysodium.interfaces.KeyDerivation;
import com.goterl.lazycode.lazysodium.interfaces.KeyExchange;
import com.goterl.lazycode.lazysodium.interfaces.Padding;
import com.goterl.lazycode.lazysodium.interfaces.PwHash;
import com.goterl.lazycode.lazysodium.interfaces.Random;
import com.goterl.lazycode.lazysodium.interfaces.SecretBox;
import com.goterl.lazycode.lazysodium.interfaces.SecretStream;
import com.goterl.lazycode.lazysodium.interfaces.ShortHash;
import com.goterl.lazycode.lazysodium.utils.KeyPair;
import com.goterl.lazycode.lazysodium.utils.SessionPair;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class LazySodium
implements Base,
Random,
GenericHash.Native,
GenericHash.Lazy,
ShortHash.Native,
ShortHash.Lazy,
Auth.Native,
Auth.Lazy,
SecretStream.Native,
SecretStream.Lazy,
Padding.Native,
Padding.Lazy,
Helpers.Native,
Helpers.Lazy,
PwHash.Native,
PwHash.Lazy,
CryptoBox.Native,
CryptoBox.Lazy,
SecretBox.Native,
SecretBox.Lazy,
KeyExchange.Native,
KeyExchange.Lazy,
KeyDerivation.Native,
KeyDerivation.Lazy {
    private final Sodium nacl;
    private Charset charset = StandardCharsets.UTF_8;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public LazySodium(Sodium sodium) {
        this.nacl = sodium;
        this.init();
    }

    public LazySodium(Sodium sodium, Charset charset) {
        this.nacl = sodium;
        this.charset = charset;
        this.init();
    }

    private void init() {
    }

    @Override
    public String sodiumBin2Hex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    @Override
    public byte[] sodiumHex2Bin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    public static String toHex(byte[] bin) {
        return LazySodium.bytesToHex(bin);
    }

    public static byte[] toBin(String hex) {
        return LazySodium.hexToBytes(hex);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] hexToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public byte randomBytesRandom() {
        return this.nacl.randombytes_random();
    }

    @Override
    public byte[] randomBytesBuf(int size) {
        byte[] bs = new byte[size];
        this.nacl.randombytes_buf(bs, size);
        return bs;
    }

    @Override
    public byte[] nonce(int size) {
        return this.randomBytesBuf(size);
    }

    @Override
    public byte randomBytesUniform(int upperBound) {
        return this.nacl.randombytes_uniform(upperBound);
    }

    @Override
    public byte[] randomBytesDeterministic(int size, byte[] seed) {
        byte[] bs = new byte[size];
        this.nacl.randombytes_buf_deterministic(bs, size, seed);
        return bs;
    }

    @Override
    public boolean sodiumPad(int paddedBuffLen, char[] buf, int unpaddedBufLen, int blockSize, int maxBufLen) {
        return this.boolify(this.nacl.sodium_pad(paddedBuffLen, buf, unpaddedBufLen, blockSize, maxBufLen));
    }

    @Override
    public boolean sodiumUnpad(int unPaddedBuffLen, char[] buf, int paddedBufLen, int blockSize) {
        return this.boolify(this.nacl.sodium_unpad(unPaddedBuffLen, buf, paddedBufLen, blockSize));
    }

    @Override
    public void cryptoKdfKeygen(byte[] masterKey) {
        this.nacl.crypto_kdf_keygen(masterKey);
    }

    @Override
    public String cryptoKdfKeygen(Charset charset) {
        byte[] masterKeyInBytes = new byte[32];
        this.nacl.crypto_kdf_keygen(masterKeyInBytes);
        return this.sodiumBin2Hex(masterKeyInBytes);
    }

    @Override
    public String cryptoKdfKeygen() {
        byte[] masterKey = new byte[32];
        this.nacl.crypto_kdf_keygen(masterKey);
        return this.sodiumBin2Hex(masterKey);
    }

    @Override
    public String cryptoKdfDeriveFromKey(int lengthOfSubkey, long subKeyId, String context, byte[] masterKey) throws SodiumException {
        return this.cryptoKdfDeriveFromKey(lengthOfSubkey, subKeyId, context, this.sodiumBin2Hex(masterKey));
    }

    @Override
    public String cryptoKdfDeriveFromKey(int lengthOfSubkey, long subKeyId, String context, String masterKey) throws SodiumException {
        if (!KeyDerivation.Checker.subKeyIsCorrect(lengthOfSubkey)) {
            throw new SodiumException("Subkey is not between the correct lengths.");
        }
        if (!KeyDerivation.Checker.masterKeyIsCorrect(this.sodiumHex2Bin(masterKey).length)) {
            throw new SodiumException("Master key is not the correct length.");
        }
        if (!KeyDerivation.Checker.contextIsCorrect(this.bytes(context).length)) {
            throw new SodiumException("Context is not the correct length.");
        }
        byte[] subKey = new byte[lengthOfSubkey];
        byte[] contextAsBytes = this.bytes(context);
        byte[] masterKeyAsBytes = this.sodiumHex2Bin(masterKey);
        int res = this.nacl.crypto_kdf_derive_from_key(subKey, lengthOfSubkey, subKeyId, contextAsBytes, masterKeyAsBytes);
        return this.res(res, this.sodiumBin2Hex(subKey));
    }

    @Override
    public int cryptoKdfDeriveFromKey(byte[] subKey, int subKeyLen, long subKeyId, byte[] context, byte[] masterKey) {
        return this.nacl.crypto_kdf_derive_from_key(subKey, subKeyLen, subKeyId, context, masterKey);
    }

    @Override
    public boolean cryptoKxKeypair(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_kx_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoKxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.boolify(this.nacl.crypto_kx_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoKxClientSessionKeys(byte[] rx, byte[] tx, byte[] clientPk, byte[] clientSk, byte[] serverPk) {
        return this.boolify(this.nacl.crypto_kx_client_session_keys(rx, tx, clientPk, clientSk, serverPk));
    }

    @Override
    public boolean cryptoKxServerSessionKeys(byte[] rx, byte[] tx, byte[] serverPk, byte[] serverSk, byte[] clientPk) {
        return this.boolify(this.nacl.crypto_kx_server_session_keys(rx, tx, serverPk, serverSk, clientPk));
    }

    @Override
    public KeyPair cryptoKxKeypair() {
        byte[] secretKey = this.randomBytesBuf(32);
        byte[] publicKey = this.randomBytesBuf(32);
        this.nacl.crypto_kx_keypair(publicKey, secretKey);
        return new KeyPair(LazySodium.toHex(publicKey), LazySodium.toHex(secretKey));
    }

    @Override
    public KeyPair cryptoKxKeypair(byte[] seed) {
        byte[] secretKey = this.randomBytesBuf(32);
        byte[] publicKey = this.randomBytesBuf(32);
        this.nacl.crypto_kx_seed_keypair(publicKey, secretKey, seed);
        return new KeyPair(LazySodium.toHex(publicKey), LazySodium.toHex(secretKey));
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(byte[] clientPk, byte[] clientSk, byte[] serverPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxClientSessionKeys(rx, tx, clientPk, clientSk, serverPk)) {
            throw new SodiumException("Failure in creating client session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxClientSessionKeys(KeyPair clientKeyPair, KeyPair serverKeyPair) throws SodiumException {
        return this.cryptoKxClientSessionKeys(clientKeyPair.getPublicKey(), clientKeyPair.getSecretKey(), serverKeyPair.getPublicKey());
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(byte[] serverPk, byte[] serverSk, byte[] clientPk) throws SodiumException {
        byte[] rx = new byte[32];
        byte[] tx = new byte[32];
        if (!this.cryptoKxServerSessionKeys(rx, tx, serverPk, serverSk, clientPk)) {
            throw new SodiumException("Failure in creating server session keys.");
        }
        return new SessionPair(rx, tx);
    }

    @Override
    public SessionPair cryptoKxServerSessionKeys(KeyPair serverKeyPair, KeyPair clientKeyPair) throws SodiumException {
        return this.cryptoKxServerSessionKeys(serverKeyPair.getPublicKey(), serverKeyPair.getSecretKey(), clientKeyPair.getPublicKey());
    }

    @Override
    public boolean cryptoPwHash(byte[] outputHash, long outputHashLen, byte[] password, long passwordLen, byte[] salt, long opsLimit, long memLimit, PwHash.Alg alg) {
        int res = this.nacl.crypto_pwhash(outputHash, outputHashLen, password, passwordLen, salt, opsLimit, memLimit, alg.getValue());
        return this.boolify(res);
    }

    @Override
    public boolean cryptoPwHashStr(byte[] outputStr, byte[] password, long passwordLen, long opsLimit, long memLimit) {
        int res = this.nacl.crypto_pwhash_str(outputStr, password, passwordLen, opsLimit, memLimit);
        return this.boolify(res);
    }

    @Override
    public boolean cryptoPwHashStrVerify(byte[] hash, byte[] password, long passwordLen) {
        return this.boolify(this.nacl.crypto_pwhash_str_verify(hash, password, passwordLen));
    }

    @Override
    public boolean cryptoPwHashStrNeedsRehash(byte[] hash, long opsLimit, long memLimit) {
        return this.boolify(this.nacl.crypto_pwhash_str_needs_rehash(hash, opsLimit, memLimit));
    }

    @Override
    public byte[] cryptoPwHash(int lengthOfHash, byte[] password, byte[] salt, long opsLimit, long memLimit, PwHash.Alg alg) throws SodiumException {
        PwHash.Checker.checkAll(password.length, salt.length, opsLimit, memLimit);
        byte[] hash = new byte[lengthOfHash];
        this.cryptoPwHash(hash, hash.length, password, password.length, salt, opsLimit, memLimit, alg);
        return hash;
    }

    @Override
    public String cryptoPwHashStr(String password, long opsLimit, long memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        return this.str(hash);
    }

    @Override
    public String cryptoPwHashStrRemoveNulls(String password, long opsLimit, long memLimit) throws SodiumException {
        byte[] hash = new byte[128];
        byte[] passwordBytes = this.bytes(password);
        boolean res = this.cryptoPwHashStr(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Password hashing failed.");
        }
        byte[] hashNoNulls = this.removeNulls(hash);
        return this.str(hashNoNulls);
    }

    @Override
    public void cryptoSecretBoxKeygen(byte[] key) {
        this.nacl.crypto_secretbox_keygen(key);
    }

    @Override
    public boolean cryptoSecretBoxEasy(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_easy(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenEasy(byte[] message, byte[] cipherText, long cipherTextLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_open_easy(message, cipherText, cipherTextLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxDetached(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_detached(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoSecretBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, byte[] cipherTextLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_secretbox_open_detached(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public String cryptoSecretBoxKeygen() {
        byte[] key = new byte[32];
        this.cryptoSecretBoxKeygen(key);
        return LazySodium.toHex(key);
    }

    @Override
    public String cryptoSecretBoxEasy(String message, byte[] nonce, String key) throws SodiumException {
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] messageBytes = this.bytes(message);
        byte[] cipherTextBytes = new byte[16 + messageBytes.length];
        if (!this.cryptoSecretBoxEasy(cipherTextBytes, messageBytes, messageBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not encrypt message.");
        }
        return LazySodium.toHex(cipherTextBytes);
    }

    @Override
    public String cryptoSecretBoxOpenEasy(String cipher, byte[] nonce, String key, Charset charset) throws SodiumException {
        byte[] keyBytes = LazySodium.toBin(key);
        byte[] cipherBytes = LazySodium.toBin(cipher);
        byte[] messageBytes = new byte[cipherBytes.length - 16];
        if (!this.cryptoSecretBoxOpenEasy(messageBytes, cipherBytes, cipherBytes.length, nonce, keyBytes)) {
            throw new SodiumException("Could not decrypt message.");
        }
        return this.str(messageBytes, charset);
    }

    @Override
    public boolean cryptoBoxKeypair(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_keypair(publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxSeedKeypair(byte[] publicKey, byte[] secretKey, byte[] seed) {
        return this.boolify(this.nacl.crypto_box_seed_keypair(publicKey, secretKey, seed));
    }

    @Override
    public boolean cryptoScalarMultBase(byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_scalarmult_base(publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxEasy(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_easy(cipherText, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenEasy(byte[] message, byte[] cipherText, long cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_open_easy(message, cipherText, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxDetached(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_detached(cipherText, mac, message, messageLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxOpenDetached(byte[] message, byte[] cipherText, byte[] mac, byte[] cipherTextLen, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_open_detached(message, cipherText, mac, cipherTextLen, nonce, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxBeforeNm(byte[] k, byte[] publicKey, byte[] secretKey) {
        return this.boolify(this.nacl.crypto_box_beforenm(k, publicKey, secretKey));
    }

    @Override
    public boolean cryptoBoxEasyAfterNm(byte[] cipherText, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_easy_afternm(cipherText, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenEasyAfterNm(byte[] message, byte[] cipher, long cLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_open_easy_afternm(message, cipher, cLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxDetachedAfterNm(byte[] cipherText, byte[] mac, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_detached_afternm(cipherText, mac, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoBoxOpenDetachedAfterNm(byte[] message, byte[] cipherText, byte[] mac, byte[] cipherTextLen, byte[] nonce, byte[] key) {
        return this.boolify(this.nacl.crypto_box_open_detached_afternm(message, cipherText, mac, cipherTextLen, nonce, key));
    }

    @Override
    public KeyPair cryptoBoxKeypair() throws SodiumException {
        byte[] secretKey;
        byte[] publicKey = this.randomBytesBuf(32);
        if (!this.cryptoBoxKeypair(publicKey, secretKey = this.randomBytesBuf(32))) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoBoxSeedKeypair(byte[] seed) throws SodiumException {
        byte[] publicKey = this.randomBytesBuf(32);
        byte[] secretKey = this.randomBytesBuf(32);
        if (!CryptoBox.Checker.checkSeed(seed.length)) {
            throw new SodiumException("Seed is incorrect size.");
        }
        if (!this.cryptoBoxSeedKeypair(publicKey, secretKey, seed)) {
            throw new SodiumException("Unable to create a public and private key.");
        }
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoScalarMultBase(byte[] secretKey) throws SodiumException {
        if (!CryptoBox.Checker.checkSecretKey(secretKey.length)) {
            throw new SodiumException("Secret key is incorrect size.");
        }
        byte[] publicKey = this.randomBytesBuf(32);
        this.nacl.crypto_scalarmult_base(publicKey, secretKey);
        return new KeyPair(publicKey, secretKey);
    }

    @Override
    public KeyPair cryptoScalarMultBase(String secretKey) throws SodiumException {
        byte[] secretKeyBytes = LazySodium.toBin(secretKey);
        return this.cryptoScalarMultBase(secretKeyBytes);
    }

    @Override
    public String cryptoBoxEasy(String message, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] messageBytes = this.bytes(message);
        byte[] cipherBytes = this.randomBytesBuf(16 + messageBytes.length);
        boolean res = this.cryptoBoxEasy(cipherBytes, messageBytes, messageBytes.length, nonce, keyPair.getPublicKey(), keyPair.getSecretKey());
        if (!res) {
            throw new SodiumException("Could not encrypt your message.");
        }
        return LazySodium.toHex(cipherBytes);
    }

    @Override
    public String cryptoBoxOpenEasy(String cipherText, byte[] nonce, KeyPair keyPair) throws SodiumException {
        byte[] cipher = LazySodium.toBin(cipherText);
        byte[] message = this.randomBytesBuf(cipher.length - 16);
        boolean res = this.cryptoBoxOpenEasy(message, cipher, cipher.length, nonce, keyPair.getPublicKey(), keyPair.getSecretKey());
        if (!res) {
            throw new SodiumException("Could not decrypt your message.");
        }
        return this.str(message);
    }

    @Override
    public void cryptoSecretStreamXChacha20Poly1305Keygen(byte[] key) {
        this.nacl.crypto_secretstream_xchacha20poly1305_keygen(key);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305InitPush(SecretStream.State state, byte[] header, byte[] key) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_init_push(state, header, key);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305Push(SecretStream.State state, byte[] cipher, Long cipherAddr, byte[] message, long messageLen, byte tag) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherAddr, message, messageLen, new byte[0], 0L, tag);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305Push(SecretStream.State state, byte[] cipher, byte[] message, long messageLen, byte tag) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, null, message, messageLen, new byte[0], 0L, tag);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305Push(SecretStream.State state, byte[] cipher, Long cipherAddr, byte[] message, long messageLen, byte[] additionalData, long additionalDataLen, byte tag) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_push(state, cipher, cipherAddr, message, messageLen, additionalData, additionalDataLen, tag);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305InitPull(SecretStream.State state, byte[] header, byte[] key) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_init_pull(state, header, key);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305Pull(SecretStream.State state, byte[] message, Long messageAddress, byte tag, byte[] cipher, long cipherLen, byte[] additionalData, long additionalDataLen) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_pull(state, message, messageAddress, tag, cipher, cipherLen, additionalData, additionalDataLen);
    }

    @Override
    public int cryptoSecretStreamXChacha20Poly1305Pull(SecretStream.State state, byte[] message, byte tag, byte[] cipher, long cipherLen) {
        return this.nacl.crypto_secretstream_xchacha20poly1305_pull(state, message, null, tag, cipher, cipherLen, new byte[0], 0L);
    }

    @Override
    public int cryptoAuth(byte[] tag, byte[] in, long inLen, byte[] key) {
        return this.nacl.crypto_auth(tag, in, inLen, key);
    }

    @Override
    public int cryptoAuthVerify(byte[] tag, byte[] in, long inLen, byte[] key) {
        return this.nacl.crypto_auth_verify(tag, in, inLen, key);
    }

    @Override
    public void cryptoAuthKeygen(byte[] k) {
        this.nacl.crypto_auth_keygen(k);
    }

    @Override
    public boolean cryptoShortHash(byte[] out, byte[] in, long inLen, byte[] key) {
        return this.boolify(this.nacl.crypto_shorthash(out, in, inLen, key));
    }

    @Override
    public void cryptoShortHashKeygen(byte[] k) {
        this.nacl.crypto_shorthash_keygen(k);
    }

    @Override
    public void cryptoShortHashX24Keygen(byte[] k) {
        this.nacl.crypto_shorthash_keygen(k);
    }

    @Override
    public String cryptoShortHash(String in, String key) throws SodiumException {
        byte[] inBytes = LazySodium.hexToBytes(in);
        byte[] keyBytes = LazySodium.hexToBytes(key);
        byte[] out = this.randomBytesBuf(8);
        if (this.nacl.crypto_shorthash(out, inBytes, inBytes.length, keyBytes) != 0) {
            throw new SodiumException("Failed short-input hashing.");
        }
        return this.sodiumBin2Hex(out);
    }

    @Override
    public String cryptoShortHashX24(String in, String key) throws SodiumException {
        byte[] inBytes = LazySodium.hexToBytes(in);
        byte[] keyBytes = LazySodium.hexToBytes(key);
        byte[] out = this.randomBytesBuf(16);
        if (this.nacl.crypto_shorthash_siphashx24(out, inBytes, inBytes.length, keyBytes) != 0) {
            throw new SodiumException("Failed short-input hashing.");
        }
        return this.sodiumBin2Hex(out);
    }

    @Override
    public String cryptoShortHashKeygen() {
        byte[] key = this.randomBytesBuf(16);
        this.nacl.crypto_shorthash_keygen(key);
        return this.sodiumBin2Hex(key);
    }

    @Override
    public String cryptoShortHashX24Keygen() {
        byte[] key = this.randomBytesBuf(16);
        this.nacl.crypto_shorthash_keygen(key);
        return this.sodiumBin2Hex(key);
    }

    @Override
    public int cryptoGenericHash(byte[] out, int outLen, byte[] in, long inLen, byte[] key, int keyLen) {
        return this.nacl.crypto_generichash(out, outLen, in, inLen, key, keyLen);
    }

    @Override
    public int cryptoGenericHashInit(GenericHash.State state, byte[] key, int keyLength, int outLen) {
        return this.nacl.crypto_generichash_init(state, key, keyLength, outLen);
    }

    @Override
    public int cryptoGenericHashUpdate(GenericHash.State state, byte[] in, long inLen) {
        return this.nacl.crypto_generichash_update(state, in, inLen);
    }

    @Override
    public int cryptoGenericHashFinal(GenericHash.State state, byte[] out, int outLen) {
        return this.nacl.crypto_generichash_final(state, out, outLen);
    }

    @Override
    public void cryptoGenericHashKeygen(byte[] k) {
        this.nacl.crypto_generichash_keygen(k);
    }

    @Override
    public <T> T res(int res, T object) {
        return res != 0 ? null : (T)object;
    }

    @Override
    public boolean boolify(int res) {
        return res == 0;
    }

    @Override
    public String str(byte[] bs) {
        return new String(bs, this.charset);
    }

    @Override
    public String str(byte[] bs, Charset charset) {
        if (charset == null) {
            return new String(bs, this.charset);
        }
        return new String(bs, charset);
    }

    @Override
    public byte[] bytes(String s) {
        return s.getBytes(this.charset);
    }

    @Override
    public boolean wrongLen(byte[] bs, int shouldBe) {
        return bs.length != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, int shouldBe) {
        return byteLength != shouldBe;
    }

    @Override
    public boolean wrongLen(int byteLength, long shouldBe) {
        return (long)byteLength != shouldBe;
    }

    @Override
    public byte[] removeNulls(byte[] bs) {
        int totalBytesToCut = 0;
        for (int i = bs.length - 1; i >= 0; --i) {
            byte b = bs[i];
            if (b != 0) continue;
            ++totalBytesToCut;
        }
        int newLengthOfBs = bs.length - totalBytesToCut;
        byte[] trimmed = new byte[newLengthOfBs];
        System.arraycopy(bs, 0, trimmed, 0, newLengthOfBs);
        return trimmed;
    }

    public static void main(String[] args) {
    }
}

