/*
 * Decompiled with CFR 0.152.
 */
package com.gospelware.compassviewlib;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.gospelware.compassviewlib.R;

public class CompassView
extends View {
    private float centerX;
    private float centerY;
    private Paint circlePaint;
    private Paint pointerPaint;
    private Paint ringPaint;
    private Paint shaderPaint;
    private Shader shader;
    private float strokeWidth;
    private int ringColor;
    private int circleColor;
    private float circleRadius;
    private float offset;
    private boolean showRing;
    private Bitmap pointerBitmap;
    private int rotation;
    private Animator scanAnimator;
    private int scan;

    public CompassView(Context context) {
        this(context, null);
    }

    public CompassView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompassView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CompassView);
        float density = this.getResources().getDisplayMetrics().density;
        this.strokeWidth = 5.0f * density;
        this.offset = 8.0f * density;
        try {
            this.circleColor = a.getColor(R.styleable.CompassView_circleColor, -16777216);
            this.ringColor = a.getColor(R.styleable.CompassView_ringColor, -1);
            this.showRing = a.getBoolean(R.styleable.CompassView_showRing, true);
            this.rotation = a.getInt(R.styleable.CompassView_pointerRotation, 0);
            int bitmapId = a.getResourceId(R.styleable.CompassView_pointerDrawable, 0);
            this.pointerBitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)bitmapId);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.circleRadius = this.centerX;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private void init() {
        this.ringPaint = new Paint(1);
        this.ringPaint.setColor(this.ringColor);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.ringPaint.setStrokeWidth(this.strokeWidth);
        this.circlePaint = new Paint(1);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(this.circleColor);
        this.pointerPaint = new Paint(1);
        this.pointerPaint.setColor(this.ringColor);
        this.shaderPaint = new Paint(1);
        this.shaderPaint.setColor(this.ringColor);
        this.initScanAnimator();
    }

    private void initScanAnimator() {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), (String)"scan", (int[])new int[]{0, 360});
        animator.setDuration(2000L);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setRepeatCount(-1);
        this.scanAnimator = animator;
    }

    private void setScan(int degree) {
        this.scan = degree;
        this.invalidate();
    }

    public void startScan() {
        if (this.scanAnimator != null && !this.scanAnimator.isRunning()) {
            this.scanAnimator.start();
        }
    }

    public void stopScan() {
        if (this.scanAnimator != null && this.scanAnimator.isRunning()) {
            this.scanAnimator.end();
        }
    }

    public void setRingColor(int color) {
        this.ringColor = color;
        this.ringPaint.setColor(this.ringColor);
        this.pointerPaint.setColor(this.ringColor);
        this.shaderPaint.setColor(this.ringColor);
        this.shader = new SweepGradient(this.centerX, this.centerY, 0, this.ringColor);
        this.shaderPaint.setShader(this.shader);
        this.invalidate();
        this.requestLayout();
    }

    public void setCircleColor(int color) {
        this.circleColor = color;
        this.circlePaint.setColor(color);
        this.invalidate();
        this.requestLayout();
    }

    public boolean isShowRing() {
        return this.showRing;
    }

    public void setShowRing(boolean showRing) {
        this.showRing = showRing;
        this.invalidate();
        this.requestLayout();
    }

    public void setPointerDrawable(int id) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)id);
        if (bitmap != null) {
            this.pointerBitmap = bitmap;
            this.invalidate();
            this.requestLayout();
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.invalidate();
        this.requestLayout();
    }

    protected void onDraw(Canvas canvas) {
        this.drawCircle(canvas);
        if (this.showRing) {
            this.drawRing(canvas);
        }
        if (this.scanAnimator != null && this.scanAnimator.isRunning()) {
            this.drawScan(canvas);
        } else {
            this.drawPointer(canvas);
        }
        super.onDraw(canvas);
    }

    private void drawCircle(Canvas canvas) {
        canvas.drawCircle(this.centerX, this.centerY, this.circleRadius, this.circlePaint);
    }

    private void drawRing(Canvas canvas) {
        canvas.drawCircle(this.centerX, this.centerY, this.circleRadius - this.offset, this.ringPaint);
    }

    private void drawScan(Canvas canvas) {
        if (this.shader == null) {
            this.shader = new SweepGradient(this.centerX, this.centerY, 0, this.ringColor);
            this.shaderPaint.setShader(this.shader);
        }
        canvas.save();
        canvas.rotate((float)this.scan, this.centerX, this.centerY);
        canvas.drawCircle(this.centerX, this.centerY, this.circleRadius, this.shaderPaint);
        canvas.restore();
    }

    private void drawPointer(Canvas canvas) {
        canvas.save();
        canvas.rotate((float)this.rotation, this.centerX, this.centerY);
        if (this.pointerBitmap != null) {
            float scale = 4.0f * this.offset / (float)this.pointerBitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.preTranslate(this.centerX - (float)(this.pointerBitmap.getWidth() / 2), 2.0f * this.offset);
            matrix.preScale(scale, scale);
            canvas.drawBitmap(this.pointerBitmap, matrix, this.pointerPaint);
        } else {
            canvas.drawCircle(this.centerX, 3.0f * this.offset, this.offset, this.pointerPaint);
        }
        canvas.restore();
    }
}

