/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.samples;

import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.util.CastUtils;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMp4SampleList
extends AbstractList<Sample> {
    Container topLevel;
    TrackBox trackBox = null;
    SoftReference<Sample>[] cache = null;
    int[] chunkNumsStartSampleNum;
    long[] chunkOffsets;
    SampleSizeBox ssb;
    int lastChunk = 0;

    public DefaultMp4SampleList(long track, Container topLevel) {
        this.topLevel = topLevel;
        MovieBox movieBox = topLevel.getBoxes(MovieBox.class).get(0);
        List<TrackBox> trackBoxes = movieBox.getBoxes(TrackBox.class);
        for (TrackBox tb : trackBoxes) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
        this.chunkOffsets = this.trackBox.getSampleTableBox().getChunkOffsetBox().getChunkOffsets();
        this.cache = (SoftReference[])Array.newInstance(SoftReference.class, this.size());
        this.ssb = this.trackBox.getSampleTableBox().getSampleSizeBox();
        List<SampleToChunkBox.Entry> s2chunkEntries = this.trackBox.getSampleTableBox().getSampleToChunkBox().getEntries();
        SampleToChunkBox.Entry[] entries = s2chunkEntries.toArray(new SampleToChunkBox.Entry[s2chunkEntries.size()]);
        int s2cIndex = 0;
        SampleToChunkBox.Entry next = entries[s2cIndex++];
        int currentChunkNo = 0;
        int currentSamplePerChunk = 0;
        long nextFirstChunk = next.getFirstChunk();
        int nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
        int currentSampleNo = 1;
        int lastSampleNo = this.size();
        do {
            if ((long)(++currentChunkNo) != nextFirstChunk) continue;
            currentSamplePerChunk = nextSamplePerChunk;
            if (entries.length > s2cIndex) {
                next = entries[s2cIndex++];
                nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
                nextFirstChunk = next.getFirstChunk();
                continue;
            }
            nextSamplePerChunk = -1;
            nextFirstChunk = Long.MAX_VALUE;
        } while ((currentSampleNo += currentSamplePerChunk) <= lastSampleNo);
        this.chunkNumsStartSampleNum = new int[currentChunkNo + 1];
        s2cIndex = 0;
        next = entries[s2cIndex++];
        currentChunkNo = 0;
        currentSamplePerChunk = 0;
        nextFirstChunk = next.getFirstChunk();
        nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
        currentSampleNo = 1;
        do {
            this.chunkNumsStartSampleNum[currentChunkNo++] = currentSampleNo;
            if ((long)currentChunkNo != nextFirstChunk) continue;
            currentSamplePerChunk = nextSamplePerChunk;
            if (entries.length > s2cIndex) {
                next = entries[s2cIndex++];
                nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
                nextFirstChunk = next.getFirstChunk();
                continue;
            }
            nextSamplePerChunk = -1;
            nextFirstChunk = Long.MAX_VALUE;
        } while ((currentSampleNo += currentSamplePerChunk) <= lastSampleNo);
        this.chunkNumsStartSampleNum[currentChunkNo] = Integer.MAX_VALUE;
    }

    synchronized int getChunkForSample(int index) {
        int sampleNum = index + 1;
        if (sampleNum >= this.chunkNumsStartSampleNum[this.lastChunk] && sampleNum < this.chunkNumsStartSampleNum[this.lastChunk + 1]) {
            return this.lastChunk;
        }
        if (sampleNum < this.chunkNumsStartSampleNum[this.lastChunk]) {
            this.lastChunk = 0;
            while (this.chunkNumsStartSampleNum[this.lastChunk + 1] <= sampleNum) {
                ++this.lastChunk;
            }
            return this.lastChunk;
        }
        ++this.lastChunk;
        while (this.chunkNumsStartSampleNum[this.lastChunk + 1] <= sampleNum) {
            ++this.lastChunk;
        }
        return this.lastChunk;
    }

    @Override
    public Sample get(int index) {
        if (index >= this.cache.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cache[index] != null && this.cache[index].get() != null) {
            return this.cache[index].get();
        }
        int currentChunkNoZeroBased = this.getChunkForSample(index);
        int currentSampleNo = this.chunkNumsStartSampleNum[currentChunkNoZeroBased];
        long offset = this.chunkOffsets[CastUtils.l2i(currentChunkNoZeroBased)];
        while (currentSampleNo < index + 1) {
            offset += this.ssb.getSampleSizeAtIndex(currentSampleNo++ - 1);
        }
        long sampleSize = this.ssb.getSampleSizeAtIndex(currentSampleNo - 1);
        SampleImpl sampleImpl = new SampleImpl(offset, sampleSize, this.topLevel);
        this.cache[index] = new SoftReference<SampleImpl>(sampleImpl);
        return sampleImpl;
    }

    @Override
    public int size() {
        return CastUtils.l2i(this.trackBox.getSampleTableBox().getSampleSizeBox().getSampleCount());
    }
}

