/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class SampleImpl
implements Sample {
    private final long offset;
    private final long size;
    private ByteBuffer[] data;
    private final Container parent;

    public SampleImpl(ByteBuffer buf) {
        this.offset = -1L;
        this.size = buf.limit();
        this.data = new ByteBuffer[]{buf};
        this.parent = null;
    }

    public SampleImpl(ByteBuffer[] data) {
        this.offset = -1L;
        int _size = 0;
        ByteBuffer[] byteBufferArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer byteBuffer = byteBufferArray[n2];
            _size += byteBuffer.remaining();
            ++n2;
        }
        this.size = _size;
        this.data = data;
        this.parent = null;
    }

    public SampleImpl(long offset, long sampleSize, ByteBuffer data) {
        this.offset = offset;
        this.size = sampleSize;
        this.data = new ByteBuffer[]{data};
        this.parent = null;
    }

    public SampleImpl(long offset, long sampleSize, Container parent) {
        this.offset = offset;
        this.size = sampleSize;
        this.data = null;
        this.parent = parent;
    }

    protected void ensureData() {
        if (this.data != null) {
            return;
        }
        if (this.parent == null) {
            throw new RuntimeException("Missing parent container, can't read sample " + this);
        }
        try {
            this.data = new ByteBuffer[]{this.parent.getByteBuffer(this.offset, this.size)};
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't read sample " + this, e);
        }
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        this.ensureData();
        ByteBuffer[] byteBufferArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer b = byteBufferArray[n2];
            channel.write(b.duplicate());
            ++n2;
        }
    }

    public long getSize() {
        return this.size;
    }

    public ByteBuffer asByteBuffer() {
        this.ensureData();
        byte[] bCopy = new byte[CastUtils.l2i(this.size)];
        ByteBuffer copy = ByteBuffer.wrap(bCopy);
        ByteBuffer[] byteBufferArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer b = byteBufferArray[n2];
            copy.put(b.duplicate());
            ++n2;
        }
        copy.rewind();
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SampleImpl");
        sb.append("{offset=").append(this.offset);
        sb.append("{size=").append(this.size);
        sb.append('}');
        return sb.toString();
    }
}

