/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UnitLowerTriangDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DenseLU {
    private DenseMatrix LU;
    private int[] piv;
    private boolean singular;

    public DenseLU(int m, int n) {
        this.LU = new DenseMatrix(m, n);
        this.piv = new int[Math.min(m, n)];
    }

    public static DenseLU factorize(Matrix A) {
        return new DenseLU(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    public DenseLU factor(DenseMatrix A) {
        this.singular = false;
        intW info = new intW(0);
        LAPACK.getInstance().dgetrf(A.numRows(), A.numColumns(), A.getData(), Matrices.ld(A.numRows()), this.piv, info);
        if (info.val > 0) {
            this.singular = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.LU.set(A);
        return this;
    }

    public UnitLowerTriangDenseMatrix getL() {
        return new UnitLowerTriangDenseMatrix((Matrix)this.LU, false);
    }

    public UpperTriangDenseMatrix getU() {
        return new UpperTriangDenseMatrix((Matrix)this.LU, false);
    }

    public DenseMatrix getLU() {
        return this.LU;
    }

    public double rcond(Matrix A, Matrix.Norm norm) {
        if (norm != Matrix.Norm.One && norm != Matrix.Norm.Infinity) {
            throw new IllegalArgumentException("Only the 1 or the Infinity norms are supported");
        }
        double anorm = A.norm(norm);
        int n = A.numRows();
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        LAPACK.getInstance().dgecon(norm.netlib(), n, this.LU.getData(), Matrices.ld(n), anorm, rcond, new double[4 * n], new int[n], info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }

    public int[] getPivots() {
        return this.piv;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixSingularException {
        return this.solve(B, Transpose.NoTranspose);
    }

    public DenseMatrix transSolve(DenseMatrix B) throws MatrixSingularException {
        return this.solve(B, Transpose.Transpose);
    }

    private DenseMatrix solve(DenseMatrix B, Transpose trans) throws MatrixSingularException {
        if (this.singular) {
            throw new MatrixSingularException();
        }
        if (B.numRows() != this.LU.numRows()) {
            throw new IllegalArgumentException("B.numRows() != LU.numRows()");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgetrs(trans.netlib(), this.LU.numRows(), B.numColumns(), this.LU.getData(), Matrices.ld(this.LU.numRows()), this.piv, B.getData(), Matrices.ld(this.LU.numRows()), info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }
}

