/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Arrays;

public final class ThresholdFuncBitmap
extends UpdateableBitmapFunction {
    private int min;
    private long[] buffers;
    private int bufferUsed;
    private int[] bufcounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap(int min) {
        this.min = min;
        this.buffers = new long[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage out, int runbegin, int runend) {
        int runlength = runend - runbegin;
        if (this.hammingWeight >= this.min) {
            out.addStreamOfEmptyWords(true, runlength);
            return;
        }
        if (this.litWeight + this.hammingWeight < this.min) {
            out.addStreamOfEmptyWords(false, runlength);
        } else {
            int deficit = this.min - this.hammingWeight;
            if (deficit == 1) {
                this.orLiterals(out, runbegin, runlength);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == deficit) {
                this.andLiterals(out, runbegin, runlength);
            } else {
                this.generalLiterals(deficit, out, runbegin, runlength);
            }
        }
    }

    private long threshold2buf(int T, long[] buffers, int bufUsed) {
        long result = 0L;
        int[] counters = this.bufcounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k = 0; k < bufUsed; ++k) {
            long t;
            for (long bitset = buffers[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                int n = Long.bitCount(t - 1L);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < T) continue;
            result |= 1L << pos;
        }
        return result;
    }

    private static long threshold3(int T, long[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0L;
        }
        long[] v = new long[T];
        v[0] = buffers[0];
        for (int k = 1; k < bufUsed; ++k) {
            int m;
            long c = buffers[k];
            for (int j = m = Math.min(T - 1, k); j >= 1; --j) {
                int n = j;
                v[n] = v[n] | c & v[j - 1];
            }
            v[0] = v[0] | c;
        }
        return v[T - 1];
    }

    private long threshold4(int T, long[] buffers, int bufUsed) {
        if (T >= 128) {
            return this.threshold2buf(T, buffers, bufUsed);
        }
        int B = 0;
        for (int k = 0; k < bufUsed; ++k) {
            B += Long.bitCount(buffers[k]);
        }
        if (2 * B >= bufUsed * T) {
            return ThresholdFuncBitmap.threshold3(T, buffers, bufUsed);
        }
        return this.threshold2buf(T, buffers, bufUsed);
    }

    private final void orLiterals(BitmapStorage out, int runbegin, int runlength) {
        for (int i = 0; i < runlength; ++i) {
            long w = 0L;
            for (EWAHPointer R : this.getLiterals()) {
                w |= R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
            }
            out.add(w);
        }
    }

    private final void andLiterals(BitmapStorage out, int runbegin, int runlength) {
        for (int i = 0; i < runlength; ++i) {
            long w = -1L;
            for (EWAHPointer R : this.getLiterals()) {
                w &= R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
            }
            out.add(w);
        }
    }

    private final void generalLiterals(int deficit, BitmapStorage out, int runbegin, int runlength) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i = 0; i < runlength; ++i) {
            int p = 0;
            for (EWAHPointer R : this.getLiterals()) {
                this.buffers[p++] = R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
            }
            out.add(this.threshold4(deficit, this.buffers, this.bufferUsed));
        }
    }
}

