/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.BufferedRunningLengthWord32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.EWAHIterator32;

public class IteratingBufferedRunningLengthWord32 {
    private BufferedRunningLengthWord32 brlw;
    private int[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator32 iterator;

    public IteratingBufferedRunningLengthWord32(EWAHIterator32 iterator) {
        this.iterator = iterator;
        this.brlw = new BufferedRunningLengthWord32(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        this.buffer = this.iterator.buffer();
    }

    public void discardFirstWords(int x) {
        while (x > 0) {
            if (this.brlw.RunningLength >= x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0;
            int toDiscard = (x -= this.brlw.RunningLength) > this.brlw.NumberOfLiteralWords ? this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition += toDiscard;
            this.brlw.NumberOfLiteralWords -= toDiscard;
            if ((x -= toDiscard) <= 0 && this.brlw.size() != 0) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        }
    }

    public void discharge(BitmapStorage32 container) {
        this.brlw.literalwordoffset = this.literalWordStartPosition - this.iterator.literalWords();
        EWAHCompressedBitmap32.discharge(this.brlw, this.iterator, container);
    }

    public int getLiteralWordAt(int index) {
        return this.buffer[this.literalWordStartPosition + index];
    }

    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    public int getRunningLength() {
        return this.brlw.RunningLength;
    }

    public int size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int numWords, BitmapStorage32 container) {
        container.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }
}

