/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring.stream;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.gwtwidgets.server.spring.stream.SLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSLStreamWriterImpl
implements SLStreamWriter {
    private ServletOutputStream out;
    private boolean preampleSent = false;
    private int serial = 0;

    private int getNextSerial() {
        return this.serial++;
    }

    private void printPreample() {
        if (this.preampleSent) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            for (int i = 0; i < 1024; ++i) {
                sb.append(" ");
            }
            this.out.print(sb.toString());
            this.out.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.preampleSent = true;
    }

    public void setSerialStartpoint(int serial) {
        this.serial = serial;
    }

    @Override
    public void close() {
        try {
            this.out.print("<span>EOF</span></body></html>");
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setResponse(HttpServletResponse response) {
        try {
            this.out = response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeMessage(String content, Map<String, ?> attributes) {
        this.printPreample();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<div id='" + this.getNextSerial() + "'>");
            sb.append(URLEncoder.encode(content, "UTF-8"));
            if (attributes != null && attributes.size() > 0) {
                for (String attribute : attributes.keySet()) {
                    sb.append(",").append(URLEncoder.encode(attribute, "UTF-8")).append("=").append(URLEncoder.encode(attributes.get(attribute).toString(), "UTF-8"));
                }
            }
            sb.append("</div>");
            this.out.println(sb.toString());
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

