/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.DescriptorBuilder;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.ReferredTypesCollector;
import com.google.web.bindery.requestfactory.apt.ScannerBase;
import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.apt.TypeComparator;
import com.google.web.bindery.requestfactory.vm.impl.Deobfuscator;
import com.google.web.bindery.requestfactory.vm.impl.OperationData;
import com.google.web.bindery.requestfactory.vm.impl.OperationKey;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

class DeobfuscatorBuilder
extends ScannerBase<Void> {
    private TypeElement requestFactoryElement;
    private final StringBuilder sb = new StringBuilder();

    DeobfuscatorBuilder() {
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public Void visitExecutable(ExecutableElement x, State state) {
        if (this.shouldIgnore(x, state)) {
            return null;
        }
        final TypeElement requestContextElement = (TypeElement)state.types.asElement(x.getReturnType());
        new ScannerBase<Void>(){

            @Override
            public Void visitExecutable(ExecutableElement x, State state) {
                if (this.shouldIgnore(x, state)) {
                    return null;
                }
                String requestContextBinaryName = state.elements.getBinaryName(requestContextElement).toString();
                String clientMethodDescriptor = x.asType().accept(new DescriptorBuilder(), state);
                ExecutableElement domainElement = (ExecutableElement)state.getClientToDomainMap().get(x);
                if (domainElement == null) {
                    if (state.mustResolveAllAnnotations()) {
                        state.poison(requestContextElement, Messages.deobfuscatorMissingContext(requestContextElement.getSimpleName()));
                    }
                    return (Void)super.visitExecutable(x, state);
                }
                String domainMethodDescriptor = domainElement.asType().accept(new DescriptorBuilder(), state);
                String methodName = x.getSimpleName().toString();
                OperationKey key = new OperationKey(requestContextBinaryName, methodName, clientMethodDescriptor);
                DeobfuscatorBuilder.this.println("withOperation(new OperationKey(\"%s\"),", new Object[]{key.get()});
                DeobfuscatorBuilder.this.println("  new OperationData.Builder()", new Object[0]);
                DeobfuscatorBuilder.this.println("  .withClientMethodDescriptor(\"%s\")", new Object[]{clientMethodDescriptor});
                DeobfuscatorBuilder.this.println("  .withDomainMethodDescriptor(\"%s\")", new Object[]{domainMethodDescriptor});
                DeobfuscatorBuilder.this.println("  .withMethodName(\"%s\")", new Object[]{methodName});
                DeobfuscatorBuilder.this.println("  .withRequestContext(\"%s\")", new Object[]{requestContextBinaryName});
                DeobfuscatorBuilder.this.println("  .build());", new Object[0]);
                return (Void)super.visitExecutable(x, state);
            }

            @Override
            public Void visitType(TypeElement x, State state) {
                this.scanAllInheritedMethods(x, state);
                return null;
            }
        }.scan((Element)requestContextElement, state);
        return null;
    }

    @Override
    public Void visitType(TypeElement x, State state) {
        this.requestFactoryElement = x;
        String simpleName = this.computeSimpleName(x, state);
        String packageName = state.elements.getPackageOf(x).getQualifiedName().toString();
        this.println("// Automatically Generated -- DO NOT EDIT", new Object[0]);
        this.println("// %s", state.elements.getBinaryName(x));
        this.println("package %s;", packageName);
        this.println("import %s;", Arrays.class.getCanonicalName());
        this.println("import %s;", OperationData.class.getCanonicalName());
        this.println("import %s;", OperationKey.class.getCanonicalName());
        this.println("public final class %s extends %s {", simpleName, Deobfuscator.Builder.class.getCanonicalName());
        this.println("{", new Object[0]);
        this.scanAllInheritedMethods(x, state);
        this.writeTypeAndTokenMap(state);
        this.println("}}", new Object[0]);
        if (state.isPoisoned()) {
            return null;
        }
        try {
            JavaFileObject obj = state.filer.createSourceFile(packageName + "." + simpleName, x);
            Writer w = obj.openWriter();
            w.write(this.sb.toString());
            w.close();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            state.poison(x, sw.toString());
        }
        return null;
    }

    private String computeSimpleName(TypeElement x, State state) {
        String simpleName = state.elements.getBinaryName(x).toString() + "DeobfuscatorBuilder";
        if (state.isClientOnly()) {
            simpleName = simpleName + "Lite";
        }
        simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
        return simpleName;
    }

    private void println(String line, Object ... args) {
        this.sb.append(String.format(line, args)).append("\n");
    }

    private void writeTypeAndTokenMap(State state) {
        TypeComparator comparator = new TypeComparator(state);
        TreeMap<TypeElement, TreeSet<TypeElement>> domainToClientMappings = new TreeMap<TypeElement, TreeSet<TypeElement>>(comparator);
        Map<Element, Element> clientToDomainMap = state.getClientToDomainMap();
        Set<TypeElement> referredTypes = ReferredTypesCollector.collect(this.requestFactoryElement, state);
        for (TypeElement typeElement : referredTypes) {
            if (!state.types.isAssignable(typeElement.asType(), state.baseProxyType)) continue;
            String binaryName = state.elements.getBinaryName(typeElement).toString();
            this.println("withRawTypeToken(\"%s\", \"%s\");", OperationKey.hash(binaryName), binaryName);
            TypeElement domainType = (TypeElement)clientToDomainMap.get(typeElement);
            if (domainType == null) {
                if (!state.mustResolveAllAnnotations() || !state.isMappingRequired(domainType)) continue;
                state.poison(typeElement, Messages.deobfuscatorMissingProxy(typeElement.getSimpleName()));
                continue;
            }
            TreeSet<TypeElement> clientTypes = (TreeSet<TypeElement>)domainToClientMappings.get(domainType);
            if (clientTypes == null) {
                clientTypes = new TreeSet<TypeElement>(comparator);
                domainToClientMappings.put(domainType, clientTypes);
            }
            clientTypes.add(typeElement);
        }
        for (Map.Entry entry : domainToClientMappings.entrySet()) {
            StringBuilder list = new StringBuilder("Arrays.asList(");
            boolean needsComma = false;
            for (TypeElement elt : (SortedSet)entry.getValue()) {
                if (needsComma) {
                    list.append(", ");
                } else {
                    needsComma = true;
                }
                list.append('\"').append(state.elements.getBinaryName(elt)).append('\"');
            }
            list.append(")");
            this.println("withClientToDomainMappings(\"%s\", %s);", state.elements.getBinaryName((TypeElement)entry.getKey()), list);
        }
    }
}

