/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.internal.controller.ControllerServiceBridge;
import com.google.vr.sdk.controller.Controller;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;

public class ControllerManager {
    static final String TAG = "ControllerManager";
    private static final boolean DEBUG = false;
    public static final int SERVICE_TARGET_API_VERSION = 13;
    private final Context context;
    private final ControllerServiceBridge serviceBridge;
    private final EventListener serviceEventListener;
    private int connectionState = 3;

    public ControllerManager(Context context, EventListener listener) {
        this.context = context;
        this.serviceEventListener = listener;
        ControllerHolder defaultHolder = new ControllerHolder(new Controller(this, 0));
        this.serviceBridge = new ControllerServiceBridge(context, (ControllerServiceBridge.Callbacks)defaultHolder);
    }

    public void start() {
        this.serviceBridge.doBind();
    }

    public void stop() {
        this.serviceBridge.doUnbind();
    }

    public Controller getController() {
        return this.getController(0);
    }

    public Controller getController(int controllerId) {
        ControllerHolder holder = this.getControllerHolder(controllerId);
        if (holder == null) {
            try {
                holder = this.createAndConnectControllerHolder(controllerId);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Exception from service while connecting controller: ", (Throwable)e);
                return null;
            }
        }
        return holder == null ? null : holder.controller;
    }

    public void refreshAllControllers() {
        Log.i((String)TAG, (String)"Refreshing controllers.");
        this.serviceBridge.unregisterListener();
        this.serviceBridge.clearControllers();
    }

    private ControllerHolder createAndConnectControllerHolder(int controllerId) throws RemoteException {
        if (this.connectionState != 0) {
            Log.e((String)TAG, (String)new StringBuilder(63).append("Failed to connect controller ").append(controllerId).append(", service in bad state.").toString());
            return null;
        }
        ControllerHolder holder = this.getControllerHolder(controllerId);
        if (holder == null) {
            Controller c = new Controller(this, controllerId);
            holder = new ControllerHolder(c);
        }
        if (!this.serviceBridge.createAndConnectController(controllerId, (ControllerServiceBridge.Callbacks)holder)) {
            Log.e((String)TAG, (String)new StringBuilder(41).append("Failed to connect controller ").append(controllerId).append(".").toString());
            return null;
        }
        try {
            holder.currentControllerState.enableRecenterShim = VrCoreUtils.getVrCoreClientApiVersion((Context)this.context) < 8;
        }
        catch (VrCoreNotAvailableException e) {
            Log.e((String)TAG, (String)"Unable to set Controller.enableRecenterShim: ", (Throwable)e);
        }
        return holder;
    }

    private ControllerHolder getControllerHolder(int controllerId) {
        return (ControllerHolder)this.serviceBridge.getControllerCallbacks(controllerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateController(int controllerId) {
        ControllerHolder holder = this.getControllerHolder(controllerId);
        if (holder == null) {
            return;
        }
        Controller controller = holder.currentControllerState;
        synchronized (controller) {
            if (holder.controller.timestamp != holder.currentControllerState.timestamp) {
                holder.controller.setPublicState(holder.currentControllerState);
            }
        }
    }

    private class ControllerHolder
    implements ControllerServiceBridge.Callbacks {
        public final Controller controller;
        public final Controller currentControllerState;

        public ControllerHolder(Controller controller) {
            this.controller = controller;
            this.currentControllerState = new Controller(null, -1);
        }

        public void onServiceConnected(int flags) {
            if (ControllerManager.this.connectionState != 0) {
                ControllerManager.this.connectionState = 0;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
            }
        }

        public void onServiceDisconnected() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceDisconnected");
            if (ControllerManager.this.connectionState != 3) {
                ControllerManager.this.connectionState = 3;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onServiceUnavailable() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceUnavailable");
            if (ControllerManager.this.connectionState != 6) {
                ControllerManager.this.connectionState = 6;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onServiceFailed() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceFailed");
            if (ControllerManager.this.connectionState != 6) {
                ControllerManager.this.connectionState = 6;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onServiceInitFailed(int initResult) {
            int connectionState;
            switch (initResult) {
                case 1: {
                    connectionState = 1;
                    break;
                }
                case 2: {
                    connectionState = 2;
                    break;
                }
                case 3: {
                    connectionState = 5;
                    break;
                }
                default: {
                    connectionState = 5;
                }
            }
            if (connectionState != ControllerManager.this.connectionState) {
                ControllerManager.this.connectionState = connectionState;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onControllerStateChanged(int controllerId, int newState) {
            ControllerHolder holder = ControllerManager.this.getControllerHolder(controllerId);
            if (holder == null || holder.controller == null) {
                Log.e((String)ControllerManager.TAG, (String)String.format("Controller is never created correctly: %d new state: %d", controllerId, newState));
                return;
            }
            holder.controller.notifyConnectionStateChange(newState);
        }

        public void onControllerEventPacket(ControllerEventPacket eventPacket) {
            this.handleEventsBackwardCompatible(eventPacket);
        }

        public void onControllerRecentered(ControllerOrientationEvent orientationEvent) {
            this.handleOrientationEvent(orientationEvent);
            ControllerManager.this.serviceEventListener.onRecentered();
        }

        public void onControllerEventPacket2(ControllerEventPacket2 eventPacket) {
            this.handleEventsBackwardCompatible((ControllerEventPacket)eventPacket);
            for (int i = 0; i < eventPacket.getPositionEventCount(); ++i) {
                this.handlePositionEvent(eventPacket.getPositionEvent(i));
            }
            if (eventPacket.hasBatteryEvent()) {
                this.handleBatteryEvent(eventPacket.getBatteryEvent());
            }
        }

        private void handleEventsBackwardCompatible(ControllerEventPacket eventPacket) {
            int i;
            for (i = 0; i < eventPacket.getButtonEventCount(); ++i) {
                this.handleButtonEvent(eventPacket.getButtonEvent(i));
            }
            for (i = 0; i < eventPacket.getOrientationEventCount(); ++i) {
                this.handleOrientationEvent(eventPacket.getOrientationEvent(i));
            }
            for (i = 0; i < eventPacket.getTouchEventCount(); ++i) {
                this.handleTouchEvent(eventPacket.getTouchEvent(i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTouchEvent(ControllerTouchEvent event) {
            Controller controller = this.currentControllerState;
            synchronized (controller) {
                this.currentControllerState.timestamp = event.timestampNanos;
                this.currentControllerState.touch.x = event.x;
                this.currentControllerState.touch.y = event.y;
                switch (event.action) {
                    case 1: 
                    case 2: {
                        this.currentControllerState.isTouching = true;
                        break;
                    }
                    case 0: 
                    case 3: 
                    case 4: {
                        this.currentControllerState.isTouching = false;
                        break;
                    }
                    default: {
                        Log.w((String)ControllerManager.TAG, (String)String.format(".handleTouchEvent didn't handle %d", event.action));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOrientationEvent(ControllerOrientationEvent event) {
            Controller controller = this.currentControllerState;
            synchronized (controller) {
                this.currentControllerState.timestamp = event.timestampNanos;
                this.currentControllerState.setOrientationInSensorSpace(event.qx, event.qy, event.qz, event.qw);
                this.controller.notifyUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleButtonEvent(ControllerButtonEvent event) {
            Controller controller = this.currentControllerState;
            synchronized (controller) {
                this.currentControllerState.timestamp = event.timestampNanos;
                switch (event.button) {
                    case 3: {
                        this.currentControllerState.appButtonState = event.down;
                        break;
                    }
                    case 1: {
                        this.currentControllerState.clickButtonState = event.down;
                        break;
                    }
                    case 2: {
                        if (!this.currentControllerState.setHomeButtonState(event.down)) break;
                        ControllerManager.this.serviceEventListener.onRecentered();
                        break;
                    }
                    case 5: {
                        this.currentControllerState.volumeUpButtonState = event.down;
                        break;
                    }
                    case 6: {
                        this.currentControllerState.volumeDownButtonState = event.down;
                        break;
                    }
                    default: {
                        Log.w((String)ControllerManager.TAG, (String)String.format("onControllerButtonEvent didn't handle %d", event.button));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handlePositionEvent(ControllerPositionEvent event) {
            Controller controller = this.currentControllerState;
            synchronized (controller) {
                this.currentControllerState.timestamp = event.timestampNanos;
                this.currentControllerState.position[0] = event.x;
                this.currentControllerState.position[1] = event.y;
                this.currentControllerState.position[2] = event.z;
                this.controller.notifyUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleBatteryEvent(ControllerBatteryEvent event) {
            Controller controller = this.currentControllerState;
            synchronized (controller) {
                this.currentControllerState.isCharging = event.charging;
                switch (event.batteryLevelBucket) {
                    case 0: {
                        this.currentControllerState.batteryLevelBucket = 0;
                        break;
                    }
                    case 1: {
                        this.currentControllerState.batteryLevelBucket = 1;
                        break;
                    }
                    case 2: {
                        this.currentControllerState.batteryLevelBucket = 2;
                        break;
                    }
                    case 3: {
                        this.currentControllerState.batteryLevelBucket = 3;
                        break;
                    }
                    case 4: {
                        this.currentControllerState.batteryLevelBucket = 4;
                        break;
                    }
                    case 5: {
                        this.currentControllerState.batteryLevelBucket = 5;
                        break;
                    }
                    default: {
                        this.currentControllerState.batteryLevelBucket = 0;
                    }
                }
                this.controller.notifyUpdate();
            }
        }
    }

    public static class ApiStatus {
        public static final int OK = 0;
        public static final int ERROR_UNSUPPORTED = 1;
        public static final int ERROR_NOT_AUTHORIZED = 2;
        public static final int ERROR_UNAVAILABLE = 3;
        public static final int ERROR_SERVICE_OBSOLETE = 4;
        public static final int ERROR_CLIENT_OBSOLETE = 5;
        public static final int ERROR_MALFUNCTION = 6;

        private ApiStatus() {
        }

        public static final String toString(int state) {
            switch (state) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "ERROR_UNSUPPORTED";
                }
                case 2: {
                    return "ERROR_NOT_AUTHORIZED";
                }
                case 3: {
                    return "ERROR_UNAVAILABLE";
                }
                case 4: {
                    return "ERROR_SERVICE_OBSOLETE";
                }
                case 5: {
                    return "ERROR_CLIENT_OBSOLETE";
                }
                case 6: {
                    return "ERROR_MALFUNCTION";
                }
            }
            return new StringBuilder(58).append("[UNKNOWN CONTROLLER MANAGER CONNECTION STATE: ").append(state).append("]").toString();
        }
    }

    public static interface EventListener {
        public void onApiStatusChanged(int var1);

        public void onRecentered();
    }
}

