/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.google.vr.sdk.controller.Controller;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.controller.api.ControllerAccelEvent;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerGyroEvent;
import com.google.vr.vrcore.controller.api.ControllerListenerOptions;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import com.google.vr.vrcore.controller.api.ControllerStates;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;
import com.google.vr.vrcore.controller.api.IControllerListener;
import com.google.vr.vrcore.controller.api.IControllerService;
import java.lang.ref.WeakReference;

public class ControllerManager {
    static final String TAG = "ControllerManager";
    private static final boolean DEBUG = false;
    public static final int SERVICE_TARGET_API_VERSION = 12;
    private static final String LISTENER_KEY = "com.google.vr.cardboard.controller.ControllerManager";
    private final Intent bindIntent;
    private final EventListener serviceEventListener;
    private final Context context;
    private IControllerService controllerService;
    private final InnerControllerListener innerControllerListener = new InnerControllerListener();
    private final OuterControllerListener outerControllerListener = new OuterControllerListener(this.innerControllerListener);
    private final Controller currentControllerState = new Controller(null);
    private final Controller controller = new Controller(this);
    private final ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder binder) {
            ControllerManager.this.controllerService = IControllerService.Stub.asInterface((IBinder)binder);
            try {
                int connectionState;
                int initResult = ControllerManager.this.controllerService.initialize(12);
                switch (initResult) {
                    case 0: {
                        connectionState = 0;
                        break;
                    }
                    case 1: {
                        connectionState = 1;
                        break;
                    }
                    case 2: {
                        connectionState = 2;
                        break;
                    }
                    case 3: {
                        connectionState = 5;
                        break;
                    }
                    default: {
                        connectionState = 5;
                    }
                }
                if (connectionState == 0) {
                    ControllerManager.this.controllerService.registerListener(0, ControllerManager.LISTENER_KEY, (IControllerListener)ControllerManager.this.outerControllerListener);
                } else {
                    Log.e((String)ControllerManager.TAG, (String)String.format(".onServiceConnected %d, %d", initResult, connectionState));
                }
                try {
                    ((ControllerManager)ControllerManager.this).currentControllerState.enableRecenterShim = VrCoreUtils.getVrCoreClientApiVersion((Context)ControllerManager.this.context) < 8;
                }
                catch (VrCoreNotAvailableException e) {
                    Log.e((String)ControllerManager.TAG, (String)"Unable to set Controller.enableRecenterShim: ", (Throwable)e);
                }
                ControllerManager.this.serviceEventListener.onApiStatusChanged(connectionState);
            }
            catch (RemoteException e) {
                Log.e((String)ControllerManager.TAG, (String)"Initialization failed: ", (Throwable)e);
                ControllerManager.this.serviceEventListener.onApiStatusChanged(3);
                ControllerManager.this.stop();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.e((String)ControllerManager.TAG, (String)".onServiceDisconnected");
            ControllerManager.this.controllerService = null;
            ControllerManager.this.serviceEventListener.onApiStatusChanged(3);
        }
    };

    public ControllerManager(Context context, EventListener listener) {
        this.context = context;
        this.serviceEventListener = listener;
        this.bindIntent = new Intent("com.google.vr.vrcore.controller.BIND");
        this.bindIntent.setPackage("com.google.vr.vrcore");
    }

    public void start() {
        if (this.controllerService != null) {
            return;
        }
        if (!this.context.bindService(this.bindIntent, this.serviceConnection, 1)) {
            this.serviceEventListener.onApiStatusChanged(3);
        }
    }

    public void stop() {
        if (this.controllerService == null) {
            return;
        }
        try {
            this.controllerService.unregisterListener(LISTENER_KEY);
        }
        catch (RemoteException e) {
            String string = String.valueOf((Object)e);
            Log.w((String)TAG, (String)new StringBuilder(27 + String.valueOf(string).length()).append("unregisterListener failed: ").append(string).toString());
        }
        this.context.unbindService(this.serviceConnection);
        this.controllerService = null;
    }

    public Controller getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateController(Controller controller) {
        Controller controller2 = this.currentControllerState;
        synchronized (controller2) {
            if (controller.timestamp != this.currentControllerState.timestamp) {
                controller.setPublicState(this.currentControllerState);
            }
        }
    }

    private class InnerControllerListener {
        private InnerControllerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTouchEvent(ControllerTouchEvent event) {
            Controller controller = ControllerManager.this.currentControllerState;
            synchronized (controller) {
                ((ControllerManager)ControllerManager.this).currentControllerState.timestamp = event.timestampNanos;
                ((ControllerManager)ControllerManager.this).currentControllerState.touch.x = event.x;
                ((ControllerManager)ControllerManager.this).currentControllerState.touch.y = event.y;
                switch (event.action) {
                    case 1: 
                    case 2: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.isTouching = true;
                        break;
                    }
                    case 0: 
                    case 3: 
                    case 4: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.isTouching = false;
                        break;
                    }
                    default: {
                        Log.w((String)ControllerManager.TAG, (String)String.format(".handleTouchEvent didn't handle %d", event.action));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleOrientationEvent(ControllerOrientationEvent event) {
            Controller controller = ControllerManager.this.currentControllerState;
            synchronized (controller) {
                ((ControllerManager)ControllerManager.this).currentControllerState.timestamp = event.timestampNanos;
                ControllerManager.this.currentControllerState.setOrientationInSensorSpace(event.qx, event.qy, event.qz, event.qw);
                ControllerManager.this.controller.notifyUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleButtonEvent(ControllerButtonEvent event) {
            Controller controller = ControllerManager.this.currentControllerState;
            synchronized (controller) {
                ((ControllerManager)ControllerManager.this).currentControllerState.timestamp = event.timestampNanos;
                switch (event.button) {
                    case 3: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.appButtonState = event.down;
                        break;
                    }
                    case 1: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.clickButtonState = event.down;
                        break;
                    }
                    case 2: {
                        if (!ControllerManager.this.currentControllerState.setHomeButtonState(event.down)) break;
                        ControllerManager.this.serviceEventListener.onRecentered();
                        break;
                    }
                    case 5: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.volumeUpButtonState = event.down;
                        break;
                    }
                    case 6: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.volumeDownButtonState = event.down;
                        break;
                    }
                    default: {
                        Log.w((String)ControllerManager.TAG, (String)String.format("onControllerButtonEvent didn't handle %d", event.button));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePositionEvent(ControllerPositionEvent event) {
            Controller controller = ControllerManager.this.currentControllerState;
            synchronized (controller) {
                ((ControllerManager)ControllerManager.this).currentControllerState.timestamp = event.timestampNanos;
                ((ControllerManager)ControllerManager.this).currentControllerState.position[0] = event.x;
                ((ControllerManager)ControllerManager.this).currentControllerState.position[1] = event.y;
                ((ControllerManager)ControllerManager.this).currentControllerState.position[2] = event.z;
                ControllerManager.this.controller.notifyUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleBatteryEvent(ControllerBatteryEvent event) {
            Controller controller = ControllerManager.this.currentControllerState;
            synchronized (controller) {
                ((ControllerManager)ControllerManager.this).currentControllerState.isCharging = event.charging;
                switch (event.batteryLevelBucket) {
                    case 0: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 0;
                        break;
                    }
                    case 1: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 1;
                        break;
                    }
                    case 2: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 2;
                        break;
                    }
                    case 3: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 3;
                        break;
                    }
                    case 4: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 4;
                        break;
                    }
                    case 5: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 5;
                        break;
                    }
                    default: {
                        ((ControllerManager)ControllerManager.this).currentControllerState.batteryLevelBucket = 0;
                    }
                }
                ControllerManager.this.controller.notifyUpdate();
            }
        }

        public void onControllerRecentered(ControllerOrientationEvent event) {
            this.handleOrientationEvent(event);
            ControllerManager.this.serviceEventListener.onRecentered();
        }

        public void notifyConnectionStateChange(int newState) {
            ControllerManager.this.controller.notifyConnectionStateChange(newState);
        }
    }

    static class OuterControllerListener
    extends IControllerListener.Stub {
        private final WeakReference<InnerControllerListener> inner;

        public OuterControllerListener(InnerControllerListener inner) {
            this.inner = new WeakReference<InnerControllerListener>(inner);
        }

        public int getApiVersion() throws RemoteException {
            return 12;
        }

        public ControllerListenerOptions getOptions() throws RemoteException {
            return null;
        }

        public void onControllerStateChanged(int controllerId, int newState) throws RemoteException {
            String stateString = ControllerStates.toString((int)newState);
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            innerCopy.notifyConnectionStateChange(newState);
        }

        public void onControllerEventPacket2(ControllerEventPacket2 eventPacket) throws RemoteException {
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            this.logIfControllerPacketLags(eventPacket);
            this.handleEventsBackwardCompatible((ControllerEventPacket)eventPacket, innerCopy);
            for (int i = 0; i < eventPacket.getPositionEventCount(); ++i) {
                innerCopy.handlePositionEvent(eventPacket.getPositionEvent(i));
            }
            if (eventPacket.hasBatteryEvent()) {
                innerCopy.handleBatteryEvent(eventPacket.getBatteryEvent());
            }
            eventPacket.recycle();
        }

        public void onControllerEventPacket(ControllerEventPacket eventPacket) throws RemoteException {
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            this.handleEventsBackwardCompatible(eventPacket, innerCopy);
            eventPacket.recycle();
        }

        private void logIfControllerPacketLags(ControllerEventPacket2 eventPacket) {
            if (eventPacket.getTimestampMillis() == 0L) {
                return;
            }
            long timestampDiffMs = SystemClock.elapsedRealtime() - eventPacket.getTimestampMillis();
            if (timestampDiffMs > 300L) {
                Log.w((String)ControllerManager.TAG, (String)new StringBuilder(122).append("Experiencing large controller packet delivery time between service and  client: timestamp diff in ms: ").append(timestampDiffMs).toString());
            }
        }

        private void handleEventsBackwardCompatible(ControllerEventPacket eventPacket, InnerControllerListener innerCopy) {
            int i;
            for (i = 0; i < eventPacket.getButtonEventCount(); ++i) {
                innerCopy.handleButtonEvent(eventPacket.getButtonEvent(i));
            }
            for (i = 0; i < eventPacket.getOrientationEventCount(); ++i) {
                innerCopy.handleOrientationEvent(eventPacket.getOrientationEvent(i));
            }
            for (i = 0; i < eventPacket.getTouchEventCount(); ++i) {
                innerCopy.handleTouchEvent(eventPacket.getTouchEvent(i));
            }
        }

        public void onControllerRecentered(ControllerOrientationEvent event) {
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            innerCopy.onControllerRecentered(event);
        }

        public boolean deprecatedOnControllerButtonEventV1(ControllerButtonEvent event) {
            return true;
        }

        public void deprecatedOnControllerAccelEvent(ControllerAccelEvent event) {
        }

        public void deprecatedOnControllerButtonEvent(ControllerButtonEvent event) {
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            innerCopy.handleButtonEvent(event);
        }

        public void deprecatedOnControllerGyroEvent(ControllerGyroEvent event) {
        }

        public void deprecatedOnControllerOrientationEvent(ControllerOrientationEvent event) {
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            innerCopy.handleOrientationEvent(event);
        }

        public void deprecatedOnControllerTouchEvent(ControllerTouchEvent event) {
            InnerControllerListener innerCopy = (InnerControllerListener)this.inner.get();
            if (innerCopy == null) {
                return;
            }
            innerCopy.handleTouchEvent(event);
        }
    }

    public static class ApiStatus {
        public static final int OK = 0;
        public static final int ERROR_UNSUPPORTED = 1;
        public static final int ERROR_NOT_AUTHORIZED = 2;
        public static final int ERROR_UNAVAILABLE = 3;
        public static final int ERROR_SERVICE_OBSOLETE = 4;
        public static final int ERROR_CLIENT_OBSOLETE = 5;
        public static final int ERROR_MALFUNCTION = 6;

        private ApiStatus() {
        }

        public static final String toString(int state) {
            switch (state) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "ERROR_UNSUPPORTED";
                }
                case 2: {
                    return "ERROR_NOT_AUTHORIZED";
                }
                case 3: {
                    return "ERROR_UNAVAILABLE";
                }
                case 4: {
                    return "ERROR_SERVICE_OBSOLETE";
                }
                case 5: {
                    return "ERROR_CLIENT_OBSOLETE";
                }
                case 6: {
                    return "ERROR_MALFUNCTION";
                }
            }
            return new StringBuilder(58).append("[UNKNOWN CONTROLLER MANAGER CONNECTION STATE: ").append(state).append("]").toString();
        }
    }

    public static interface EventListener {
        public void onApiStatusChanged(int var1);

        public void onRecentered();
    }
}

