/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import java.util.Locale;

public class Orientation {
    public float x;
    public float y;
    public float z;
    public float w;

    Orientation() {
        this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    Orientation(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    void set(Orientation o) {
        this.set(o.x, o.y, o.z, o.w);
    }

    public String toString() {
        return String.format(Locale.US, "%5.2fi %5.2fj %5.2fk %5.2f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }

    public String toAxisAngleString() {
        float ang = (float)Math.toDegrees(2.0 * Math.acos(this.w));
        float sqrt = (float)Math.sqrt(1.0f - this.w * this.w);
        float vecX = sqrt > 0.0f ? this.x / sqrt : 0.0f;
        float vecY = sqrt > 0.0f ? this.y / sqrt : 0.0f;
        float vecZ = sqrt > 0.0f ? this.z / sqrt : 0.0f;
        return String.format(Locale.US, "(%5.2f, %5.2f, %5.2f), %3.0f\u00b0", Float.valueOf(vecX), Float.valueOf(vecY), Float.valueOf(vecZ), Float.valueOf(ang));
    }

    void multiply(Orientation o) {
        float x0 = this.x;
        float y0 = this.y;
        float z0 = this.z;
        float w0 = this.w;
        this.x = o.w * x0 + o.x * w0 + o.z * y0 - o.y * z0;
        this.y = o.w * y0 + o.y * w0 + o.x * z0 - o.z * x0;
        this.z = o.w * z0 + o.z * w0 + o.y * x0 - o.x * y0;
        this.w = o.w * w0 - o.x * x0 - o.y * y0 - o.z * z0;
    }

    float[] toEulerAngles(float[] angles) {
        float test = this.z * this.y + this.x * this.w;
        if (Math.abs(test) < 0.4999f) {
            angles[0] = (float)Math.asin(2.0f * test);
            angles[1] = (float)Math.atan2(2.0f * this.y * this.w - 2.0f * this.z * this.x, 1.0f - 2.0f * this.y * this.y - 2.0f * this.x * this.x);
            angles[2] = (float)Math.atan2(2.0f * this.z * this.w - 2.0f * this.y * this.x, 1.0f - 2.0f * this.z * this.z - 2.0f * this.x * this.x);
        } else {
            angles[0] = (float)Math.copySign(1.5707963267948966, (double)test);
            angles[1] = (float)((double)Math.copySign(2.0f, test) * Math.atan2(this.z, this.w));
            angles[2] = 0.0f;
        }
        return angles;
    }

    public float[] toRotationMatrix(float[] output) {
        output[0] = 1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z;
        output[1] = 2.0f * this.x * this.y + 2.0f * this.z * this.w;
        output[2] = 2.0f * this.x * this.z - 2.0f * this.y * this.w;
        output[3] = 0.0f;
        output[4] = 2.0f * this.x * this.y - 2.0f * this.z * this.w;
        output[5] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z;
        output[6] = 2.0f * this.y * this.z + 2.0f * this.x * this.w;
        output[7] = 0.0f;
        output[8] = 2.0f * this.x * this.z + 2.0f * this.y * this.w;
        output[9] = 2.0f * this.y * this.z - 2.0f * this.x * this.w;
        output[10] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y;
        output[11] = 0.0f;
        output[12] = 0.0f;
        output[13] = 0.0f;
        output[14] = 0.0f;
        output[15] = 1.0f;
        return output;
    }
}

