/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.sdk.controller.Controller;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerServiceBridge;

public class ControllerManager {
    static final String TAG = "ControllerManager";
    private static final boolean DEBUG = false;
    private final ControllerServiceBridge serviceBridge;
    private final EventListener serviceEventListener;
    private int connectionState = 3;

    public ControllerManager(Context context, EventListener listener) {
        this.serviceEventListener = listener;
        ControllerHolder defaultHolder = new ControllerHolder(new Controller(0));
        this.serviceBridge = new ControllerServiceBridge(context, (ControllerServiceBridge.Callbacks)defaultHolder);
    }

    public void start() {
        this.serviceBridge.doBind();
    }

    public void stop() {
        this.serviceBridge.doUnbind();
    }

    public Controller getController() {
        return this.getController(0);
    }

    public Controller getController(int controllerId) {
        ControllerHolder holder = this.getControllerHolder(controllerId);
        if (holder == null) {
            try {
                holder = this.createAndConnectControllerHolder(controllerId);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Exception from service while connecting controller: ", (Throwable)e);
                return null;
            }
        }
        return holder == null ? null : holder.controller;
    }

    public void refreshAllControllers() {
        Log.i((String)TAG, (String)"Refreshing controllers.");
        this.serviceBridge.unregisterListeners();
        this.serviceBridge.clearControllers();
    }

    private ControllerHolder createAndConnectControllerHolder(int controllerId) throws RemoteException {
        if (this.connectionState != 0) {
            Log.e((String)TAG, (String)new StringBuilder(63).append("Failed to connect controller ").append(controllerId).append(", service in bad state.").toString());
            return null;
        }
        ControllerHolder holder = new ControllerHolder(new Controller(controllerId));
        if (!this.serviceBridge.createAndConnectController(controllerId, (ControllerServiceBridge.Callbacks)holder)) {
            Log.e((String)TAG, (String)new StringBuilder(41).append("Failed to connect controller ").append(controllerId).append(".").toString());
            return null;
        }
        return holder;
    }

    private ControllerHolder getControllerHolder(int controllerId) {
        return (ControllerHolder)this.serviceBridge.getControllerCallbacks(controllerId);
    }

    private class ControllerHolder
    implements ControllerServiceBridge.Callbacks {
        public final Controller controller;

        public ControllerHolder(Controller controller) {
            this.controller = controller;
        }

        public void onServiceConnected(int flags) {
            if (ControllerManager.this.connectionState != 0) {
                ControllerManager.this.connectionState = 0;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
            }
        }

        public void onServiceDisconnected() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceDisconnected");
            if (ControllerManager.this.connectionState != 3) {
                ControllerManager.this.connectionState = 3;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onServiceUnavailable() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceUnavailable");
            if (ControllerManager.this.connectionState != 6) {
                ControllerManager.this.connectionState = 6;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onServiceFailed() {
            Log.e((String)ControllerManager.TAG, (String)".onServiceFailed");
            if (ControllerManager.this.connectionState != 6) {
                ControllerManager.this.connectionState = 6;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(ControllerManager.this.connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onServiceInitFailed(int initResult) {
            int connectionState;
            switch (initResult) {
                case 1: {
                    connectionState = 1;
                    break;
                }
                case 2: {
                    connectionState = 2;
                    break;
                }
                case 3: {
                    connectionState = 5;
                    break;
                }
                default: {
                    connectionState = 5;
                }
            }
            if (connectionState != ControllerManager.this.connectionState) {
                ControllerManager.this.connectionState = connectionState;
                ControllerManager.this.serviceEventListener.onApiStatusChanged(connectionState);
                ControllerManager.this.stop();
            }
        }

        public void onControllerStateChanged(int controllerIndex, int newState) {
            this.controller.notifyConnectionStateChange(newState);
        }

        public void onControllerEventPacket(ControllerEventPacket eventPacket) {
            this.handleEventsBackwardCompatible(eventPacket);
        }

        public void onControllerRecentered(ControllerOrientationEvent orientationEvent) {
            this.controller.notifyOrientationEvent(orientationEvent);
            ControllerManager.this.serviceEventListener.onRecentered();
        }

        public void onControllerEventPacket2(ControllerEventPacket2 eventPacket) {
            this.handleEventsBackwardCompatible((ControllerEventPacket)eventPacket);
            for (int i = 0; i < eventPacket.getPositionEventCount(); ++i) {
                this.controller.notifyPositionEvent(eventPacket.getPositionEvent(i));
            }
            if (eventPacket.hasBatteryEvent()) {
                this.controller.notifyBatteryEvent(eventPacket.getBatteryEvent());
            }
        }

        private void handleEventsBackwardCompatible(ControllerEventPacket eventPacket) {
            int i;
            for (i = 0; i < eventPacket.getButtonEventCount(); ++i) {
                this.controller.notifyButtonEvent(eventPacket.getButtonEvent(i));
            }
            for (i = 0; i < eventPacket.getOrientationEventCount(); ++i) {
                this.controller.notifyOrientationEvent(eventPacket.getOrientationEvent(i));
            }
            for (i = 0; i < eventPacket.getTouchEventCount(); ++i) {
                this.controller.notifyTouchEvent(eventPacket.getTouchEvent(i));
            }
        }
    }

    public static class ApiStatus {
        public static final int OK = 0;
        public static final int ERROR_UNSUPPORTED = 1;
        public static final int ERROR_NOT_AUTHORIZED = 2;
        public static final int ERROR_UNAVAILABLE = 3;
        public static final int ERROR_SERVICE_OBSOLETE = 4;
        public static final int ERROR_CLIENT_OBSOLETE = 5;
        public static final int ERROR_MALFUNCTION = 6;

        private ApiStatus() {
        }

        public static final String toString(int state) {
            switch (state) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "ERROR_UNSUPPORTED";
                }
                case 2: {
                    return "ERROR_NOT_AUTHORIZED";
                }
                case 3: {
                    return "ERROR_UNAVAILABLE";
                }
                case 4: {
                    return "ERROR_SERVICE_OBSOLETE";
                }
                case 5: {
                    return "ERROR_CLIENT_OBSOLETE";
                }
                case 6: {
                    return "ERROR_MALFUNCTION";
                }
            }
            return new StringBuilder(58).append("[UNKNOWN CONTROLLER MANAGER CONNECTION STATE: ").append(state).append("]").toString();
        }
    }

    public static interface EventListener {
        public void onApiStatusChanged(int var1);

        public void onRecentered();
    }
}

