/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IgnoreFailuresFailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import java.util.OptionalDouble;
import javax.annotation.Nullable;

public final class OptionalDoubleSubject
extends Subject<OptionalDoubleSubject, OptionalDouble> {
    private static final SubjectFactory<OptionalDoubleSubject, OptionalDouble> FACTORY = new SubjectFactory<OptionalDoubleSubject, OptionalDouble>(){

        public OptionalDoubleSubject getSubject(FailureStrategy fs, OptionalDouble target) {
            return new OptionalDoubleSubject(fs, target);
        }
    };

    OptionalDoubleSubject(FailureStrategy failureStrategy, @Nullable OptionalDouble subject) {
        super(failureStrategy, (Object)subject);
    }

    public void isPresent() {
        if (this.actual() == null || !((OptionalDouble)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((OptionalDouble)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(double expected) {
        if (this.actual() == null || !((OptionalDouble)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            double actual = ((OptionalDouble)this.actual()).getAsDouble();
            if (actual != expected) {
                this.fail("has value", expected);
            }
        }
    }

    public DoubleSubject hasValueThat() {
        if (this.actual() == null || !((OptionalDouble)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
            return new DoubleSubject((FailureStrategy)IgnoreFailuresFailureStrategy.INSTANCE, Double.valueOf(0.0));
        }
        return new DoubleSubject(this.failureStrategy, Double.valueOf(((OptionalDouble)this.actual()).getAsDouble()));
    }

    public static SubjectFactory<OptionalDoubleSubject, OptionalDouble> optionalDoubles() {
        return FACTORY;
    }
}

