/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.driver;

import com.google.testing.platform.lib.adb.command.instrument.AmInstrumentationArgs;
import com.google.testing.platform.lib.adb.command.instrument.AmInstrumentationArgsKt;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.config.AndroidInstrumentationDriverProto;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 ,2\u00020\u0001:\u0001,B\u008d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001dR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001dR\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/google/testing/platform/runtime/android/driver/AndroidInstrumentationArgs;", "Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationArgs;", "instrumentationRunnerClass", "", "noHiddenApiChecks", "", "noWindowAnimation", "rawOutput", "waitsForInstrumentation", "additionalOptions", "", "androidTestPackage", "testClasses", "", "enableDebugging", "coverageReportPath", "instrumentCommandTimeout", "Ljava/time/Duration;", "useOrchestrator", "useTestStorageService", "shellExecutionOption", "Lcom/google/testing/platform/proto/api/config/AndroidInstrumentationDriverProto$AndroidInstrumentationDriver$ShellExecutionOption;", "(Ljava/lang/String;ZZZZLjava/util/Map;Ljava/lang/String;Ljava/util/List;ZLjava/lang/String;Ljava/time/Duration;ZZLcom/google/testing/platform/proto/api/config/AndroidInstrumentationDriverProto$AndroidInstrumentationDriver$ShellExecutionOption;)V", "getAdditionalOptions", "()Ljava/util/Map;", "getAndroidTestPackage", "()Ljava/lang/String;", "getCoverageReportPath", "getEnableDebugging", "()Z", "getInstrumentCommandTimeout", "()Ljava/time/Duration;", "getInstrumentationRunnerClass", "getNoHiddenApiChecks", "getNoWindowAnimation", "getRawOutput", "getShellExecutionOption", "()Lcom/google/testing/platform/proto/api/config/AndroidInstrumentationDriverProto$AndroidInstrumentationDriver$ShellExecutionOption;", "getTestClasses", "()Ljava/util/List;", "getUseOrchestrator", "getUseTestStorageService", "getWaitsForInstrumentation", "toArgs", "Companion", "java_com_google_testing_platform_runtime_android_driver-orchestrator_v1_instrumentation_args"})
public final class AndroidInstrumentationArgs
implements AmInstrumentationArgs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String instrumentationRunnerClass;
    private final boolean noHiddenApiChecks;
    private final boolean noWindowAnimation;
    private final boolean rawOutput;
    private final boolean waitsForInstrumentation;
    @NotNull
    private final Map<String, String> additionalOptions;
    @NotNull
    private final String androidTestPackage;
    @NotNull
    private final List<String> testClasses;
    private final boolean enableDebugging;
    @Nullable
    private final String coverageReportPath;
    @NotNull
    private final Duration instrumentCommandTimeout;
    private final boolean useOrchestrator;
    private final boolean useTestStorageService;
    @NotNull
    private final AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);
    @NotNull
    private static final String orchestratorBaseInstrumentation = "androidx.test.orchestrator/androidx.test.orchestrator.AndroidTestOrchestrator";

    public AndroidInstrumentationArgs(@NotNull String instrumentationRunnerClass, boolean noHiddenApiChecks, boolean noWindowAnimation, boolean rawOutput, boolean waitsForInstrumentation, @NotNull Map<String, String> additionalOptions, @NotNull String androidTestPackage, @NotNull List<String> testClasses, boolean enableDebugging, @Nullable String coverageReportPath, @NotNull Duration instrumentCommandTimeout, boolean useOrchestrator, boolean useTestStorageService, @NotNull AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption) {
        Intrinsics.checkNotNullParameter((Object)instrumentationRunnerClass, (String)"instrumentationRunnerClass");
        Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
        Intrinsics.checkNotNullParameter((Object)androidTestPackage, (String)"androidTestPackage");
        Intrinsics.checkNotNullParameter(testClasses, (String)"testClasses");
        Intrinsics.checkNotNullParameter((Object)instrumentCommandTimeout, (String)"instrumentCommandTimeout");
        Intrinsics.checkNotNullParameter((Object)((Object)shellExecutionOption), (String)"shellExecutionOption");
        this.instrumentationRunnerClass = instrumentationRunnerClass;
        this.noHiddenApiChecks = noHiddenApiChecks;
        this.noWindowAnimation = noWindowAnimation;
        this.rawOutput = rawOutput;
        this.waitsForInstrumentation = waitsForInstrumentation;
        this.additionalOptions = additionalOptions;
        this.androidTestPackage = androidTestPackage;
        this.testClasses = testClasses;
        this.enableDebugging = enableDebugging;
        this.coverageReportPath = coverageReportPath;
        this.instrumentCommandTimeout = instrumentCommandTimeout;
        this.useOrchestrator = useOrchestrator;
        this.useTestStorageService = useTestStorageService;
        this.shellExecutionOption = shellExecutionOption;
    }

    public /* synthetic */ AndroidInstrumentationArgs(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map, String string2, List list, boolean bl5, String string3, Duration duration, boolean bl6, boolean bl7, AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x1000) != 0) {
            bl7 = false;
        }
        this(string, bl, bl2, bl3, bl4, map, string2, list, bl5, string3, duration, bl6, bl7, shellExecutionOption);
    }

    @Override
    @NotNull
    public String getInstrumentationRunnerClass() {
        return this.instrumentationRunnerClass;
    }

    @Override
    public boolean getNoHiddenApiChecks() {
        return this.noHiddenApiChecks;
    }

    @Override
    public boolean getNoWindowAnimation() {
        return this.noWindowAnimation;
    }

    @Override
    public boolean getRawOutput() {
        return this.rawOutput;
    }

    @Override
    public boolean getWaitsForInstrumentation() {
        return this.waitsForInstrumentation;
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    @NotNull
    public final String getAndroidTestPackage() {
        return this.androidTestPackage;
    }

    @NotNull
    public final List<String> getTestClasses() {
        return this.testClasses;
    }

    public final boolean getEnableDebugging() {
        return this.enableDebugging;
    }

    @Nullable
    public final String getCoverageReportPath() {
        return this.coverageReportPath;
    }

    @NotNull
    public final Duration getInstrumentCommandTimeout() {
        return this.instrumentCommandTimeout;
    }

    public final boolean getUseOrchestrator() {
        return this.useOrchestrator;
    }

    public final boolean getUseTestStorageService() {
        return this.useTestStorageService;
    }

    @NotNull
    public final AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption getShellExecutionOption() {
        return this.shellExecutionOption;
    }

    @Override
    @NotNull
    public List<String> toArgs() {
        boolean useShellExecutorService;
        if (!(!StringsKt.isBlank((CharSequence)this.androidTestPackage))) {
            boolean $i$a$-require-AndroidInstrumentationArgs$toArgs$32 = false;
            String $i$a$-require-AndroidInstrumentationArgs$toArgs$32 = "AndroidTestPackage cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AndroidInstrumentationArgs$toArgs$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.getInstrumentationRunnerClass()))) {
            boolean $i$a$-require-AndroidInstrumentationArgs$toArgs$42 = false;
            String $i$a$-require-AndroidInstrumentationArgs$toArgs$42 = "InstrumentationRunnerClass cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AndroidInstrumentationArgs$toArgs$42.toString());
        }
        List args = new ArrayList();
        Map options = new LinkedHashMap();
        options.put("testTimeoutSeconds", String.valueOf(this.instrumentCommandTimeout.toSeconds()));
        CharSequence charSequence = this.coverageReportPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            logger.fine("Jacoco coverage report requested: [" + this.coverageReportPath + ']');
            options.put("coverage", "true");
            options.put("coverageFile", String.valueOf(this.coverageReportPath));
        }
        if (this.enableDebugging) {
            options.put("debug", "true");
        }
        Iterable $this$forEach$iv = this.testClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String className = (String)element$iv;
            boolean bl = false;
            options.put("class", className);
        }
        if (this.useOrchestrator) {
            options.put("targetInstrumentation", this.androidTestPackage + '/' + this.getInstrumentationRunnerClass());
        }
        if (this.useTestStorageService) {
            options.put("useTestStorageService", "true");
        }
        String fullInstrumentation = this.useOrchestrator ? orchestratorBaseInstrumentation : this.androidTestPackage + '/' + this.getInstrumentationRunnerClass();
        boolean bl = this.getNoHiddenApiChecks();
        boolean bl2 = this.getNoWindowAnimation();
        boolean bl3 = this.getRawOutput();
        boolean bl4 = this.getWaitsForInstrumentation();
        Map map = MapsKt.plus(this.getAdditionalOptions(), (Map)options);
        List instrumentationArgs = AmInstrumentationArgsKt.AmInstrumentationArgs(fullInstrumentation, bl, bl2, bl3, bl4, map, args).toArgs();
        boolean bl5 = useShellExecutorService = this.useOrchestrator || this.shellExecutionOption == AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption.STRICT_SHELL_EXECUTION;
        if (useShellExecutorService) {
            Object[] objectArray = new String[]{"CLASSPATH=$(pm path androidx.test.services)", "app_process / androidx.test.services.shellexecutor.ShellMain"};
            instrumentationArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)instrumentationArgs);
        }
        return instrumentationArgs;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/testing/platform/runtime/android/driver/AndroidInstrumentationArgs$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "orchestratorBaseInstrumentation", "", "java_com_google_testing_platform_runtime_android_driver-orchestrator_v1_instrumentation_args"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

