/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.controller.ext;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.device.DeviceProperties;
import com.google.testing.platform.lib.adb.command.Instrumentation;
import com.google.testing.platform.lib.adb.command.network.AdbNetworkSocket;
import com.google.testing.platform.proto.api.core.ArtifactKt;
import com.google.testing.platform.proto.api.core.PathKt;
import com.google.testing.platform.proto.api.core.PathProto;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.controller.ext.Constants;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a.\u0010\t\u001a\u00020\n*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f\u001a4\u0010\u0011\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0013\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a4\u0010\u0011\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0013\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a\u001e\u0010\u001b\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u001c\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a0\u0010\u001d\u001a\u00020\u001a*\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u001f\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a&\u0010 \u001a\u00020\u001a*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a\"\u0010 \u001a\u00020\u001a*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020!H\u0007\u001a$\u0010\"\u001a\u00020\u001a*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a$\u0010#\u001a\u00020\u001a*\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\n\u0010$\u001a\u00020\r*\u00020\b\u001a\u0014\u0010%\u001a\u0004\u0018\u00010\r*\u00020\b2\u0006\u0010&\u001a\u00020\r\u001a\u0012\u0010'\u001a\u00020\u0007*\u00020\b2\u0006\u0010&\u001a\u00020\r\u001a\f\u0010(\u001a\u0004\u0018\u00010\r*\u00020\b\u001a\n\u0010)\u001a\u00020\r*\u00020\b\u001a8\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\b2\b\b\u0002\u0010+\u001a\u00020\u00122\b\b\u0002\u0010,\u001a\u00020\u00122\b\b\u0002\u0010-\u001a\u00020\u00122\b\b\u0002\u0010.\u001a\u00020\u0012\u001a\u0014\u0010/\u001a\u0004\u0018\u00010\r*\u00020\b2\u0006\u00100\u001a\u00020\r\u001a\u001c\u00101\u001a\u00020\u001a*\u00020\b2\u0006\u00102\u001a\u0002032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u001c\u00101\u001a\u00020\u001a*\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020!H\u0007\u001a\"\u00105\u001a\u00020\u001a*\u00020\b2\f\u00106\u001a\b\u0012\u0004\u0012\u000203072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a \u00108\u001a\u00020\u0007*\u00020\b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010:\u001a\u00020\u0007\u001a\n\u0010;\u001a\u00020\u0012*\u00020\b\u001a\n\u0010<\u001a\u00020\u0012*\u00020\b\u001a\n\u0010=\u001a\u00020\u0012*\u00020\b\u001a\n\u0010>\u001a\u00020\u0012*\u00020\b\u001a\n\u0010?\u001a\u00020\u0012*\u00020\b\u001a\n\u0010@\u001a\u00020\u0012*\u00020\b\u001a\n\u0010A\u001a\u00020\u0012*\u00020\b\u001a\u0018\u0010B\u001a\b\u0012\u0004\u0012\u00020C07*\u00020\b2\u0006\u0010D\u001a\u00020\r\u001a\u0010\u0010E\u001a\b\u0012\u0004\u0012\u00020F07*\u00020\b\u001a\u0016\u0010G\u001a\u00020\u001a*\u00020\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a&\u0010H\u001a\u00020\u001a*\u00020\b2\u000e\b\u0002\u0010I\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0014\u0010J\u001a\u00020\u001a*\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010K\u001a\u00020\u0010*\u00020\b2\u0006\u0010L\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a$\u0010M\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\b2\u0006\u0010N\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u001c\u0010O\u001a\u00020\u0010*\u00020\b2\u0006\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\rH\u0002\u001a\u001c\u0010R\u001a\u00020\u0010*\u00020\b2\u0006\u0010Q\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0007H\u0002\u001a\u001c\u0010S\u001a\u00020\u001a*\u00020\b2\u0006\u0010T\u001a\u00020U2\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010V\u001a\u00020\u001a*\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010W\u001a\u00020\u0010*\u00020\b2\u0006\u0010:\u001a\u00020\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a(\u0010X\u001a\u00020\u001a*\u00020\b2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a0\u0010[\u001a\u00020\u001a*\u00020\b2\u0006\u0010T\u001a\u00020U2\u0006\u0010\\\u001a\u00020U2\b\b\u0002\u0010]\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a0\u0010^\u001a\u00020\u001a*\u00020\b2\u0006\u0010\\\u001a\u00020U2\u0006\u0010T\u001a\u00020U2\b\b\u0002\u0010]\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0014\u0010_\u001a\u00020\u0010*\u00020\b2\u0006\u0010Q\u001a\u00020\rH\u0002\u001a&\u0010`\u001a\u00020\u0012*\u00020\b2\u0006\u0010a\u001a\u00020\r2\u0006\u0010b\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a*\u0010c\u001a\u00020\u001a*\u00020\b2\u0006\u0010\u001c\u001a\u00020\r2\b\b\u0002\u0010d\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a\u0016\u0010e\u001a\u00020\u0010*\u00020\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u001c\u0010f\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010g\u001a\u00020\u0016\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006h"}, d2={"logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "logger$delegate", "Lkotlin/Lazy;", "apiLevel", "", "Lcom/google/testing/platform/api/device/DeviceController;", "asyncShell", "Lcom/google/testing/platform/api/device/CommandHandle;", "args", "", "", "processor", "Lkotlin/Function1;", "", "checkStdoutContains", "", "cmd", "keyword", "timeout", "Ljava/time/Duration;", "regex", "Lkotlin/text/Regex;", "clearLogcat", "Lcom/google/testing/platform/api/device/CommandResult;", "clearPackageData", "targetPackage", "delete", "paths", "recursivelyDelete", "deviceShell", "", "deviceShellAndLogOnFailure", "execAndLogOnFailure", "externalStorageDir", "getAppVersionCode", "packageName", "getAppVersionCodeAsInt", "getCurrentUser", "getExternalStoragePath", "getExtraInstallOptions", "replaceExistingApp", "allowTestApks", "grandRuntimePermissions", "allowVersionDowngrade", "getProperty", "key", "installAndGrantPermissions", "artifact", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "timeoutSeconds", "installMultiPackage", "artifacts", "", "installSystemApks", "systemApksToInstall", "deviceApiLevel", "isDataMounted", "isDeviceHealthy", "isPackageManagerRunning", "isRunningUnderSystemUser", "isSysBootCompletedSet", "isSystemServerRunning", "isTestServiceInstalled", "listFilesRecursively", "Ljava/nio/file/Path;", "path", "listInstrumentationToInstances", "Lcom/google/testing/platform/lib/adb/command/Instrumentation;", "listInstrumentations", "listPackages", "options", "listReverseTunnel", "makeDirectory", "absolutePath", "pids", "processName", "remount", "mountPoint", "mode", "remountSystem", "removeAdbReverseTunnel", "hostSocket", "Lcom/google/testing/platform/lib/adb/command/network/AdbNetworkSocket;", "removeAllAdbReverseTunnels", "restartSystem", "setProp", "prop", "value", "setUpAdbForward", "deviceSocket", "noRebind", "setUpAdbReverse", "shellRemountSystem", "threadDump", "appPackage", "outputFolder", "uninstall", "keepDataAndCache", "unlockScreen", "waitForDeviceHealthy", "retryInterval", "java_com_google_testing_platform_runtime_android_controller_ext-android_device_controller_ext"})
public final class AndroidDeviceControllerExtKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public static final CommandResult listInstrumentations(@NotNull DeviceController $this$listInstrumentations, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$listInstrumentations, (String)"<this>");
        Object[] objectArray = new String[]{"pm", "list", "instrumentation"};
        return AndroidDeviceControllerExtKt.deviceShell($this$listInstrumentations, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ CommandResult listInstrumentations$default(DeviceController deviceController, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.listInstrumentations(deviceController, duration);
    }

    @NotNull
    public static final Set<Instrumentation> listInstrumentationToInstances(@NotNull DeviceController $this$listInstrumentationToInstances) {
        Intrinsics.checkNotNullParameter((Object)$this$listInstrumentationToInstances, (String)"<this>");
        String instrumentationsOutput = CollectionsKt.joinToString$default((Iterable)AndroidDeviceControllerExtKt.listInstrumentations$default($this$listInstrumentationToInstances, null, 1, null).getOutput(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Set availableInstrumentations = new LinkedHashSet();
        Iterator $this$forEach$iv = Regex.findAll$default((Regex)new Regex("instrumentation:(.+?)/(.+?)\\s\\(target=(.+?)\\)"), (CharSequence)instrumentationsOutput, (int)0, (int)2, null).iterator();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            MatchResult result = (MatchResult)element$iv;
            boolean bl = false;
            availableInstrumentations.add(new Instrumentation((String)result.getGroupValues().get(3), (String)result.getGroupValues().get(1), (String)result.getGroupValues().get(2)));
        }
        return availableInstrumentations;
    }

    @Deprecated(message="Please update to using a Duration for timeout")
    @CanIgnoreReturnValue
    @NotNull
    public static final CommandResult deviceShell(@NotNull DeviceController $this$deviceShell, @NotNull List<String> args, long timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceShell, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return AndroidDeviceControllerExtKt.deviceShell($this$deviceShell, args, Duration.ofSeconds(timeout));
    }

    @CanIgnoreReturnValue
    @NotNull
    public static final CommandResult deviceShell(@NotNull DeviceController $this$deviceShell, @NotNull List<String> args, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceShell, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return $this$deviceShell.execute(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"shell"), (Iterable)args), timeout);
    }

    public static /* synthetic */ CommandResult deviceShell$default(DeviceController deviceController, List list, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.deviceShell(deviceController, (List<String>)list, duration);
    }

    @NotNull
    public static final CommandResult deviceShellAndLogOnFailure(@NotNull DeviceController $this$deviceShellAndLogOnFailure, @NotNull List<String> args, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceShellAndLogOnFailure, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return AndroidDeviceControllerExtKt.execAndLogOnFailure($this$deviceShellAndLogOnFailure, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"shell"), (Iterable)args), timeout);
    }

    public static /* synthetic */ CommandResult deviceShellAndLogOnFailure$default(DeviceController deviceController, List list, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.deviceShellAndLogOnFailure(deviceController, list, duration);
    }

    @NotNull
    public static final CommandHandle asyncShell(@NotNull DeviceController $this$asyncShell, @NotNull List<String> args, @NotNull Function1<? super String, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)$this$asyncShell, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return $this$asyncShell.executeAsync(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"shell"), (Iterable)args), processor);
    }

    public static /* synthetic */ CommandHandle asyncShell$default(DeviceController deviceController, List list, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = asyncShell.1.INSTANCE;
        }
        return AndroidDeviceControllerExtKt.asyncShell(deviceController, list, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommandResult setUpAdbReverse(@NotNull DeviceController $this$setUpAdbReverse, @NotNull AdbNetworkSocket deviceSocket, @NotNull AdbNetworkSocket hostSocket, boolean noRebind, @Nullable Duration timeout) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$setUpAdbReverse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceSocket, (String)"deviceSocket");
        Intrinsics.checkNotNullParameter((Object)hostSocket, (String)"hostSocket");
        List list2 = list = CollectionsKt.listOf((Object)"reverse");
        DeviceController deviceController = $this$setUpAdbReverse;
        boolean bl = false;
        if (noRebind) {
            void $this$setUpAdbReverse_u24lambda_u2d1;
            CollectionsKt.plus((Collection)((Collection)$this$setUpAdbReverse_u24lambda_u2d1), (Object)"--no-rebind");
        }
        return deviceController.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)list, (Object)String.valueOf(deviceSocket)), (Object)String.valueOf(hostSocket)), timeout);
    }

    public static /* synthetic */ CommandResult setUpAdbReverse$default(DeviceController deviceController, AdbNetworkSocket adbNetworkSocket, AdbNetworkSocket adbNetworkSocket2, boolean bl, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            duration = Duration.ofSeconds(120L);
        }
        return AndroidDeviceControllerExtKt.setUpAdbReverse(deviceController, adbNetworkSocket, adbNetworkSocket2, bl, duration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommandResult setUpAdbForward(@NotNull DeviceController $this$setUpAdbForward, @NotNull AdbNetworkSocket hostSocket, @NotNull AdbNetworkSocket deviceSocket, boolean noRebind, @Nullable Duration timeout) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$setUpAdbForward, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hostSocket, (String)"hostSocket");
        Intrinsics.checkNotNullParameter((Object)deviceSocket, (String)"deviceSocket");
        List list2 = list = CollectionsKt.listOf((Object)"forward");
        DeviceController deviceController = $this$setUpAdbForward;
        boolean bl = false;
        if (noRebind) {
            void $this$setUpAdbForward_u24lambda_u2d2;
            CollectionsKt.plus((Collection)((Collection)$this$setUpAdbForward_u24lambda_u2d2), (Object)"--no-rebind");
        }
        return deviceController.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)list, (Object)String.valueOf(hostSocket)), (Object)String.valueOf(deviceSocket)), timeout);
    }

    public static /* synthetic */ CommandResult setUpAdbForward$default(DeviceController deviceController, AdbNetworkSocket adbNetworkSocket, AdbNetworkSocket adbNetworkSocket2, boolean bl, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            duration = Duration.ofSeconds(120L);
        }
        return AndroidDeviceControllerExtKt.setUpAdbForward(deviceController, adbNetworkSocket, adbNetworkSocket2, bl, duration);
    }

    @NotNull
    public static final CommandResult removeAdbReverseTunnel(@NotNull DeviceController $this$removeAdbReverseTunnel, @NotNull AdbNetworkSocket hostSocket, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAdbReverseTunnel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hostSocket, (String)"hostSocket");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Object[] objectArray = new String[]{"reverse", "--remove", String.valueOf(hostSocket)};
        return $this$removeAdbReverseTunnel.execute(CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ CommandResult removeAdbReverseTunnel$default(DeviceController deviceController, AdbNetworkSocket adbNetworkSocket, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(120L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(120L)");
            duration = duration2;
        }
        return AndroidDeviceControllerExtKt.removeAdbReverseTunnel(deviceController, adbNetworkSocket, duration);
    }

    @NotNull
    public static final CommandResult removeAllAdbReverseTunnels(@NotNull DeviceController $this$removeAllAdbReverseTunnels, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAllAdbReverseTunnels, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Object[] objectArray = new String[]{"reverse", "--remove-all"};
        return $this$removeAllAdbReverseTunnels.execute(CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ CommandResult removeAllAdbReverseTunnels$default(DeviceController deviceController, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(120L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(120L)");
            duration = duration2;
        }
        return AndroidDeviceControllerExtKt.removeAllAdbReverseTunnels(deviceController, duration);
    }

    @NotNull
    public static final CommandResult listReverseTunnel(@NotNull DeviceController $this$listReverseTunnel, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$listReverseTunnel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Object[] objectArray = new String[]{"remove", "--list"};
        return $this$listReverseTunnel.execute(CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ CommandResult listReverseTunnel$default(DeviceController deviceController, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(120L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(120L)");
            duration = duration2;
        }
        return AndroidDeviceControllerExtKt.listReverseTunnel(deviceController, duration);
    }

    public static final void unlockScreen(@NotNull DeviceController $this$unlockScreen, @Nullable Duration timeout) {
        boolean isWear;
        Intrinsics.checkNotNullParameter((Object)$this$unlockScreen, (String)"<this>");
        DeviceProperties deviceProperties = $this$unlockScreen.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        AndroidDeviceProperties props = (AndroidDeviceProperties)deviceProperties;
        String productName = (String)props.getMap().get("ro.product.name");
        String productSystemName = (String)props.getMap().get("ro.product.system.name");
        String string = productName;
        boolean isTv = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"_atv_", (boolean)false, (int)2, null) : false;
        String string2 = productSystemName;
        boolean bl = isWear = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"_gwear_", (boolean)false, (int)2, null) : props.getMap().containsKey("ro.stem_primary.location.x");
        if (!isTv && !isWear) {
            AndroidDeviceControllerExtKt.deviceShell($this$unlockScreen, Constants.INSTANCE.getUNLOCK_SCREEN_CMD(), timeout);
        }
    }

    public static /* synthetic */ void unlockScreen$default(DeviceController deviceController, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = null;
        }
        AndroidDeviceControllerExtKt.unlockScreen(deviceController, duration);
    }

    @CanIgnoreReturnValue
    @NotNull
    public static final CommandResult setProp(@NotNull DeviceController $this$setProp, @NotNull String prop, @NotNull String value, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$setProp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(((CharSequence)prop).length() > 0)) {
            boolean bl = false;
            String string = "prop cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"setprop", prop, value};
        return AndroidDeviceControllerExtKt.deviceShell($this$setProp, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ CommandResult setProp$default(DeviceController deviceController, String string, String string2, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.setProp(deviceController, string, string2, duration);
    }

    public static final int apiLevel(@NotNull DeviceController $this$apiLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$apiLevel, (String)"<this>");
        DeviceProperties deviceProperties = $this$apiLevel.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        return Integer.parseInt(((AndroidDeviceProperties)deviceProperties).getDeviceApiLevel());
    }

    @Nullable
    public static final String getProperty(@NotNull DeviceController $this$getProperty, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(((CharSequence)key).length() > 0)) {
            boolean bl = false;
            String string = "Key cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        DeviceProperties deviceProperties = $this$getProperty.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        AndroidDeviceProperties properties = (AndroidDeviceProperties)deviceProperties;
        return (String)properties.getMap().get(key);
    }

    @NotNull
    public static final String externalStorageDir(@NotNull DeviceController $this$externalStorageDir) {
        Intrinsics.checkNotNullParameter((Object)$this$externalStorageDir, (String)"<this>");
        DeviceProperties deviceProperties = $this$externalStorageDir.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        AndroidDeviceProperties properties = (AndroidDeviceProperties)deviceProperties;
        String string = properties.getAutoExtraStorageDir();
        if (string == null) {
            string = properties.getExternalStorageDir();
        }
        return string;
    }

    @CanIgnoreReturnValue
    @NotNull
    public static final CommandResult clearLogcat(@NotNull DeviceController $this$clearLogcat, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$clearLogcat, (String)"<this>");
        Object[] objectArray = new String[]{"logcat", "-c"};
        return AndroidDeviceControllerExtKt.deviceShell($this$clearLogcat, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ CommandResult clearLogcat$default(DeviceController deviceController, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.clearLogcat(deviceController, duration);
    }

    public static final void clearPackageData(@NotNull DeviceController $this$clearPackageData, @NotNull String targetPackage, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$clearPackageData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        if (!(((CharSequence)targetPackage).length() > 0)) {
            boolean bl = false;
            String string = targetPackage + " cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"pm", "clear", targetPackage};
        AndroidDeviceControllerExtKt.deviceShell($this$clearPackageData, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ void clearPackageData$default(DeviceController deviceController, String string, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        AndroidDeviceControllerExtKt.clearPackageData(deviceController, string, duration);
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    @NotNull
    public static final CommandResult uninstall(@NotNull DeviceController $this$uninstall, @NotNull String targetPackage, boolean keepDataAndCache, @Nullable Duration timeout) {
        void $this$uninstall_u24lambda_u2d7;
        Intrinsics.checkNotNullParameter((Object)$this$uninstall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        if (!(((CharSequence)targetPackage).length() > 0)) {
            boolean $i$a$-require-AndroidDeviceControllerExtKt$uninstall$22 = false;
            String $i$a$-require-AndroidDeviceControllerExtKt$uninstall$22 = targetPackage + " cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-AndroidDeviceControllerExtKt$uninstall$22.toString());
        }
        Object object = new String[]{"pm", "uninstall"};
        Object $i$a$-require-AndroidDeviceControllerExtKt$uninstall$22 = object = CollectionsKt.mutableListOf((Object[])object);
        DeviceController deviceController = $this$uninstall;
        boolean bl = false;
        if (keepDataAndCache) {
            $this$uninstall_u24lambda_u2d7.add("-k");
        }
        $this$uninstall_u24lambda_u2d7.add(targetPackage);
        return AndroidDeviceControllerExtKt.deviceShell(deviceController, (List<String>)object, timeout);
    }

    public static /* synthetic */ CommandResult uninstall$default(DeviceController deviceController, String string, boolean bl, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.uninstall(deviceController, string, bl, duration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommandResult listPackages(@NotNull DeviceController $this$listPackages, @NotNull List<String> options, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$listPackages, (String)"<this>");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Object object = new String[]{"pm", "list", "packages"};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        DeviceController deviceController = $this$listPackages;
        boolean bl = false;
        if (!((Collection)options).isEmpty()) {
            void $this$listPackages_u24lambda_u2d8;
            $this$listPackages_u24lambda_u2d8.addAll((Collection)options);
        }
        return AndroidDeviceControllerExtKt.deviceShell(deviceController, (List<String>)object, timeout);
    }

    public static /* synthetic */ CommandResult listPackages$default(DeviceController deviceController, List list, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.listPackages(deviceController, list, duration);
    }

    public static final boolean isTestServiceInstalled(@NotNull DeviceController $this$isTestServiceInstalled) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestServiceInstalled, (String)"<this>");
        CommandResult cmdOutput = AndroidDeviceControllerExtKt.listPackages$default($this$isTestServiceInstalled, CollectionsKt.listOf((Object)"androidx.test.services"), null, 2, null);
        return !((Collection)cmdOutput.getOutput()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    @NotNull
    public static final CommandResult delete(@NotNull DeviceController $this$delete, @NotNull List<String> paths, boolean recursivelyDelete, @Nullable Duration timeout) {
        void $this$delete_u24lambda_u2d10;
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (!(!((Collection)paths).isEmpty())) {
            boolean $i$a$-require-AndroidDeviceControllerExtKt$delete$22 = false;
            String $i$a$-require-AndroidDeviceControllerExtKt$delete$22 = "No paths to delete.";
            throw new IllegalArgumentException($i$a$-require-AndroidDeviceControllerExtKt$delete$22.toString());
        }
        Object object = new String[]{"rm"};
        Object $i$a$-require-AndroidDeviceControllerExtKt$delete$22 = object = CollectionsKt.mutableListOf((Object[])object);
        DeviceController deviceController = $this$delete;
        boolean bl = false;
        if (recursivelyDelete) {
            $this$delete_u24lambda_u2d10.add("-rf");
        }
        $this$delete_u24lambda_u2d10.addAll((Collection)paths);
        return AndroidDeviceControllerExtKt.deviceShell(deviceController, (List<String>)object, timeout);
    }

    public static /* synthetic */ CommandResult delete$default(DeviceController deviceController, List list, boolean bl, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.delete(deviceController, list, bl, duration);
    }

    public static final void makeDirectory(@NotNull DeviceController $this$makeDirectory, @NotNull String absolutePath, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$makeDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        if (!(((CharSequence)absolutePath).length() > 0 && StringsKt.startsWith$default((String)absolutePath, (String)"/", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Invalid path. Has to be an absolute path.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"mkdir", "-p", absolutePath};
        AndroidDeviceControllerExtKt.deviceShell($this$makeDirectory, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    public static /* synthetic */ void makeDirectory$default(DeviceController deviceController, String string, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        AndroidDeviceControllerExtKt.makeDirectory(deviceController, string, duration);
    }

    @Nullable
    public static final String getAppVersionCode(@NotNull DeviceController $this$getAppVersionCode, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppVersionCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object[] objectArray = new String[]{"dumpsys", "package", packageName};
        CommandResult result = AndroidDeviceControllerExtKt.deviceShellAndLogOnFailure$default($this$getAppVersionCode, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
        if (result.getStatusCode() != 0) {
            return null;
        }
        String output = CollectionsKt.joinToString$default((Iterable)result.getOutput(), null, null, null, (int)0, null, null, (int)63, null);
        Object object = Regex.find$default((Regex)new Regex(" versionCode=(\\d+)"), (CharSequence)output, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
    }

    public static final int getAppVersionCodeAsInt(@NotNull DeviceController $this$getAppVersionCodeAsInt, @NotNull String packageName) {
        String versionCode;
        Intrinsics.checkNotNullParameter((Object)$this$getAppVersionCodeAsInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String string = versionCode = AndroidDeviceControllerExtKt.getAppVersionCode($this$getAppVersionCodeAsInt, packageName);
        return string != null ? Integer.parseInt(string) : -1;
    }

    @Deprecated(message="Please update to using a Duration for timeout")
    @NotNull
    public static final CommandResult installAndGrantPermissions(@NotNull DeviceController $this$installAndGrantPermissions, @NotNull TestArtifactProto.Artifact artifact, long timeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$installAndGrantPermissions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return AndroidDeviceControllerExtKt.installAndGrantPermissions($this$installAndGrantPermissions, artifact, Duration.ofSeconds(timeoutSeconds));
    }

    @NotNull
    public static final CommandResult installAndGrantPermissions(@NotNull DeviceController $this$installAndGrantPermissions, @NotNull TestArtifactProto.Artifact artifact, @Nullable Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$installAndGrantPermissions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (!artifact.hasSourcePath()) {
            boolean bl = false;
            String string = "Artifact source path needs to be set.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"install", "-g", artifact.getSourcePath().getPath()};
        return $this$installAndGrantPermissions.execute(CollectionsKt.listOf((Object[])objectArray), timeout);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommandResult installMultiPackage(@NotNull DeviceController $this$installMultiPackage, @NotNull Set<TestArtifactProto.Artifact> artifacts, @Nullable Duration timeout) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$installMultiPackage_u24lambda_u2d18;
        Object element$iv2;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$installMultiPackage, (String)"<this>");
            Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
            if (!(!((Collection)artifacts).isEmpty())) {
                boolean $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$22 = false;
                String $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$22 = "No apk to install.";
                throw new IllegalArgumentException($i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$22.toString());
            }
            Iterable $this$all$iv = artifacts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    TestArtifactProto.Artifact it = (TestArtifactProto.Artifact)element$iv2;
                    boolean bl2 = false;
                    if (it.hasSourcePath()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$52 = false;
            String $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$52 = "All artifact sources need to be set.";
            throw new IllegalArgumentException($i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$52.toString());
        }
        if (!(AndroidDeviceControllerExtKt.apiLevel($this$installMultiPackage) >= 29)) {
            boolean $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$62 = false;
            String $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$62 = "Install-multi-package support requires the minimal API level to 29.";
            throw new IllegalArgumentException($i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$62.toString());
        }
        Object object = new String[]{"install-multi-package", "-r", "-t", "-g"};
        Object $i$a$-require-AndroidDeviceControllerExtKt$installMultiPackage$62 = object = CollectionsKt.mutableListOf((Object[])object);
        DeviceController deviceController = $this$installMultiPackage;
        boolean bl3 = false;
        element$iv2 = artifacts;
        void var7_13 = $this$installMultiPackage_u24lambda_u2d18;
        boolean $i$f$map = false;
        void var9_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestArtifactProto.Artifact artifact = (TestArtifactProto.Artifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(it.getSourcePath().getPath());
        }
        var7_13.addAll((List)destination$iv$iv);
        return deviceController.execute((List)object, timeout);
    }

    @NotNull
    public static final String getExternalStoragePath(@NotNull DeviceController $this$getExternalStoragePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getExternalStoragePath, (String)"<this>");
        DeviceProperties deviceProperties = $this$getExternalStoragePath.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        AndroidDeviceProperties deviceProperties2 = (AndroidDeviceProperties)deviceProperties;
        String string = deviceProperties2.getAutoExtraStorageDir();
        if (string == null) {
            string = deviceProperties2.getExternalStorageDir();
        }
        return string;
    }

    @NotNull
    public static final List<String> getExtraInstallOptions(@NotNull DeviceController $this$getExtraInstallOptions, boolean replaceExistingApp, boolean allowTestApks, boolean grandRuntimePermissions, boolean allowVersionDowngrade) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getExtraInstallOptions, (String)"<this>");
        int deviceApiLevel = AndroidDeviceControllerExtKt.apiLevel($this$getExtraInstallOptions);
        Object[] objectArray = new String[4];
        String string2 = string = "-r";
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = replaceExistingApp;
        objectArray2[n] = bl2 ? string : null;
        String it = string = "-t";
        n = 1;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = allowTestApks;
        objectArray2[n] = bl2 ? string : null;
        it = string = "-g";
        n = 2;
        objectArray2 = objectArray;
        boolean bl4 = false;
        bl2 = grandRuntimePermissions && deviceApiLevel >= 23;
        objectArray2[n] = bl2 ? string : null;
        it = string = "-d";
        n = 3;
        objectArray2 = objectArray;
        boolean bl5 = false;
        bl2 = allowVersionDowngrade && deviceApiLevel >= 21;
        objectArray2[n] = bl2 ? string : null;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public static /* synthetic */ List getExtraInstallOptions$default(DeviceController deviceController, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        return AndroidDeviceControllerExtKt.getExtraInstallOptions(deviceController, bl, bl2, bl3, bl4);
    }

    public static final boolean waitForDeviceHealthy(@NotNull DeviceController $this$waitForDeviceHealthy, @NotNull Duration timeout, @NotNull Duration retryInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$waitForDeviceHealthy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)retryInterval, (String)"retryInterval");
        Exception lastException = null;
        long attempt = 0L;
        long l = timeout.toMillis() / retryInterval.toMillis();
        if (attempt <= l) {
            while (true) {
                try {
                    if (AndroidDeviceControllerExtKt.isDeviceHealthy($this$waitForDeviceHealthy)) {
                        return true;
                    }
                }
                catch (Exception x) {
                    lastException = x;
                }
                TimeUnit.MILLISECONDS.sleep(retryInterval.toMillis());
                if (attempt == l) break;
                ++attempt;
            }
        }
        AndroidDeviceControllerExtKt.getLogger().log(Level.WARNING, "Device did not achieve health within " + timeout, lastException);
        return false;
    }

    public static /* synthetic */ boolean waitForDeviceHealthy$default(DeviceController deviceController, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration3 = Duration.ofMillis(100L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(100)");
            duration2 = duration3;
        }
        return AndroidDeviceControllerExtKt.waitForDeviceHealthy(deviceController, duration, duration2);
    }

    public static final boolean isDeviceHealthy(@NotNull DeviceController $this$isDeviceHealthy) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeviceHealthy, (String)"<this>");
        return AndroidDeviceControllerExtKt.isSystemServerRunning($this$isDeviceHealthy) && AndroidDeviceControllerExtKt.isDataMounted($this$isDeviceHealthy) && AndroidDeviceControllerExtKt.isSysBootCompletedSet($this$isDeviceHealthy) && AndroidDeviceControllerExtKt.isPackageManagerRunning($this$isDeviceHealthy);
    }

    public static final boolean isSystemServerRunning(@NotNull DeviceController $this$isSystemServerRunning) {
        Intrinsics.checkNotNullParameter((Object)$this$isSystemServerRunning, (String)"<this>");
        List args = new ArrayList();
        if (AndroidDeviceControllerExtKt.apiLevel($this$isSystemServerRunning) >= 26) {
            args.add("-ef");
        }
        return AndroidDeviceControllerExtKt.checkStdoutContains$default($this$isSystemServerRunning, "ps", args, "system_server", null, 8, null);
    }

    public static final boolean isDataMounted(@NotNull DeviceController $this$isDataMounted) {
        Intrinsics.checkNotNullParameter((Object)$this$isDataMounted, (String)"<this>");
        return AndroidDeviceControllerExtKt.checkStdoutContains$default($this$isDataMounted, "mount", CollectionsKt.listOfNotNull((Object[])new String[0]), new Regex("/data (type )?ext4"), null, 8, null);
    }

    public static final boolean isSysBootCompletedSet(@NotNull DeviceController $this$isSysBootCompletedSet) {
        Intrinsics.checkNotNullParameter((Object)$this$isSysBootCompletedSet, (String)"<this>");
        return AndroidDeviceControllerExtKt.checkStdoutContains$default($this$isSysBootCompletedSet, "getprop", CollectionsKt.listOfNotNull((Object[])new String[0]), "[sys.boot_completed]: [1]", null, 8, null) || AndroidDeviceControllerExtKt.checkStdoutContains$default($this$isSysBootCompletedSet, "getprop", CollectionsKt.listOfNotNull((Object[])new String[0]), "[dev.bootcomplete]: [1]", null, 8, null);
    }

    public static final boolean isPackageManagerRunning(@NotNull DeviceController $this$isPackageManagerRunning) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackageManagerRunning, (String)"<this>");
        Object[] objectArray = new String[]{"/system/bin/pm", "path", "android"};
        return AndroidDeviceControllerExtKt.checkStdoutContains$default($this$isPackageManagerRunning, "/system/bin/sh", CollectionsKt.listOf((Object[])objectArray), "package:", null, 8, null);
    }

    public static final boolean checkStdoutContains(@NotNull DeviceController $this$checkStdoutContains, @NotNull String cmd, @NotNull List<String> args, @NotNull String keyword, @Nullable Duration timeout) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$checkStdoutContains, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            CommandResult result = AndroidDeviceControllerExtKt.deviceShell($this$checkStdoutContains, (List<String>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)cmd), (Iterable)args), timeout);
            Sequence $this$any$iv = CommandResult.outputLineSequence$default((CommandResult)result, null, (int)1, null);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)keyword, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean checkStdoutContains$default(DeviceController deviceController, String string, List list, String string2, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.checkStdoutContains(deviceController, string, (List<String>)list, string2, duration);
    }

    public static final boolean checkStdoutContains(@NotNull DeviceController $this$checkStdoutContains, @NotNull String cmd, @NotNull List<String> args, @NotNull Regex regex, @Nullable Duration timeout) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$checkStdoutContains, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            CommandResult result = AndroidDeviceControllerExtKt.deviceShell($this$checkStdoutContains, (List<String>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)cmd), (Iterable)args), timeout);
            Sequence $this$any$iv = CommandResult.outputLineSequence$default((CommandResult)result, null, (int)1, null);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!regex.containsMatchIn((CharSequence)it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean checkStdoutContains$default(DeviceController deviceController, String string, List list, Regex regex, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.checkStdoutContains(deviceController, string, (List<String>)list, regex, duration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> pids(@NotNull DeviceController $this$pids, @NotNull String processName, @Nullable Duration timeout) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$pids, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        List output = AndroidDeviceControllerExtKt.deviceShell($this$pids, (List<String>)CollectionsKt.listOf((Object)"ps"), timeout).component2();
        if (output.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        CharSequence charSequence = (CharSequence)output.get(0);
        Regex regex = new Regex("\\s+");
        int n = 0;
        List headers = regex.split(charSequence, n);
        int pidColumnIndex = headers.indexOf("PID");
        int processNameIndex = headers.indexOf("NAME");
        if (pidColumnIndex < 0 || processNameIndex < 0) {
            return CollectionsKt.emptyList();
        }
        List processInfoList = output.subList(1, output.size());
        Iterable $this$mapNotNull$iv = processInfoList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            String name;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String processInfo = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = processInfo;
            Regex regex2 = new Regex("\\s+");
            int n2 = 0;
            List infoList = regex2.split(charSequence2, n2);
            int deviceApiLevel = AndroidDeviceControllerExtKt.apiLevel($this$pids);
            String string = name = deviceApiLevel >= 26 ? (String)infoList.get(processNameIndex) : (String)infoList.get(processNameIndex + 1);
            if ((Intrinsics.areEqual((Object)name, (Object)processName) ? (String)infoList.get(pidColumnIndex) : (String)null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List pids$default(DeviceController deviceController, String string, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.pids(deviceController, string, duration);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean threadDump(@NotNull DeviceController $this$threadDump, @NotNull String appPackage, @NotNull String outputFolder, @Nullable Duration timeout) {
        Object e;
        Object object;
        Object object2;
        String pid;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$threadDump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)appPackage, (String)"appPackage");
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        List appProcessIds = AndroidDeviceControllerExtKt.pids$default($this$threadDump, appPackage, null, 2, null);
        if (appProcessIds.isEmpty()) {
            AndroidDeviceControllerExtKt.getLogger().warning("No " + appPackage + " process is running");
            return false;
        }
        AndroidDeviceControllerExtKt.getLogger().info("Capturing a thread dump for " + appProcessIds);
        String anrFolder = "/data/anr/";
        AndroidDeviceControllerExtKt.makeDirectory$default($this$threadDump, anrFolder, null, 2, null);
        int deviceApiLevel = AndroidDeviceControllerExtKt.apiLevel($this$threadDump);
        if (deviceApiLevel >= 27) {
            objectArray = new String[]{"touch", anrFolder + "trace_00"};
            AndroidDeviceControllerExtKt.deviceShell($this$threadDump, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        } else {
            objectArray = new String[]{"touch", anrFolder + "traces.txt"};
            AndroidDeviceControllerExtKt.deviceShell($this$threadDump, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        }
        boolean succeeded = false;
        Iterable $this$forEach$iv = appProcessIds;
        boolean $i$f$forEach2 = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            pid = (String)element$iv;
            boolean bl = false;
            for (int retries = 0; retries < 3; ++retries) {
                List anrFileContent;
                Object v0;
                Object[] objectArray2;
                block8: {
                    object2 = new String[]{"kill", "-3", pid};
                    AndroidDeviceControllerExtKt.deviceShell($this$threadDump, (List<String>)CollectionsKt.listOf((Object[])object2), timeout);
                    Object[] objectArray3 = new String[]{"ls", anrFolder};
                    List output = AndroidDeviceControllerExtKt.deviceShell($this$threadDump, (List<String>)CollectionsKt.listOf((Object[])objectArray3), timeout).component2();
                    objectArray2 = (Object[])output;
                    object = objectArray2.iterator();
                    while (object.hasNext()) {
                        e = object.next();
                        String fileName = (String)e;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)fileName)).toString(), (CharSequence)"trace", (boolean)false, (int)2, null)) continue;
                        v0 = e;
                        break block8;
                    }
                    v0 = null;
                }
                String traceFile = v0;
                if (traceFile == null || !(!((Collection)(anrFileContent = AndroidDeviceControllerExtKt.deviceShell($this$threadDump, (List<String>)CollectionsKt.listOf((Object[])(objectArray2 = new String[]{"cat", anrFolder + traceFile})), timeout).component2())).isEmpty()) || (object = (CharSequence)anrFileContent.get(0)) == null || StringsKt.isBlank((CharSequence)object)) continue;
                succeeded = true;
                continue block0;
            }
        }
        if (succeeded) {
            void $this$threadDump_u24lambda_u2d30_u24lambda_u2d29;
            Object $this$threadDump_u24lambda_u2d30_u24lambda_u2d28;
            void $this$threadDump_u24lambda_u2d30;
            boolean bl = false;
            TestArtifactProto.Artifact.Builder builder = TestArtifactProto.Artifact.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
            String[] $this$artifact_u24lambda_u2d0$iv = $i$f$forEach2 = ArtifactKt.Dsl.Companion._create(builder);
            boolean bl3 = false;
            pid = $this$artifact_u24lambda_u2d0$iv;
            DeviceController deviceController = $this$threadDump;
            boolean bl4 = false;
            boolean bl5 = false;
            PathProto.Path.Builder builder2 = PathProto.Path.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
            Object $this$path_u24lambda_u2d0$iv = object2 = PathKt.Dsl.Companion._create(builder2);
            boolean bl6 = false;
            object = $this$path_u24lambda_u2d0$iv;
            e = $this$threadDump_u24lambda_u2d30;
            boolean bl7 = false;
            ((PathKt.Dsl)$this$threadDump_u24lambda_u2d30_u24lambda_u2d28).setPath(anrFolder);
            e.setDestinationPath(((PathKt.Dsl)object2)._build());
            bl5 = false;
            PathProto.Path.Builder builder3 = PathProto.Path.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder()");
            $this$path_u24lambda_u2d0$iv = object2 = PathKt.Dsl.Companion._create(builder3);
            bl6 = false;
            $this$threadDump_u24lambda_u2d30_u24lambda_u2d28 = $this$path_u24lambda_u2d0$iv;
            e = $this$threadDump_u24lambda_u2d30;
            boolean bl8 = false;
            $this$threadDump_u24lambda_u2d30_u24lambda_u2d29.setPath(outputFolder);
            e.setSourcePath(((PathKt.Dsl)object2)._build());
            deviceController.pull($i$f$forEach2._build());
            String[] $i$f$forEach2 = new String[]{"anr"};
            File file = Paths.get(outputFolder, $i$f$forEach2).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(outputFolder, Constants.ANR_FOLDER).toFile()");
            Sequence $this$forEach$iv2 = (Sequence)FilesKt.walk$default((File)file, null, (int)1, null);
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CharSequence charSequence;
                File it = (File)element$iv;
                boolean bl9 = false;
                if (it.isDirectory() || !((charSequence = (CharSequence)FilesKt.getExtension((File)it)) == null || charSequence.length() == 0)) continue;
                it.renameTo(new File(it.getAbsolutePath() + ".txt"));
            }
        }
        return succeeded;
    }

    public static /* synthetic */ boolean threadDump$default(DeviceController deviceController, String string, String string2, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.threadDump(deviceController, string, string2, duration);
    }

    @NotNull
    public static final CommandResult execAndLogOnFailure(@NotNull DeviceController $this$execAndLogOnFailure, @NotNull List<String> args, @Nullable Duration timeout) {
        CommandResult commandResult;
        Intrinsics.checkNotNullParameter((Object)$this$execAndLogOnFailure, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        CommandResult cmdResult = commandResult = $this$execAndLogOnFailure.execute(args, timeout);
        boolean bl = false;
        if (cmdResult.getStatusCode() != 0) {
            AndroidDeviceControllerExtKt.getLogger().warning("Failed to execute command " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "! Exited with code: " + cmdResult.getStatusCode() + ".\nOutput: " + cmdResult.getByteOutput());
        }
        return commandResult;
    }

    public static /* synthetic */ CommandResult execAndLogOnFailure$default(DeviceController deviceController, List list, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        return AndroidDeviceControllerExtKt.execAndLogOnFailure(deviceController, list, duration);
    }

    @Nullable
    public static final String getCurrentUser(@NotNull DeviceController $this$getCurrentUser) {
        Intrinsics.checkNotNullParameter((Object)$this$getCurrentUser, (String)"<this>");
        DeviceProperties deviceProperties = $this$getCurrentUser.getDevice().getProperties();
        Object object = deviceProperties instanceof AndroidDeviceProperties ? (AndroidDeviceProperties)deviceProperties : null;
        if (object == null || (object = object.getCurrentUser()) == null) {
            Object[] objectArray = new String[]{"am", "get-current-user"};
            object = (String)CollectionsKt.firstOrNull((List)AndroidDeviceControllerExtKt.deviceShellAndLogOnFailure$default($this$getCurrentUser, CollectionsKt.listOf((Object[])objectArray), null, 2, null).getOutput());
        }
        return object;
    }

    public static final boolean isRunningUnderSystemUser(@NotNull DeviceController $this$isRunningUnderSystemUser) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunningUnderSystemUser, (String)"<this>");
        String string = AndroidDeviceControllerExtKt.getCurrentUser($this$isRunningUnderSystemUser);
        return string == null ? true : (Intrinsics.areEqual((Object)string, (Object)"") ? true : Intrinsics.areEqual((Object)string, (Object)"0"));
    }

    /*
     * WARNING - void declaration
     */
    public static final int installSystemApks(@NotNull DeviceController $this$installSystemApks, @NotNull List<String> systemApksToInstall, int deviceApiLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$installSystemApks, (String)"<this>");
        Intrinsics.checkNotNullParameter(systemApksToInstall, (String)"systemApksToInstall");
        if (((Collection)systemApksToInstall).isEmpty()) {
            return 0;
        }
        int result = 0;
        AndroidDeviceControllerExtKt.remountSystem($this$installSystemApks, "rw", deviceApiLevel);
        String systemBase = deviceApiLevel >= 19 ? "/system/priv-app" : "/system/app";
        for (String apkPath : systemApksToInstall) {
            void $this$installSystemApks_u24lambda_u2d36_u24lambda_u2d35;
            PathKt.Dsl $this$installSystemApks_u24lambda_u2d36_u24lambda_u2d34;
            PathKt.Dsl dsl;
            Object[] objectArray;
            Object object;
            block7: {
                Path hostPath;
                block6: {
                    hostPath = Paths.get(apkPath, new String[0]);
                    object = hostPath.getParent();
                    if (object == null || (object = object.getFileName()) == null) break block6;
                    Path fileName = object;
                    boolean bl = false;
                    Object[] objectArray2 = new String[]{((Object)fileName).toString(), ((Object)hostPath.getFileName()).toString()};
                    String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
                    object = string;
                    if (string != null) break block7;
                }
                object = ((Object)hostPath.getFileName()).toString();
            }
            Object uniqueFilename = object;
            String[] stringArray = new String[]{uniqueFilename};
            String dataPath = ((Object)Paths.get("/data", stringArray)).toString();
            String[] stringArray2 = new String[]{uniqueFilename};
            String systemPath = ((Object)Paths.get(systemBase, stringArray2)).toString();
            boolean bl = false;
            TestArtifactProto.Artifact.Builder builder = TestArtifactProto.Artifact.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
            Object[] $this$artifact_u24lambda_u2d0$iv = objectArray = ArtifactKt.Dsl.Companion._create(builder);
            boolean bl2 = false;
            Object[] $this$installSystemApks_u24lambda_u2d36 = $this$artifact_u24lambda_u2d0$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            PathProto.Path.Builder builder2 = PathProto.Path.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
            PathKt.Dsl $this$path_u24lambda_u2d0$iv = dsl = PathKt.Dsl.Companion._create(builder2);
            boolean bl5 = false;
            PathKt.Dsl dsl2 = $this$path_u24lambda_u2d0$iv;
            Object[] objectArray3 = $this$installSystemApks_u24lambda_u2d36;
            boolean bl6 = false;
            $this$installSystemApks_u24lambda_u2d36_u24lambda_u2d34.setPath(dataPath);
            objectArray3.setDestinationPath(dsl._build());
            bl4 = false;
            PathProto.Path.Builder builder3 = PathProto.Path.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder()");
            $this$path_u24lambda_u2d0$iv = dsl = PathKt.Dsl.Companion._create(builder3);
            bl5 = false;
            $this$installSystemApks_u24lambda_u2d36_u24lambda_u2d34 = $this$path_u24lambda_u2d0$iv;
            objectArray3 = $this$installSystemApks_u24lambda_u2d36;
            boolean bl7 = false;
            $this$installSystemApks_u24lambda_u2d36_u24lambda_u2d35.setPath(apkPath);
            objectArray3.setSourcePath(dsl._build());
            $this$installSystemApks_u24lambda_u2d36.setType(TestArtifactProto.ArtifactType.ANDROID_APK);
            TestArtifactProto.Artifact apkArtifact = objectArray._build();
            int pushResult = $this$installSystemApks.push(apkArtifact);
            if (pushResult != 0) {
                result = pushResult;
            }
            objectArray = new String[]{"ln", "-s", dataPath, systemPath};
            AndroidDeviceControllerExtKt.deviceShell$default($this$installSystemApks, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
        }
        AndroidDeviceControllerExtKt.remountSystem($this$installSystemApks, "ro", deviceApiLevel);
        return result;
    }

    private static final void remountSystem(DeviceController $this$remountSystem, String mode, int deviceApiLevel) {
        if (deviceApiLevel >= 33) {
            AndroidDeviceControllerExtKt.shellRemountSystem($this$remountSystem, mode);
            return;
        }
        String mountPoint = "/system";
        if (deviceApiLevel >= 28) {
            mountPoint = "/";
        }
        AndroidDeviceControllerExtKt.remount($this$remountSystem, mountPoint, mode);
    }

    private static final void remount(DeviceController $this$remount, String mountPoint, String mode) {
        Object[] objectArray = new String[]{"mount", "-o", mode + ",remount", mountPoint};
        AndroidDeviceControllerExtKt.deviceShell$default($this$remount, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
    }

    private static final void shellRemountSystem(DeviceController $this$shellRemountSystem, String mode) {
        if (mode.equals("rw")) {
            AndroidDeviceControllerExtKt.deviceShell$default($this$shellRemountSystem, CollectionsKt.listOf((Object)"remount"), null, 2, null);
        }
    }

    public static final void restartSystem(@NotNull DeviceController $this$restartSystem, int deviceApiLevel, @Nullable Duration timeout) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$restartSystem, (String)"<this>");
        if (deviceApiLevel >= 23) {
            objectArray = new String[]{"stop", "fingerprintd"};
            AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        }
        objectArray = new String[]{"setprop", "sys.boot_completed", "0"};
        AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        objectArray = new String[]{"setprop", "dev.bootcomplete", "0"};
        AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        if (deviceApiLevel >= 19) {
            objectArray = new String[]{"am", "restart"};
            AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        } else {
            AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object)"stop"), timeout);
            AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object)"start"), timeout);
        }
        if (deviceApiLevel >= 23) {
            objectArray = new String[]{"start", "fingerprintd"};
            AndroidDeviceControllerExtKt.deviceShell($this$restartSystem, (List<String>)CollectionsKt.listOf((Object[])objectArray), timeout);
        }
    }

    public static /* synthetic */ void restartSystem$default(DeviceController deviceController, int n, Duration duration, int n2, Object object) {
        if ((n2 & 2) != 0) {
            duration = null;
        }
        AndroidDeviceControllerExtKt.restartSystem(deviceController, n, duration);
    }

    @NotNull
    public static final Set<Path> listFilesRecursively(@NotNull DeviceController $this$listFilesRecursively, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        if (!path2.isAbsolute()) {
            boolean $i$a$-require-AndroidDeviceControllerExtKt$listFilesRecursively$22 = false;
            String $i$a$-require-AndroidDeviceControllerExtKt$listFilesRecursively$22 = "Supplied path must be absolute";
            throw new IllegalArgumentException($i$a$-require-AndroidDeviceControllerExtKt$listFilesRecursively$22.toString());
        }
        String amendedPath = StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? path : path + '/';
        Object[] objectArray = new String[]{"ls", "-R", amendedPath, "2>/dev/null", "|cat"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        List output = AndroidDeviceControllerExtKt.deviceShell$default($this$listFilesRecursively, command, null, 2, null).getOutput();
        Ref.ObjectRef currentDir = new Ref.ObjectRef();
        Set paths = new LinkedHashSet();
        for (String line : output) {
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Permission denied", (boolean)false, (int)2, null)) continue;
            if (StringsKt.startsWith$default((String)line, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)line, (String)":", (boolean)false, (int)2, null)) {
                Path path3 = Paths.get(StringsKt.substringBefore$default((String)line, (String)":", null, (int)2, null), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(path)");
                currentDir.element = path3.toAbsolutePath();
                paths.removeIf(new Predicate((Ref.ObjectRef<Path>)currentDir){
                    final /* synthetic */ Ref.ObjectRef<Path> $currentDir;
                    {
                        this.$currentDir = $currentDir;
                    }

                    public final boolean test(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it, (Object)this.$currentDir.element);
                    }
                });
                continue;
            }
            if (((CharSequence)line).length() == 0) {
                currentDir.element = null;
                continue;
            }
            if (currentDir.element == null) continue;
            Path path4 = ((Path)currentDir.element).resolve(line).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"currentDir.resolve(line).toAbsolutePath()");
            paths.add(path4);
        }
        return CollectionsKt.toSet((Iterable)paths);
    }
}

