/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.timing;

import com.google.testing.platform.lib.adb.command.timing.TestTimeTracker;
import com.google.testing.platform.lib.adb.command.timing.TestTimeTrackerImpl;
import com.google.testing.platform.lib.adb.command.timing.TestTimingData;
import com.google.testing.platform.lib.coroutines.atomic.AtomicDelegateKt;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import java.time.Instant;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR+\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTrackerImpl;", "Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTracker;", "now", "Lkotlin/Function0;", "Ljava/time/Instant;", "(Lkotlin/jvm/functions/Function0;)V", "endTime", "", "<set-?>", "", "hasEnded", "getHasEnded", "()Z", "setHasEnded", "(Z)V", "hasEnded$delegate", "Lkotlin/properties/ReadWriteProperty;", "hasStarted", "getHasStarted", "setHasStarted", "hasStarted$delegate", "startTime", "testTimingData", "Lcom/google/testing/platform/lib/adb/command/timing/TestTimingData;", "getTestTimingData", "()Lcom/google/testing/platform/lib/adb/command/timing/TestTimingData;", "testEnd", "", "testStart", "Companion", "lib_java_com_google_testing_platform_lib_adb_command_timing-test_time_tracker"})
public final class TestTimeTrackerImpl
implements TestTimeTracker {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Function0<Instant> now;
    @NotNull
    private final ReadWriteProperty hasStarted$delegate;
    @NotNull
    private final ReadWriteProperty hasEnded$delegate;
    private long startTime;
    private long endTime;
    @NotNull
    private static final Logger logger;

    public TestTimeTrackerImpl(@NotNull Function0<Instant> now) {
        Intrinsics.checkNotNullParameter(now, (String)"now");
        this.now = now;
        this.hasStarted$delegate = AtomicDelegateKt.atomic(hasStarted.2.INSTANCE);
        this.hasEnded$delegate = AtomicDelegateKt.atomic(hasEnded.2.INSTANCE);
        this.startTime = -1L;
        this.endTime = -1L;
    }

    private final boolean getHasStarted() {
        return (Boolean)this.hasStarted$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setHasStarted(boolean bl) {
        this.hasStarted$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    private final boolean getHasEnded() {
        return (Boolean)this.hasEnded$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setHasEnded(boolean bl) {
        this.hasEnded$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
    }

    @Override
    @NotNull
    public TestTimingData getTestTimingData() {
        if (!this.getHasStarted()) {
            boolean $i$a$-require-TestTimeTrackerImpl$testTimingData$32 = false;
            String $i$a$-require-TestTimeTrackerImpl$testTimingData$32 = "Called TestTimeTracker.testTimingData before TestTimeTracker.testStart()";
            throw new IllegalArgumentException($i$a$-require-TestTimeTrackerImpl$testTimingData$32.toString());
        }
        if (!this.getHasEnded()) {
            boolean bl = false;
            String string = "Called TestTimeTracker.testTimingData before TestTimeTracker.testEnd()";
            throw new IllegalArgumentException(string.toString());
        }
        return new TestTimingData(this.startTime, this.endTime);
    }

    @Override
    public void testStart() {
        if (!(!this.getHasStarted())) {
            boolean bl = false;
            String string = "Called TestTimeTracker.testStart() twice";
            throw new IllegalArgumentException(string.toString());
        }
        this.startTime = ((Instant)this.now.invoke()).toEpochMilli();
        this.setHasStarted(true);
    }

    @Override
    public void testEnd() {
        if (!this.getHasStarted()) {
            logger.warning("TestTimeTracker.testEnd() was called before TestTimeTracker.testStart(). The test may not\nhave run. Check the test logs for details.");
            this.testStart();
        }
        if (!(!this.getHasEnded())) {
            boolean bl = false;
            String string = "Called TestTimeTracker.testEnd() twice";
            throw new IllegalArgumentException(string.toString());
        }
        this.endTime = ((Instant)this.now.invoke()).toEpochMilli();
        this.setHasEnded(true);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TestTimeTrackerImpl.class, "hasStarted", "getHasStarted()Z", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TestTimeTrackerImpl.class, "hasEnded", "getHasEnded()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = LoggerExtKt.getLogger(Companion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTrackerImpl$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "lib_java_com_google_testing_platform_lib_adb_command_timing-test_time_tracker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

