/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.provider.local;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.testing.platform.api.config.AndroidSdk;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.config.Configurable;
import com.google.testing.platform.api.config.Environment;
import com.google.testing.platform.api.config.Setup;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.Device;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.device.DeviceProvider;
import com.google.testing.platform.api.error.ErrorSummary;
import com.google.testing.platform.config.v1.extension.LocalAndroidDeviceProviderExtKt;
import com.google.testing.platform.core.device.DeviceProviderErrorSummary;
import com.google.testing.platform.core.device.DeviceProviderException;
import com.google.testing.platform.lib.adb.command.ConnectCmd;
import com.google.testing.platform.lib.adb.command.DevicesList;
import com.google.testing.platform.lib.adb.command.ListDevicesCmd;
import com.google.testing.platform.lib.adb.command.inject.AdbCommandComponent;
import com.google.testing.platform.lib.adb.command.inject.AdbCommands;
import com.google.testing.platform.lib.adb.command.inject.AdbConfig;
import com.google.testing.platform.lib.adb.command.inject.AdbTimeout;
import com.google.testing.platform.lib.adb.command.inject.CommandComponent;
import com.google.testing.platform.lib.adb.command.inject.DaggerAdbCommandComponent;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.config.AdbConfigProto;
import com.google.testing.platform.proto.api.config.LocalAndroidDeviceProviderProto;
import com.google.testing.platform.proto.api.config.RuntimeProto;
import com.google.testing.platform.runtime.android.AndroidDeviceProvider;
import com.google.testing.platform.runtime.android.device.AndroidDevice;
import com.google.testing.platform.runtime.android.provider.ext.AndroidDeviceProviderExtKt;
import com.google.testing.platform.runtime.android.provider.local.AndroidDeviceFromConfigKt;
import com.google.testing.platform.runtime.android.provider.local.AndroidDeviceFromSerialKt;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0019H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/google/testing/platform/runtime/android/provider/local/LocalAndroidDeviceProvider;", "Lcom/google/testing/platform/runtime/android/AndroidDeviceProvider;", "Lcom/google/testing/platform/api/config/Configurable;", "adbCommands", "Lcom/google/testing/platform/lib/adb/command/inject/AdbCommands;", "(Lcom/google/testing/platform/lib/adb/command/inject/AdbCommands;)V", "()V", "androidSdk", "Lcom/google/testing/platform/api/config/AndroidSdk;", "context", "Lcom/google/testing/platform/api/context/Context;", "deviceProviderConfig", "Lcom/google/testing/platform/proto/api/config/LocalAndroidDeviceProviderProto$LocalAndroidDeviceProvider;", "getDeviceProviderConfig$annotations", "getDeviceProviderConfig", "()Lcom/google/testing/platform/proto/api/config/LocalAndroidDeviceProviderProto$LocalAndroidDeviceProvider;", "setDeviceProviderConfig", "(Lcom/google/testing/platform/proto/api/config/LocalAndroidDeviceProviderProto$LocalAndroidDeviceProvider;)V", "environment", "Lcom/google/testing/platform/api/config/Environment;", "testSetup", "Lcom/google/testing/platform/api/config/Setup;", "cancel", "", "configure", "", "connectAndReturnDevice", "Lcom/google/testing/platform/runtime/android/device/AndroidDevice;", "config", "deviceIsConnected", "deviceSerial", "", "findDevice", "makeDevice", "provideDevice", "Lcom/google/testing/platform/api/device/DeviceController;", "releaseDevice", "validateLocalDeviceProviderConfig", "Companion", "java_com_google_testing_platform_runtime_android_provider_local-local_android_device_provider"})
@AutoService(value={DeviceProvider.class})
public final class LocalAndroidDeviceProvider
implements AndroidDeviceProvider,
Configurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Context context;
    private AdbCommands adbCommands;
    private Environment environment;
    private Setup testSetup;
    private AndroidSdk androidSdk;
    public LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider deviceProviderConfig;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);
    private static final long DEFAULT_ADB_COMMAND_TIMEOUT_SECONDS = 120L;

    @VisibleForTesting
    public LocalAndroidDeviceProvider() {
    }

    @NotNull
    public final LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider getDeviceProviderConfig() {
        LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider localAndroidDeviceProvider = this.deviceProviderConfig;
        if (localAndroidDeviceProvider != null) {
            return localAndroidDeviceProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"deviceProviderConfig");
        return null;
    }

    public final void setDeviceProviderConfig(@NotNull LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider localAndroidDeviceProvider) {
        Intrinsics.checkNotNullParameter((Object)localAndroidDeviceProvider, (String)"<set-?>");
        this.deviceProviderConfig = localAndroidDeviceProvider;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDeviceProviderConfig$annotations() {
    }

    public LocalAndroidDeviceProvider(@NotNull AdbCommands adbCommands) {
        Intrinsics.checkNotNullParameter((Object)adbCommands, (String)"adbCommands");
        this();
        this.adbCommands = adbCommands;
    }

    public void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Config config = ContextExtKt.getConfig(context);
        this.environment = ConfigExtKt.getEnvironment((Config)config);
        this.testSetup = ConfigExtKt.getSetup((Config)config);
        this.androidSdk = ConfigExtKt.getAndroidSdk((Config)config);
        Config $this$parseConfig$iv = config;
        boolean $i$f$parseConfig = false;
        Message message = ConfigExtKt.parseConfig((Config)$this$parseConfig$iv, LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider.class);
        Intrinsics.checkNotNull((Object)message);
        this.setDeviceProviderConfig(this.validateLocalDeviceProviderConfig((LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider)message));
    }

    public boolean cancel() {
        return false;
    }

    private final AndroidDevice makeDevice() {
        AndroidDevice androidDevice;
        logger.fine("Device provider configuration: " + this.getDeviceProviderConfig());
        Environment environment = this.environment;
        if (environment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment = null;
        }
        String string = environment.getOutputDirectory();
        Environment environment2 = this.environment;
        if (environment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment2 = null;
        }
        String string2 = environment2.getTempDirectory();
        AndroidSdk androidSdk = this.androidSdk;
        if (androidSdk == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidSdk");
            androidSdk = null;
        }
        String string3 = androidSdk.getAdbPath();
        Duration duration = Duration.ofSeconds(120L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(DEFAULT_ADB_COMMAND_TIMEOUT_SECONDS)");
        AdbTimeout adbTimeout = new AdbTimeout(duration, null, 2, null);
        Integer n = LocalAndroidDeviceProviderExtKt.getAdbServerPortOrDefault(this.getDeviceProviderConfig());
        String string4 = this.getDeviceProviderConfig().getSerial();
        String string5 = this.getDeviceProviderConfig().getHost();
        int n2 = this.getDeviceProviderConfig().getAdbPort();
        AdbConfig adbConfig = new AdbConfig(string, string2, null, string3, adbTimeout, string5, n, n2, null, string4, 260, null);
        if (this.adbCommands == null) {
            CommandComponent.Builder builder = DaggerAdbCommandComponent.builder().adbConfig(adbConfig);
            AndroidSdk androidSdk2 = this.androidSdk;
            if (androidSdk2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidSdk");
                androidSdk2 = null;
            }
            this.adbCommands = ((AdbCommandComponent)builder.androidSdk(androidSdk2).build()).getAdbCommands();
        }
        if (LocalAndroidDeviceProviderExtKt.isValid(this.getDeviceProviderConfig())) {
            AdbCommands adbCommands = this.adbCommands;
            if (adbCommands == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbCommands");
                adbCommands = null;
            }
            androidDevice = this.connectAndReturnDevice(adbCommands, this.getDeviceProviderConfig());
        } else {
            AdbCommands adbCommands = this.adbCommands;
            if (adbCommands == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbCommands");
                adbCommands = null;
            }
            androidDevice = this.findDevice(adbCommands, this.getDeviceProviderConfig());
        }
        return androidDevice;
    }

    @NotNull
    public DeviceController provideDevice() {
        DeviceController deviceController = null;
        try {
            AndroidSdk androidSdk;
            Setup setup;
            AndroidDeviceProvider androidDeviceProvider = this;
            Environment environment = this.environment;
            if (environment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
                environment = null;
            }
            if ((setup = this.testSetup) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testSetup");
                setup = null;
            }
            if ((androidSdk = this.androidSdk) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidSdk");
                androidSdk = null;
            }
            AdbConfigProto.AdbConfig adbConfig = this.getDeviceProviderConfig().getAdbConfig();
            Intrinsics.checkNotNullExpressionValue((Object)adbConfig, (String)"deviceProviderConfig.adbConfig");
            RuntimeProto.AndroidInstrumentationRuntime androidInstrumentationRuntime = this.getDeviceProviderConfig().getAndroidInstrumentationRuntime();
            Intrinsics.checkNotNullExpressionValue((Object)androidInstrumentationRuntime, (String)"deviceProviderConfig.androidInstrumentationRuntime");
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            deviceController = AndroidDeviceProviderExtKt.loadAndConfigureAndroidDeviceController$default(androidDeviceProvider, environment, setup, androidSdk, adbConfig, androidInstrumentationRuntime, context, null, 64, null);
        }
        catch (Throwable throwable) {
            throw new DeviceProviderException("Loading and configuring DeviceController failed, make sure the device controller is present as a part of the same jar the DeviceProvider is part of.", (ErrorSummary)DeviceProviderErrorSummary.UNDETERMINED, throwable);
        }
        deviceController.setDevice((Device)this.makeDevice());
        return deviceController;
    }

    public void releaseDevice() {
    }

    private final LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider validateLocalDeviceProviderConfig(LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider config) {
        String string = LocalAndroidDeviceProviderExtKt.getHostOrDefault(config);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.hostOrDefault");
        if (!(!StringsKt.isBlank((CharSequence)string))) {
            boolean bl = false;
            String string2 = "DeviceProviderConfig must contain adbServerPort and either host, was given:\n" + config;
            throw new IllegalArgumentException(string2.toString());
        }
        return config;
    }

    private final boolean deviceIsConnected(String deviceSerial) {
        boolean bl;
        block4: {
            AdbCommands adbCommands = this.adbCommands;
            if (adbCommands == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbCommands");
                adbCommands = null;
            }
            ListDevicesCmd listDevicesCmd = adbCommands.getListDevices().get();
            Intrinsics.checkNotNullExpressionValue((Object)listDevicesCmd, (String)"adbCommands.listDevices.get()");
            Iterable $this$any$iv = ListDevicesCmd.DefaultImpls.execute$default(listDevicesCmd, null, 1, null).getDevices();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)deviceSerial)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final AndroidDevice connectAndReturnDevice(AdbCommands adbCommands, LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider config) {
        AndroidDevice device;
        Environment environment = this.environment;
        if (environment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment = null;
        }
        if ((device = AndroidDeviceFromConfigKt.deviceFromConfig(config, environment)).getPort() == null || device.getType() == Device.DeviceType.PHYSICAL) {
            return device;
        }
        if (this.deviceIsConnected(device.getSerial())) {
            return device;
        }
        logger.fine("Connecting to device: " + device.getSerial());
        ConnectCmd connectCmd = adbCommands.getConnect().get();
        Intrinsics.checkNotNullExpressionValue((Object)connectCmd, (String)"connectCmd");
        String string = device.getHost();
        Integer n = device.getPort();
        Intrinsics.checkNotNull((Object)n);
        int exitCode = ConnectCmd.DefaultImpls.connect$default(connectCmd, string, n, null, 4, null);
        if (exitCode != 0) {
            throw new DeviceProviderException("Couldn't connect to device: " + device.getSerial(), null, null, 6, null);
        }
        return device;
    }

    private final AndroidDevice findDevice(AdbCommands adbCommands, LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider config) {
        AndroidDevice androidDevice;
        Environment environment;
        ListDevicesCmd listDevicesCmd = adbCommands.getListDevices().get();
        Intrinsics.checkNotNullExpressionValue((Object)listDevicesCmd, (String)"adbCommands.listDevices.get()");
        DevicesList deviceList = ListDevicesCmd.DefaultImpls.execute$default(listDevicesCmd, null, 1, null);
        List<String> devices = deviceList.getDevices();
        logger.fine("Found " + devices.size() + " device(s): " + devices);
        if (devices.isEmpty()) {
            throw new DeviceProviderException(StringsKt.trimMargin$default((String)("Unable to find an Android device. Adb exit code: " + deviceList.getExitCode() + ".\n          |Did you forget to start/plug in your device? Also check whether your device is listed\n          |when running `adb devices`. If your device is plugged in but not listed, it's likely adb\n          |did not connect to your device automatically, as adb only looks for devices listening on\n          |ports between 5555 and 5585. Try manually connecting to the device using\n          |`adb connect $DEVICE_IP_ADDRESS:$PORT` if your device is using a port outside\n          |of the range.\n          "), null, (int)1, null), null, null, 6, null);
        }
        if (devices.size() > 1) {
            logger.info("More than one device found. Using the first device: " + devices.get(0));
        }
        if ((environment = this.environment) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            environment = null;
        }
        AndroidDevice it = androidDevice = AndroidDeviceFromSerialKt.deviceFromSerial(devices.get(0), config, environment);
        boolean bl = false;
        logger.fine("Using device: " + it);
        return androidDevice;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lcom/google/testing/platform/runtime/android/provider/local/LocalAndroidDeviceProvider$Companion;", "", "()V", "DEFAULT_ADB_COMMAND_TIMEOUT_SECONDS", "", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "java_com_google_testing_platform_runtime_android_provider_local-local_android_device_provider"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

