/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.provider.local;

import com.google.testing.platform.api.config.Environment;
import com.google.testing.platform.api.device.Device;
import com.google.testing.platform.config.v1.extension.LocalAndroidDeviceProviderExtKt;
import com.google.testing.platform.proto.api.config.LocalAndroidDeviceProviderProto;
import com.google.testing.platform.runtime.android.device.AndroidDevice;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a.\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DEFAULT_HOST", "", "EMULATOR_REGEX", "Lkotlin/text/Regex;", "HOST_REGEX", "deviceFromSerial", "Lcom/google/testing/platform/runtime/android/device/AndroidDevice;", "serial", "config", "Lcom/google/testing/platform/proto/api/config/LocalAndroidDeviceProviderProto$LocalAndroidDeviceProvider;", "environment", "Lcom/google/testing/platform/api/config/Environment;", "tryParseSerial", "Lkotlin/text/MatchResult$Destructured;", "pattern", "block", "Lkotlin/Function1;", "", "java_com_google_testing_platform_runtime_android_provider_local-android_device_from_serial"})
public final class AndroidDeviceFromSerialKt {
    @NotNull
    private static final String DEFAULT_HOST = "localhost";
    @NotNull
    private static final Regex EMULATOR_REGEX = new Regex("\\w+[\\-](\\d+)");
    @NotNull
    private static final Regex HOST_REGEX = new Regex("([\\w\\-]+)[:](\\d+)");

    @NotNull
    public static final AndroidDevice deviceFromSerial(@NotNull String serial, @NotNull LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider config, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Ref.ObjectRef hostName = new Ref.ObjectRef();
        String string = config.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.host");
        hostName.element = !StringsKt.isBlank((CharSequence)string) ? config.getHost() : DEFAULT_HOST;
        Ref.ObjectRef adbPort = new Ref.ObjectRef();
        Ref.ObjectRef consolePort = new Ref.ObjectRef();
        Ref.ObjectRef deviceType = new Ref.ObjectRef();
        deviceType.element = Device.DeviceType.valueOf((String)config.getDeviceType().name());
        AndroidDeviceFromSerialKt.tryParseSerial(EMULATOR_REGEX, serial, (Function1<? super MatchResult.Destructured, Unit>)((Function1)new Function1<MatchResult.Destructured, Unit>((Ref.ObjectRef<Integer>)consolePort, (Ref.ObjectRef<Integer>)adbPort, config, (Ref.ObjectRef<Device.DeviceType>)deviceType){
            final /* synthetic */ Ref.ObjectRef<Integer> $consolePort;
            final /* synthetic */ Ref.ObjectRef<Integer> $adbPort;
            final /* synthetic */ LocalAndroidDeviceProviderProto.LocalAndroidDeviceProvider $config;
            final /* synthetic */ Ref.ObjectRef<Device.DeviceType> $deviceType;
            {
                this.$consolePort = $consolePort;
                this.$adbPort = $adbPort;
                this.$config = $config;
                this.$deviceType = $deviceType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MatchResult.Destructured destructured) {
                Integer n;
                void it;
                Intrinsics.checkNotNullParameter((Object)destructured, (String)"<name for destructuring parameter 0>");
                String port = (String)destructured.getMatch().getGroupValues().get(1);
                this.$consolePort.element = Integer.parseInt(port);
                int n2 = this.$config.getAdbPort();
                Ref.ObjectRef<Integer> objectRef = this.$consolePort;
                int n3 = n2;
                Ref.ObjectRef<Integer> objectRef2 = this.$adbPort;
                boolean bl = false;
                if (it > 0) {
                    n = (int)it;
                } else {
                    Integer n4 = (Integer)objectRef.element;
                    n = n4 != null ? Integer.valueOf(n4 + 1) : null;
                }
                objectRef2.element = n;
                if (this.$deviceType.element == Device.DeviceType.UNKNOWN_DEVICE) {
                    this.$deviceType.element = Device.DeviceType.VIRTUAL;
                }
            }
        }));
        if (consolePort.element == null) {
            AndroidDeviceFromSerialKt.tryParseSerial(HOST_REGEX, serial, (Function1<? super MatchResult.Destructured, Unit>)((Function1)new Function1<MatchResult.Destructured, Unit>((Ref.ObjectRef<String>)hostName, (Ref.ObjectRef<Integer>)adbPort){
                final /* synthetic */ Ref.ObjectRef<String> $hostName;
                final /* synthetic */ Ref.ObjectRef<Integer> $adbPort;
                {
                    this.$hostName = $hostName;
                    this.$adbPort = $adbPort;
                    super(1);
                }

                public final void invoke(@NotNull MatchResult.Destructured destructured) {
                    Intrinsics.checkNotNullParameter((Object)destructured, (String)"<name for destructuring parameter 0>");
                    String host = (String)destructured.getMatch().getGroupValues().get(1);
                    String port = (String)destructured.getMatch().getGroupValues().get(2);
                    this.$hostName.element = host;
                    this.$adbPort.element = Integer.parseInt(port);
                }
            }));
        }
        String string2 = (String)hostName.element;
        Device.DeviceType deviceType2 = (Device.DeviceType)deviceType.element;
        Integer n = (Integer)adbPort.element;
        Integer n2 = (Integer)consolePort.element;
        Integer n3 = LocalAndroidDeviceProviderExtKt.getAdbServerPortOrDefault(config);
        AndroidDeviceProperties androidDeviceProperties = new AndroidDeviceProperties(null, null, null, null, null, null, null, environment.getAndroidLogcatOptions(), null, 383, null);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hostName");
        return new AndroidDevice(string2, serial, deviceType2, n, androidDeviceProperties, n2, n3);
    }

    private static final MatchResult.Destructured tryParseSerial(Regex pattern, String serial, Function1<? super MatchResult.Destructured, Unit> block) {
        MatchResult matchResult;
        MatchResult matchResult2 = pattern.matchEntire((CharSequence)serial);
        if (matchResult2 != null && (matchResult2 = matchResult2.getDestructured()) != null) {
            MatchResult matchResult3 = matchResult2;
            block.invoke((Object)matchResult3);
            matchResult = matchResult3;
        } else {
            matchResult = null;
        }
        return matchResult;
    }
}

