/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.process.logger;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0016\u0010\u0015\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\u0016\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010\u0018\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/google/testing/platform/lib/process/logger/LoggerHelpers;", "", "()V", "ADB_EQUIVALENTS", "", "", "ADB_FLAGS_WITH_ARGS", "ANDROID_PREFIX_COMMANDS", "BASH", "Lkotlin/text/Regex;", "DIRECT_ADB_COMMANDS", "INVALID_FILENAME_CHARS", "MAX_FILENAME_LENGTH", "", "SH_VARIABLE_ASSIGNMENT", "WHITESPACE", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "summarizeAdbCommand", "args", "summarizeBashCommand", "summarizeCommandForFilename", "truncateEnd", "truncateStart", "lib_java_com_google_testing_platform_lib_process_logger-logger_helpers"})
public final class LoggerHelpers {
    @NotNull
    public static final LoggerHelpers INSTANCE = new LoggerHelpers();
    @NotNull
    private static final List<String> ADB_EQUIVALENTS;
    @NotNull
    private static final List<String> ADB_FLAGS_WITH_ARGS;
    @NotNull
    private static final List<String> ANDROID_PREFIX_COMMANDS;
    @NotNull
    private static final Regex BASH;
    @NotNull
    private static final List<String> DIRECT_ADB_COMMANDS;
    @NotNull
    private static final Regex INVALID_FILENAME_CHARS;
    private static final int MAX_FILENAME_LENGTH;
    @NotNull
    private static final Regex SH_VARIABLE_ASSIGNMENT;
    @NotNull
    private static final Regex WHITESPACE;
    private static final Logger logger;

    private LoggerHelpers() {
    }

    private final String truncateStart(String $this$truncateStart) {
        return $this$truncateStart.length() > MAX_FILENAME_LENGTH ? "..." + StringsKt.takeLast((String)$this$truncateStart, (int)MAX_FILENAME_LENGTH) : $this$truncateStart;
    }

    private final String truncateEnd(String $this$truncateEnd) {
        return $this$truncateEnd.length() > MAX_FILENAME_LENGTH ? StringsKt.take((String)$this$truncateEnd, (int)MAX_FILENAME_LENGTH) + "..." : $this$truncateEnd;
    }

    @NotNull
    public final String summarizeCommandForFilename(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        logger.finest('[' + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)"] [", null, null, (int)0, null, null, (int)62, null) + ']');
        if (args.isEmpty()) {
            return "NO_COMMAND";
        }
        List<String> argv = args;
        CharSequence charSequence = (CharSequence)CollectionsKt.first(argv);
        if (WHITESPACE.containsMatchIn(charSequence)) {
            charSequence = (CharSequence)CollectionsKt.first(argv);
            Regex regex = WHITESPACE;
            int n = 0;
            return this.summarizeCommandForFilename(regex.split(charSequence, n));
        }
        CharSequence charSequence2 = (CharSequence)CollectionsKt.first(argv);
        Object object = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
        String filename = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)charSequence2, (String[])object, (boolean)false, (int)0, (int)6, null));
        if (argv.size() >= 2) {
            if (ADB_EQUIVALENTS.contains(filename)) {
                return this.summarizeAdbCommand(CollectionsKt.drop((Iterable)argv, (int)1));
            }
            if (ANDROID_PREFIX_COMMANDS.contains(filename)) {
                return this.truncateEnd(filename + '.' + argv.get(1));
            }
            if (BASH.matches((CharSequence)filename)) {
                return this.summarizeBashCommand(CollectionsKt.drop((Iterable)argv, (int)1));
            }
            if (DIRECT_ADB_COMMANDS.contains(filename)) {
                return this.summarizeAdbCommand(argv);
            }
        }
        object = filename;
        Regex regex = INVALID_FILENAME_CHARS;
        String string = "_";
        return this.truncateEnd(regex.replace((CharSequence)object, string));
    }

    /*
     * WARNING - void declaration
     */
    private final String summarizeAdbCommand(List<String> args) {
        logger.finest('[' + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)"] [", null, null, (int)0, null, null, (int)62, null) + ']');
        List argv = args;
        while (argv.size() >= 2) {
            if (ADB_FLAGS_WITH_ARGS.contains(CollectionsKt.first(argv))) {
                argv = CollectionsKt.drop((Iterable)argv, (int)2);
                continue;
            }
            if (!StringsKt.startsWith$default((String)((String)CollectionsKt.first(argv)), (String)"-", (boolean)false, (int)2, null)) break;
            argv = CollectionsKt.drop((Iterable)argv, (int)1);
        }
        if (argv.size() >= 2) {
            if (Intrinsics.areEqual((Object)CollectionsKt.first(argv), (Object)"shell")) {
                argv = CollectionsKt.drop((Iterable)argv, (int)1);
                while (argv.size() > 0 && SH_VARIABLE_ASSIGNMENT.matches((CharSequence)CollectionsKt.first((List)argv))) {
                    argv = CollectionsKt.drop((Iterable)argv, (int)1);
                }
                return this.summarizeCommandForFilename(argv);
            }
            if (Intrinsics.areEqual((Object)CollectionsKt.first((List)argv), (Object)"install")) {
                argv = CollectionsKt.drop((Iterable)argv, (int)1);
                while (argv.size() >= 1 && StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)argv)), (String)"-", (boolean)false, (int)2, null)) {
                    Object[] objectArray;
                    if (argv.size() >= 2 && CollectionsKt.listOf((Object[])(objectArray = new String[]{"-i", "-p", "--user"})).contains(CollectionsKt.first((List)argv))) {
                        argv = CollectionsKt.drop((Iterable)argv, (int)2);
                        continue;
                    }
                    argv = CollectionsKt.drop((Iterable)argv, (int)1);
                }
                if (argv.size() >= 1) {
                    CharSequence charSequence = (CharSequence)CollectionsKt.first((List)argv);
                    String[] stringArray = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
                    String apk = this.truncateStart((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
                    return "install." + apk;
                }
                return "install";
            }
            Object[] apk = new String[]{"pull", "push"};
            if (CollectionsKt.listOf((Object[])apk).contains(CollectionsKt.first((List)argv))) {
                CharSequence charSequence;
                LoggerHelpers loggerHelpers;
                String[] stringArray;
                String verb;
                block15: {
                    void $this$trimEnd$iv;
                    verb = (String)CollectionsKt.first((List)argv);
                    argv = CollectionsKt.drop((Iterable)argv, (int)1);
                    while (argv.size() >= 1) {
                        if (argv.size() >= 2 && Intrinsics.areEqual((Object)CollectionsKt.first((List)argv), (Object)"-z")) {
                            argv = CollectionsKt.drop((Iterable)argv, (int)2);
                            continue;
                        }
                        if (!StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)argv)), (String)"-", (boolean)false, (int)2, null)) break;
                        argv = CollectionsKt.drop((Iterable)argv, (int)1);
                    }
                    if (argv.size() == 0) {
                        return verb;
                    }
                    stringArray = (String[])CollectionsKt.first((List)argv);
                    loggerHelpers = this;
                    boolean $i$f$trimEnd = false;
                    CharSequence $this$trimEnd$iv$iv = (CharSequence)$this$trimEnd$iv;
                    boolean $i$f$trimEnd2 = false;
                    int n = $this$trimEnd$iv$iv.length() + -1;
                    if (0 <= n) {
                        do {
                            int index$iv$iv = n--;
                            char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            String string = File.separator;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
                            if (StringsKt.contains$default((CharSequence)string, (char)it, (boolean)false, (int)2, null)) continue;
                            charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                            break block15;
                        } while (0 <= n);
                    }
                    charSequence = "";
                }
                CharSequence charSequence2 = ((Object)charSequence).toString();
                stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
                String target = loggerHelpers.truncateStart((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)charSequence2, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
                return verb + '.' + target;
            }
        }
        return (String)CollectionsKt.first(argv);
    }

    private final String summarizeBashCommand(List<String> args) {
        logger.finest('[' + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)"] [", null, null, (int)0, null, null, (int)62, null) + ']');
        List argv = args;
        while (argv.size() >= 2) {
            if (Intrinsics.areEqual((Object)CollectionsKt.first(argv), (Object)"-c")) {
                String[] stringArray;
                argv = CollectionsKt.drop((Iterable)argv, (int)1);
                String line = (String)CollectionsKt.first((List)argv);
                while (SH_VARIABLE_ASSIGNMENT.containsMatchIn((CharSequence)(stringArray = (String[])line))) {
                    stringArray = line;
                    Regex regex = SH_VARIABLE_ASSIGNMENT;
                    String string = "";
                    line = regex.replace((CharSequence)stringArray, string);
                }
                stringArray = new String[]{" "};
                return this.summarizeCommandForFilename(StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            if (StringsKt.startsWith$default((String)((String)CollectionsKt.first(argv)), (String)"-", (boolean)false, (int)2, null)) {
                argv = CollectionsKt.drop((Iterable)argv, (int)1);
                continue;
            }
            if (!SH_VARIABLE_ASSIGNMENT.matches((CharSequence)CollectionsKt.first((List)argv))) break;
            argv = CollectionsKt.drop((Iterable)argv, (int)1);
        }
        return this.summarizeCommandForFilename(argv);
    }

    static {
        Object[] objectArray = new String[]{"adb", "adb.static", "waterfall_bin"};
        ADB_EQUIVALENTS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"-s", "-H", "-P", "-t", "-L", "--one-device"};
        ADB_FLAGS_WITH_ARGS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"am", "pm"};
        ANDROID_PREFIX_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
        BASH = new Regex("(/.*/)?(ba)?sh$");
        objectArray = new String[]{"install", "pull", "push"};
        DIRECT_ADB_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
        INVALID_FILENAME_CHARS = new Regex("[^-=@.,\\w]");
        MAX_FILENAME_LENGTH = 64;
        SH_VARIABLE_ASSIGNMENT = new Regex("^\\w+=(\\$\\([^)]+\\)|\\S*)\\s*");
        WHITESPACE = new Regex("\\s+");
        logger = Logger.getLogger("LoggerHelpers");
    }
}

