/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.process.logger;

import com.google.testing.platform.lib.process.logger.DefaultSubprocessLogger;
import com.google.testing.platform.lib.process.logger.LoggerHelpers;
import com.google.testing.platform.lib.process.logger.SubprocessLogger;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J*\u0010\u0011\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0096\u0001R\u000e\u0010\t\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/testing/platform/lib/process/logger/AdbSubprocessLogger;", "Lcom/google/testing/platform/lib/process/logger/SubprocessLogger;", "logDir", "", "flushEagerly", "", "(Ljava/lang/String;Z)V", "delegateSubprocessLogger", "(Lcom/google/testing/platform/lib/process/logger/SubprocessLogger;)V", "adbSubCommandPrefix", "originalPrefix", "finishLogging", "exitCode", "", "getLogPrefix", "args", "", "startLogging", "", "environment", "", "writeLine", "line", "lib_java_com_google_testing_platform_lib_process_logger-subprocess_logger"})
public final class AdbSubprocessLogger
implements SubprocessLogger {
    @NotNull
    private final SubprocessLogger delegateSubprocessLogger;
    private String originalPrefix;
    private String adbSubCommandPrefix;

    public AdbSubprocessLogger(@NotNull SubprocessLogger delegateSubprocessLogger) {
        Intrinsics.checkNotNullParameter((Object)delegateSubprocessLogger, (String)"delegateSubprocessLogger");
        this.delegateSubprocessLogger = delegateSubprocessLogger;
    }

    @Override
    public void writeLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.delegateSubprocessLogger.writeLine(line);
    }

    @Inject
    public AdbSubprocessLogger(@NotNull String logDir, boolean flushEagerly) {
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        this(new DefaultSubprocessLogger(logDir, flushEagerly));
    }

    public /* synthetic */ AdbSubprocessLogger(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @Override
    public void startLogging(@NotNull List<String> args, @NotNull Map<String, String> environment) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        this.delegateSubprocessLogger.startLogging(args, environment);
        this.adbSubCommandPrefix = this.getLogPrefix(args);
    }

    @Override
    @NotNull
    public String getLogPrefix(@NotNull List<String> args) {
        String commandPrefix;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.originalPrefix = commandPrefix = this.delegateSubprocessLogger.getLogPrefix(args);
        return commandPrefix + '.' + LoggerHelpers.INSTANCE.summarizeCommandForFilename(args);
    }

    @Override
    @NotNull
    public String finishLogging(int exitCode) {
        boolean bl;
        List components;
        String newLogFileName;
        File existingLogFile;
        block4: {
            String string;
            String logFilePath = this.delegateSubprocessLogger.finishLogging(exitCode);
            existingLogFile = new File(logFilePath);
            String string2 = existingLogFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"existingLogFile.name");
            String string3 = this.originalPrefix;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"originalPrefix");
                string3 = null;
            }
            if ((string = this.adbSubCommandPrefix) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adbSubCommandPrefix");
                string = null;
            }
            newLogFileName = StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null);
            String[] stringArray = new String[]{"."};
            components = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)newLogFileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            CharSequence $this$all$iv = (CharSequence)components.get(components.size() - 3);
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isDigit(it)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            int sequence = Integer.parseInt((String)components.remove(components.size() - 3));
            components.add(1, StringsKt.padStart((String)String.valueOf(sequence), (int)3, (char)'0'));
            newLogFileName = CollectionsKt.joinToString$default((Iterable)components, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }
        String[] stringArray = new String[]{newLogFileName};
        File newFile = Paths.get(existingLogFile.getParent(), stringArray).toFile();
        boolean bl3 = false;
        existingLogFile.renameTo(newFile);
        String string = newFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(existingLogFile.pare\u2026ewFile.absolutePath\n    }");
        return string;
    }
}

