/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.subprocess.executor;

import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.lib.adb.command.CommandExecutor;
import com.google.testing.platform.lib.adb.command.DeviceCommandExecutor;
import com.google.testing.platform.lib.adb.command.inject.AdbConfig;
import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/testing/platform/lib/adb/command/subprocess/executor/AdbDeviceCommandExecutor;", "Lcom/google/testing/platform/lib/adb/command/DeviceCommandExecutor;", "config", "Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;", "adbCommandExecutor", "Lcom/google/testing/platform/lib/adb/command/CommandExecutor;", "(Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;Lcom/google/testing/platform/lib/adb/command/CommandExecutor;)V", "execute", "Lcom/google/testing/platform/api/device/CommandResult;", "commandArgs", "", "", "timeout", "Ljava/time/Duration;", "([Ljava/lang/String;Ljava/time/Duration;)Lcom/google/testing/platform/api/device/CommandResult;", "executeAsync", "Lcom/google/testing/platform/api/device/CommandHandle;", "processor", "Lkotlin/Function1;", "", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lcom/google/testing/platform/api/device/CommandHandle;", "supplyTargetDevice", "([Ljava/lang/String;)[Ljava/lang/String;", "lib_java_com_google_testing_platform_lib_adb_command_subprocess_executor-adb_device_command_executor"})
public final class AdbDeviceCommandExecutor
implements DeviceCommandExecutor {
    @NotNull
    private final AdbConfig config;
    @NotNull
    private final CommandExecutor adbCommandExecutor;

    @Inject
    public AdbDeviceCommandExecutor(@NotNull AdbConfig config, @NotNull CommandExecutor adbCommandExecutor) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)adbCommandExecutor, (String)"adbCommandExecutor");
        this.config = config;
        this.adbCommandExecutor = adbCommandExecutor;
        CharSequence charSequence = this.config.getDeviceSerial();
        if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
            boolean bl = false;
            String string = "Invalid adb config. No device serial specified.\n" + this.config;
            throw new IllegalStateException(string.toString());
        }
    }

    private final String[] supplyTargetDevice(String[] commandArgs) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)"-s");
        String string = this.config.getDeviceSerial();
        Intrinsics.checkNotNull((Object)string);
        spreadBuilder.add((Object)string);
        spreadBuilder.addSpread((Object)commandArgs);
        return (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull String[] commandArgs, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)commandArgs, (String)"commandArgs");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.adbCommandExecutor.execute(this.supplyTargetDevice(commandArgs), timeout);
    }

    @Override
    @NotNull
    public CommandHandle executeAsync(@NotNull String[] commandArgs, @NotNull Function1<? super String, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)commandArgs, (String)"commandArgs");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return this.adbCommandExecutor.executeAsync(this.supplyTargetDevice(commandArgs), processor);
    }
}

